/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.pluginsettings;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import jd.gui.swing.jdgui.views.settings.panels.pluginsettings.PluginConfigPanel;
import jd.gui.swing.jdgui.views.settings.sidebar.AddonConfig;
import jd.plugins.Account;
import jd.plugins.Plugin;
import jd.plugins.PluginConfigPanelNG;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.swing.components.searchcombo.SearchComboBox;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.actions.AppAction;
import org.jdownloader.extensions.Header;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.crawler.CrawlerPluginController;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class PluginSettingsPanel
extends JPanel
implements SettingsComponent,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final Icon decryterIcon = new AbstractIcon("linkgrabber", 16);
    private MigPanel card;
    protected SwitchPanel configPanel;
    protected List<Pattern> filter;
    private Header header;
    private SearchComboBox<LazyPlugin<?>> searchCombobox;
    private ExtButton resetButton;
    private LogSource logger = LogController.getInstance().getLogger(PluginSettingsPanel.class.getName());
    private LazyPlugin<?> currentItem = null;
    private JScrollPane sp;
    protected PluginConfigPanelNG newCP;
    private Account scrollToAccount;

    public void addStateUpdateListener(StateUpdateListener listener) {
        throw new IllegalStateException("Not implemented");
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public PluginSettingsPanel() {
        super((LayoutManager)new MigLayout("ins 0,wrap 1", "[grow,fill]", "[][][grow,fill]"));
        this.searchCombobox = new SearchComboBox<LazyPlugin<?>>(){
            final Icon linkgrabber = new AbstractIcon("linkgrabber", 12);

            protected Icon getIconForValue(LazyPlugin<?> value) {
                if (value == null) {
                    return null;
                }
                Icon favIcon = value.getDomainInfo().getFavIcon(false);
                if (value instanceof LazyHostPlugin) {
                    return favIcon;
                }
                ExtMergedIcon ret = new ExtMergedIcon(favIcon){

                    protected void idIconCheck(ExtMergedIcon.Entry entry) {
                    }
                }.add(this.linkgrabber, 6, 6);
                return ret;
            }

            protected boolean matches(String element, String matches) {
                if (super.matches(element, matches)) {
                    return true;
                }
                return element != null && matches != null && matches.length() >= 3 && StringUtils.containsIgnoreCase((String)element, (String)matches);
            }

            private int booleanCompare(boolean x, boolean y) {
                return x == y ? 0 : (x ? 1 : -1);
            }

            protected void sortFound(final String search, List<LazyPlugin<?>> found) {
                Collections.sort(found, new Comparator<LazyPlugin<?>>(){

                    @Override
                    public int compare(LazyPlugin<?> o1, LazyPlugin<?> o2) {
                        return this.booleanCompare(this.matches(this.getTextForValue(o1), search), this.matches(this.getTextForValue(o2), search));
                    }
                });
            }

            protected void setListSearchResults(List<LazyPlugin<?>> found, List<LazyPlugin<?>> all) {
                ArrayList newList = new ArrayList();
                newList.addAll(all);
                newList.removeAll(found);
                newList.addAll(0, found);
                this.setList(newList);
            }

            protected String getTextForValue(LazyPlugin<?> value) {
                if (value == null) {
                    return "";
                }
                return value.getDisplayName();
            }
        };
        this.searchCombobox.setActualMaximumRowCount(20);
        this.searchCombobox.addActionListener((ActionListener)this);
        this.setOpaque(false);
        this.resetButton = new ExtButton((AbstractAction)new AppAction(){
            {
                this.setIconKey("reset");
                this.setTooltipText(_GUI.T.PluginSettingsPanel_PluginSettingsPanel_reset());
            }

            public void actionPerformed(ActionEvent e) {
                if (PluginSettingsPanel.this.configPanel != null && PluginSettingsPanel.this.configPanel.isShown()) {
                    Plugin proto = null;
                    try {
                        if (PluginSettingsPanel.this.currentItem != null) {
                            Dialog.getInstance().showConfirmDialog(0, _GUI.T.lit_are_you_sure(), _GUI.T.PluginSettingsPanel_are_you_sure(PluginSettingsPanel.this.currentItem.getDisplayName()));
                            proto = PluginSettingsPanel.this.currentItem.getPrototype(null);
                            PluginConfigPanelNG ccp = proto.getConfigPanel();
                            if (ccp != null) {
                                ccp.reset();
                            } else {
                                proto.getPluginConfig().reset();
                                AddonConfig.getInstance(proto.getConfig(), "", false).reload();
                            }
                            PluginSettingsPanel.this.configPanel = null;
                            PluginSettingsPanel.this.show(PluginSettingsPanel.this.currentItem);
                            Dialog.getInstance().showMessageDialog(_GUI.T.PluginSettingsPanel_actionPerformed_reset_done(PluginSettingsPanel.this.currentItem.getDisplayName()));
                        }
                    }
                    catch (UpdateRequiredClassNotFoundException e1) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e1);
                    }
                    catch (DialogClosedException e1) {
                        e1.printStackTrace();
                    }
                    catch (DialogCanceledException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.card = new MigPanel("ins 3 0 0 0", "[grow,fill]", "[grow,fill]");
        this.header = new Header("", null);
        this.card.setOpaque(false);
        if (CrawlerPluginController.list((boolean)false) == null) {
            MigPanel loaderPanel = new MigPanel("ins 0,wrap 1", "[grow]", "50[][]");
            loaderPanel.setOpaque(false);
            loaderPanel.setBackground(null);
            CircledProgressBar loader = new CircledProgressBar();
            loader.setValueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("botty/robot", 256), 1.0f));
            loader.setNonvalueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("botty/robot", 256), 0.1f));
            ((ImagePainter)loader.getValueClipPainter()).setBackground(null);
            ((ImagePainter)loader.getValueClipPainter()).setForeground(null);
            loader.setIndeterminate(true);
            loaderPanel.add((Component)loader, (Object)"width 256!,height 256!,alignx center");
            loaderPanel.add((Component)new JLabel(_GUI.T.PluginSettingsPanel_PluginSettingsPanel_waittext_()), (Object)"alignx center");
            this.add((Component)loaderPanel, "spanx,pushx,growx,spany,growy,pushy");
        }
        new Thread("Plugin Init"){

            @Override
            public void run() {
                PluginSettingsPanel.this.fill();
                new EDTRunner(){

                    protected void runInEDT() {
                        PluginSettingsPanel.this.removeAll();
                        PluginSettingsPanel.this.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.PluginSettingsPanel_runInEDT_choose_())), "split 3,shrinkx");
                        PluginSettingsPanel.this.add((Component)PluginSettingsPanel.this.searchCombobox, "pushx,growx,height 24!");
                        PluginSettingsPanel.this.add((Component)PluginSettingsPanel.this.resetButton, "width 22!,height 24!");
                        PluginSettingsPanel.this.add((Component)PluginSettingsPanel.this.header, "growx,pushx,gaptop 10");
                        PluginSettingsPanel.this.add((Component)PluginSettingsPanel.this.card, "spanx,pushx,growx");
                        if (PluginSettingsPanel.this.searchCombobox.getModel().getSize() > 0) {
                            String activePlugin = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getActivePluginConfigPanel();
                            PluginSettingsPanel.this.setPlugin(activePlugin);
                        }
                    }
                };
            }
        }.start();
    }

    private void setPlugin(final String pluginID) {
        new EDTRunner(){

            protected void runInEDT() {
                if (PluginSettingsPanel.this.searchCombobox.getModel().getSize() > 0) {
                    int selectIndex = 0;
                    if (pluginID != null) {
                        for (int i = 0; i < PluginSettingsPanel.this.searchCombobox.getModel().getSize(); ++i) {
                            LazyPlugin plugin = (LazyPlugin)PluginSettingsPanel.this.searchCombobox.getModel().getElementAt(i);
                            if (!StringUtils.startsWithCaseInsensitive((String)pluginID, (String)plugin.getClassName()) || !plugin.getID().equals(pluginID)) continue;
                            selectIndex = i;
                            break;
                        }
                    }
                    PluginSettingsPanel.this.searchCombobox.setSelectedIndex(selectIndex);
                }
            }
        };
    }

    public void setPlugin(final LazyPlugin<?> plugin) {
        new EDTRunner(){

            protected void runInEDT() {
                if (plugin != null) {
                    if (PluginSettingsPanel.this.searchCombobox.getModel().getSize() > 0) {
                        PluginSettingsPanel.this.setPlugin(plugin.getID());
                    } else {
                        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setActivePluginConfigPanel(plugin.getID());
                    }
                }
            }
        };
    }

    private void fill() {
        this.searchCombobox.setList(this.fillModel());
    }

    public List<LazyPlugin<?>> fillModel() {
        ArrayList lst = new ArrayList();
        for (LazyHostPlugin plg : HostPluginController.getInstance().list()) {
            if (!plg.isHasConfig() && (!plg.isPremium() || !plg.isHasPremiumConfig() && !plg.hasFeature(new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.MULTIHOST}))) continue;
            lst.add((LazyPlugin<?>)plg);
        }
        for (LazyHostPlugin plg : CrawlerPluginController.getInstance().list()) {
            if (!plg.isHasConfig()) continue;
            lst.add((LazyPlugin<?>)plg);
        }
        Collections.sort(lst, new Comparator<LazyPlugin<?>>(){

            @Override
            public int compare(LazyPlugin<?> o1, LazyPlugin<?> o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
        return lst;
    }

    @Override
    public String getConstraints() {
        return "wmin 10,height 200:n:n,growy,pushy";
    }

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LazyPlugin selected = (LazyPlugin)this.searchCombobox.getSelectedItem();
        if (selected != null) {
            ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setActivePluginConfigPanel(selected.getID());
            this.show(selected);
        }
    }

    private void show(final LazyPlugin<?> selectedItem) {
        new EDTRunner(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInEDT() {
                PluginSettingsPanel.this.card.removeAll();
                if (PluginSettingsPanel.this.configPanel != null) {
                    PluginSettingsPanel.this.configPanel.setHidden();
                }
                PluginSettingsPanel.this.currentItem = selectedItem;
                try {
                    JDGui.getInstance().setWaiting(true);
                    Plugin protoType = selectedItem.getPrototype(null);
                    PluginSettingsPanel.this.newCP = protoType.getConfigPanel();
                    if (PluginSettingsPanel.this.newCP == null && selectedItem instanceof LazyHostPlugin && !((LazyHostPlugin)selectedItem).isHasConfig() && ((LazyHostPlugin)selectedItem).isPremium()) {
                        throw new WTFException("Should not happen");
                    }
                    PluginSettingsPanel.this.sp = null;
                    if (PluginSettingsPanel.this.newCP != null) {
                        PluginSettingsPanel.this.newCP.initLayout(protoType);
                        PluginSettingsPanel.this.configPanel = PluginSettingsPanel.this.scrollerWrapper((SwitchPanel)PluginSettingsPanel.this.newCP);
                    } else {
                        PluginSettingsPanel.this.configPanel = PluginSettingsPanel.this.scrollerWrapper(PluginConfigPanel.create(selectedItem));
                    }
                    if (PluginSettingsPanel.this.configPanel != null) {
                        PluginSettingsPanel.this.configPanel.setShown();
                        PluginSettingsPanel.this.card.add((Component)PluginSettingsPanel.this.configPanel);
                        if (selectedItem != null) {
                            Icon fav = selectedItem.getDomainInfo().getFavIcon(false);
                            if (selectedItem instanceof LazyHostPlugin) {
                                PluginSettingsPanel.this.header.setText(_GUI.T.PluginSettingsPanel_runInEDT_plugin_header_text_host(selectedItem.getDisplayName()));
                                PluginSettingsPanel.this.header.setIcon(fav);
                            } else {
                                PluginSettingsPanel.this.header.setText(_GUI.T.PluginSettingsPanel_runInEDT_plugin_header_text_decrypt(selectedItem.getDisplayName()));
                                if (fav == null) {
                                    PluginSettingsPanel.this.header.setIcon(PluginSettingsPanel.this.decryterIcon);
                                } else {
                                    ExtMergedIcon ret = new ExtMergedIcon(fav){

                                        protected void idIconCheck(ExtMergedIcon.Entry entry) {
                                        }
                                    }.add(PluginSettingsPanel.this.decryterIcon, 6, 6);
                                    PluginSettingsPanel.this.header.setIcon((Icon)ret);
                                }
                            }
                            PluginSettingsPanel.this.header.setVisible(true);
                        } else {
                            PluginSettingsPanel.this.header.setVisible(false);
                        }
                    }
                }
                catch (UpdateRequiredClassNotFoundException e) {
                    PluginSettingsPanel.this.logger.log((Throwable)e);
                }
                finally {
                    JDGui.getInstance().setWaiting(false);
                }
                PluginSettingsPanel.this.revalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PluginSettingsPanel.this.scrollToAccount(null);
                    }
                });
            }
        };
    }

    protected SwitchPanel scrollerWrapper(final SwitchPanel createConfigPanel) {
        Scroll ret = new Scroll();
        ret.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
        ret.add(createConfigPanel);
        this.sp = new JScrollPane(ret);
        this.sp.getVerticalScrollBar().setUnitIncrement(24);
        this.sp.setBorder(null);
        this.sp.setOpaque(false);
        this.sp.getViewport().setOpaque(false);
        this.sp.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        SwitchPanel wrapper = new SwitchPanel(){
            {
                this.setOpaque(false);
                this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
            }

            @Override
            protected void onShow() {
                createConfigPanel.setShown();
            }

            @Override
            protected void onHide() {
                createConfigPanel.setHidden();
            }
        };
        wrapper.add(this.sp);
        return wrapper;
    }

    public void setHidden() {
        if (this.configPanel != null) {
            this.configPanel.setHidden();
            this.configPanel = null;
        }
        if (this.card != null) {
            this.card.removeAll();
        }
        this.currentItem = null;
    }

    public void setShown() {
        if (this.configPanel != null) {
            this.configPanel.setShown();
        }
    }

    public void scrollToAccount(Account account) {
        if (account == null) {
            account = this.scrollToAccount;
        }
        if (this.sp == null || this.newCP == null || account == null) {
            this.scrollToAccount = account;
            return;
        }
        Rectangle bounds = this.newCP.getAccountRectangle(account);
        if (bounds == null) {
            Dimension pref = this.newCP.getPreferredSize();
            bounds = new Rectangle(0, pref.height - 3, pref.width, 3);
        }
        this.newCP.scrollRectToVisible(bounds);
    }

    public class Scroll
    extends JPanel
    implements Scrollable {
        public Scroll() {
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return Math.max(visibleRect.height * 9 / 10, 1);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return Math.max(visibleRect.height / 10, 1);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container p = this.getParent();
            return p.getSize().width >= this.getMinimumSize().width;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

