/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.proxy;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.gui.swing.jdgui.BasicJDTable;
import jd.gui.swing.jdgui.views.settings.panels.proxy.ProxyAddAction;
import jd.gui.swing.jdgui.views.settings.panels.proxy.ProxyDeleteAction;
import jd.gui.swing.jdgui.views.settings.panels.proxy.ProxyTableModel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTransferHandler;
import org.appwork.utils.Application;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;

public class ProxyTable
extends BasicJDTable<AbstractProxySelectorImpl> {
    private static final long serialVersionUID = 1153823766916158314L;

    public ProxyTable() {
        super(new ProxyTableModel());
        this.setSearchEnabled(true);
        this.setDragEnabled(true);
        this.setTransferHandler(new ExtTransferHandler());
        if (Application.getJavaVersion() >= Application.JAVA16) {
            this.setDropMode(DropMode.INSERT_ROWS);
        }
        this.setSelectionMode(2);
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, AbstractProxySelectorImpl contextObject, List<AbstractProxySelectorImpl> selection, ExtColumn<AbstractProxySelectorImpl> column, MouseEvent ev) {
        popup.add(new JMenuItem((Action)((Object)new ProxyAddAction())));
        popup.add(new JMenuItem((Action)((Object)new ProxyDeleteAction(selection, false))));
        return popup;
    }

    protected boolean onShortcutDelete(List<AbstractProxySelectorImpl> selectedObjects, KeyEvent evt, boolean direct) {
        new ProxyDeleteAction(selectedObjects, direct).actionPerformed(null);
        return true;
    }

    protected boolean onShortcutCopy(List<AbstractProxySelectorImpl> selectedObjects, KeyEvent evt) {
        ProxyTable.export(selectedObjects);
        return true;
    }

    public static void export(List<AbstractProxySelectorImpl> selectedObjects) {
        StringBuilder sb = new StringBuilder();
        for (AbstractProxySelectorImpl pi : selectedObjects) {
            String str = pi.toExportString();
            if (str == null) continue;
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(str);
        }
        ClipboardMonitoring.getINSTANCE().setCurrentContent(sb.toString());
        try {
            Dialog.getInstance().showInputDialog(80, _GUI.T.ProxyTable_copy_export_title_(), null, sb.toString(), NewTheme.getInstance().getIcon("proxy", 32), null, null);
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException dialogCanceledException) {
            // empty catch block
        }
    }
}

