/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.reconnect;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jd.controlling.reconnect.ReconnectPluginController;
import jd.controlling.reconnect.RouterPlugin;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import jd.gui.swing.jdgui.views.settings.panels.reconnect.AutoSetupAction;
import jd.gui.swing.jdgui.views.settings.panels.reconnect.ReconnectTestAction;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;

public class ReconnectManager
extends MigPanel
implements SettingsComponent,
ActionListener,
GenericConfigEventListener<String> {
    private static final long serialVersionUID = 1L;
    private JComboBox combobox;
    private MigPanel card;
    private ExtButton autoSetupButton;
    private ExtButton reconnectTestButton;

    public ReconnectManager() {
        super("ins 0,wrap 3", "[grow,fill][]", "");
        this.initComponents();
        this.layoutComponents();
        this.fill();
        CFG_RECONNECT.ACTIVE_PLUGIN_ID.getEventSender().addListener((EventListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReconnectPluginController.getInstance().setActivePlugin((RouterPlugin)this.combobox.getSelectedItem());
    }

    private void layoutComponents() {
        this.setOpaque(false);
        this.add(this.combobox, "growx, pushx,height 26!");
        this.autoSetupButton = new ExtButton((AbstractAction)((Object)new AutoSetupAction())).setTooltipsEnabled(true);
        this.add((Component)this.autoSetupButton, "height 26!");
        this.reconnectTestButton = new ExtButton((AbstractAction)((Object)new ReconnectTestAction())).setTooltipsEnabled(true);
        this.add((Component)this.reconnectTestButton, "height 26!");
        this.combobox.addActionListener(this);
        this.add((Component)this.card, "spanx,pushy,growy");
    }

    private void fill() {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectManager.this.combobox.setModel(new DefaultComboBoxModel<RouterPlugin>(ReconnectPluginController.getInstance().getPlugins().toArray(new RouterPlugin[0])));
                ReconnectManager.this.combobox.setSelectedItem(ReconnectPluginController.getInstance().getActivePlugin());
                boolean enabled = !"DummyRouterPlugin".equalsIgnoreCase(ReconnectPluginController.getInstance().getActivePlugin().getID());
                ReconnectManager.this.reconnectTestButton.setEnabled(enabled);
                ReconnectManager.this.setView(ReconnectPluginController.getInstance().getActivePlugin().getGUI());
            }
        };
    }

    public void addStateUpdateListener(StateUpdateListener listener) {
        throw new IllegalStateException("Not implemented");
    }

    protected void setView(final JComponent gui) {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectManager.this.card.removeAll();
                ReconnectManager.this.card.add((Component)gui);
            }
        };
    }

    private void initComponents() {
        this.combobox = new JComboBox();
        final ListCellRenderer org = this.combobox.getRenderer();
        this.combobox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel ret = (JLabel)org.getListCellRendererComponent(list, ((RouterPlugin)value).getName(), index, isSelected, cellHasFocus);
                ret.setIcon(((RouterPlugin)value).getIcon16());
                return ret;
            }
        });
        this.card = new MigPanel("ins 0", "[grow,fill]", "[grow,fill]");
        this.card.setOpaque(false);
    }

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    public String getConstraints() {
        return "wmin 10,height 60:n:n,pushy,growy";
    }

    public void onConfigValidatorError(KeyHandler<String> keyHandler, String invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<String> keyHandler, String newValue) {
        this.fill();
    }
}

