/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.browser.firefox;

import com.btr.proxy.search.browser.firefox.FirefoxProfileSource;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.PlatformUtil;
import java.io.File;

class LinuxFirefoxProfileSource
implements FirefoxProfileSource {
    LinuxFirefoxProfileSource() {
    }

    @Override
    public File getProfileFolder() {
        File userDir = new File(PlatformUtil.getUserHomeDir());
        File cfgDir = new File(userDir, ".mozilla" + File.separator + "firefox" + File.separator);
        if (!cfgDir.exists()) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder not found!", new Object[0]);
            return null;
        }
        File[] profiles = cfgDir.listFiles();
        if (profiles == null || profiles.length == 0) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder not found!", new Object[0]);
            return null;
        }
        for (File p : profiles) {
            if (!p.getName().endsWith(".default")) continue;
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Firefox settings folder is {0}", p);
            return p;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Firefox settings folder is {0}", profiles[0]);
        return profiles[0];
    }
}

