/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.builddecision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.appwork.builddecision.BuildDecisionRequired;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.Storable;

public class BuildDecisionData
implements Storable {
    private String msg;
    private List<Option> options;
    private String cls;

    public BuildDecisionData() {
    }

    public BuildDecisionData(BuildDecisionRequired anno, Class<?> type) {
        String[] imports = anno.imports();
        if (anno.imports().length == 0 || anno.imports().length == 1 && anno.imports()[0].equals("")) {
            imports = null;
        }
        if (imports != null && imports.length != anno.tags().length) {
            throw new WTFException("Bad annotation. ids and anno.imports");
        }
        int i = 0;
        String[] dependsOn = anno.dependsOn();
        if (dependsOn.length == 0 || dependsOn.length == 1 && dependsOn[0].equals("")) {
            dependsOn = null;
        }
        if (dependsOn != null && dependsOn.length != anno.tags().length) {
            throw new WTFException("Bad annotation. tags and anno.dependsOn");
        }
        this.msg = anno.msg();
        this.options = new ArrayList<Option>();
        for (String tag : anno.tags()) {
            this.options.add(new Option(tag, imports == null ? null : imports[i], dependsOn == null ? null : dependsOn[i]));
            ++i;
        }
        this.cls = type.getName();
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    public String getCls() {
        return this.cls;
    }

    public void setCls(String cls) {
        this.cls = cls;
    }

    public static class Option
    implements Storable {
        private String[] dependsOn;
        private String tag;
        private String[] imports;

        public Option() {
        }

        public String toString() {
            return "Launcher Regex: " + this.tag + " Required Imports: " + Arrays.toString(this.imports) + " DependsOn: " + Arrays.toString(this.dependsOn);
        }

        public Option(String tag2, String string, String depends) {
            this.tag = tag2;
            this.imports = string == null ? null : string.split(";");
            this.dependsOn = depends == null ? null : depends.split(";");
        }

        public String[] getDependsOn() {
            return this.dependsOn;
        }

        public void setDependsOn(String[] dependsOn) {
            this.dependsOn = dependsOn;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public String[] getImports() {
            return this.imports;
        }

        public void setImports(String[] imports) {
            this.imports = imports;
        }
    }
}

