/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.unixsplit;

import java.io.IOException;
import java.io.OutputStream;
import org.appwork.io.unixsplit.StreamProvider;
import org.appwork.utils.net.CountingOutputStream;

public class UnixSplitOutputStream
extends OutputStream {
    protected final StreamProvider streamProvider;
    private int partCount = 0;
    private CountingOutputStream out;
    private StreamProvider.PartInfo stream;

    public int getPartCount() {
        return this.partCount;
    }

    public UnixSplitOutputStream(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            long remaining = this.ensureStream();
            int chunkSize = Math.min((int)Math.min(Integer.MAX_VALUE, remaining), len);
            this.out.write(b, off, chunkSize);
            len -= chunkSize;
            off += chunkSize;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null && this.stream != null) {
            this.stream.close();
        }
    }

    protected long ensureStream() throws IOException {
        long remaining;
        if (this.stream == null || (remaining = this.stream.getRemaining(this.out.transferedBytes())) == 0L) {
            if (this.stream != null) {
                this.stream.close();
            }
            this.stream = this.streamProvider.getNextStream(this.partCount++);
            this.out = new CountingOutputStream(this.stream.stream);
            remaining = this.stream.getRemaining(this.out.transferedBytes());
            if (remaining <= 0L) {
                throw new IOException("Invalid Part Configuration!");
            }
        }
        return remaining;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureStream();
        this.out.write(b);
    }
}

