/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.remoteapi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.appwork.remoteapi.InterfaceHandler;
import org.appwork.remoteapi.RemoteAPIRequest;
import org.appwork.remoteapi.exceptions.BasicRemoteAPIException;
import org.appwork.utils.net.HeaderCollection;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.session.HttpSession;

public class SessionRemoteAPIRequest<T extends HttpSession>
extends RemoteAPIRequest {
    private final T session;
    private final RemoteAPIRequest apiRequest;

    public SessionRemoteAPIRequest(HttpRequest request, RemoteAPIRequest apiRequest, T session) throws BasicRemoteAPIException {
        super(apiRequest.getIface(), apiRequest.getMethodName(), apiRequest.getParameters(), request, apiRequest.getJqueryCallback());
        this.apiRequest = apiRequest;
        this.session = session;
    }

    @Override
    public String toString() {
        return "SessionAPIRequest_" + (this.session == null ? null : this.session.getSessionID()) + "\r\n" + this.apiRequest;
    }

    public RemoteAPIRequest getApiRequest() {
        return this.apiRequest;
    }

    @Override
    public InterfaceHandler<?> getIface() {
        return this.apiRequest.getIface();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.apiRequest.getInputStream();
    }

    @Override
    public String getJqueryCallback() {
        return this.apiRequest.getJqueryCallback();
    }

    @Override
    public Method getMethod() {
        return this.apiRequest.getMethod();
    }

    @Override
    public String getMethodName() {
        return this.apiRequest.getMethodName();
    }

    @Override
    public String[] getParameters() {
        return this.apiRequest.getParameters();
    }

    @Override
    public List<String> getRemoteAddresses() {
        return this.apiRequest.getRemoteAddresses();
    }

    @Override
    public String getRequestedPath() {
        return this.apiRequest.getRequestedPath();
    }

    @Override
    public String getRequestedURL() {
        return this.apiRequest.getRequestedURL();
    }

    @Override
    public List<KeyValuePair> getRequestedURLParameters() {
        return this.apiRequest.getRequestedURLParameters();
    }

    @Override
    public HeaderCollection getRequestHeaders() {
        return this.apiRequest.getRequestHeaders();
    }

    @Override
    public RemoteAPIRequest.REQUESTTYPE getRequestType() {
        return this.apiRequest.getRequestType();
    }

    public T getSession() {
        return this.session;
    }
}

