/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.lang.reflect.Type;
import java.util.Date;
import org.appwork.storage.FailLevel;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableValidateCondition;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.StorableValidateTimestampRelative;
import org.appwork.storage.TypeRef;

@StorableValidateCondition(value="{$or:[{minimumBuildDate:null},{maximumBuildDate:null},{maximumBuildDate:{$gte:\u00a7PARENT.minimumBuildDate}}]}", description="minimumBuildDate must not be bigger than maximumBuildDate!")
public class BuildsInfo
implements Storable {
    public static final String KEY_MINIMUM_BUILD_DATE = "minimumBuildDate";
    public static final String KEY_MAXIMUM_BUILD_DATE = "maximumBuildDate";
    public static final TypeRef<BuildsInfo> TYPE = new SimpleTypeRef<BuildsInfo>((Type)((Object)BuildsInfo.class));
    @StorableValidateNotNull
    @StorableValidateTimestampRelative(min=-1576800000000L, max=86400000L, level=FailLevel.ERROR, message="It can be found in the Connect Client about dialog or the projects.appwork.org release pages")
    @StorableDoc(value="Format yyyy-MM-ddTHH:mm[:ss.sss]Z. minimum and maximumBuildDate define a range of Connect Client Versions (by BuildDate) that must be compatible to this setup. If there are any properties in the setup that are deprecated, removed or not available yet, you will get errors or warnings.")
    @StorableExample(value="\"2021-10-07T00:00CET\"")
    private Date minimumBuildDate;
    @StorableValidateNotNull
    @StorableValidateTimestampRelative(min=-1576800000000L, max=86400000L, level=FailLevel.ERROR, message="It can be found in the Connect Client about dialog or the projects.appwork.org release pages")
    @StorableDoc(value="@See #minimumBuildDate")
    @StorableExample(value="\"2022-10-07T00:00CET\"")
    private Date maximumBuildDate;

    public BuildsInfo() {
    }

    public BuildsInfo(Date min, Date max) {
        this.minimumBuildDate = min;
        this.maximumBuildDate = max;
    }

    public Date getMinimumBuildDate() {
        return this.minimumBuildDate;
    }

    public void setMinimumBuildDate(Date minimumBuildDate) {
        this.minimumBuildDate = minimumBuildDate;
    }

    public Date getMaximumBuildDate() {
        return this.maximumBuildDate;
    }

    public void setMaximumBuildDate(Date maximumBuildDate) {
        this.maximumBuildDate = maximumBuildDate;
    }

    public static enum TargetBuildIssue {
        SOME_TARGET_BUILDS_AFFECTED,
        ALL_TARGET_BUILDS_AFFECTED,
        NO_TARGET_BUILDS_AFFECTED;

    }
}

