/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.MaxTimeSoftReferenceCleanupCallback;

public class MaxTimeSoftReference<T>
extends SoftReference<T> {
    private static final ScheduledExecutorService EXECUTER = DelayedRunnable.getNewScheduledExecutorService();
    private static final ScheduledExecutorService QUEUECLEANUP = DelayedRunnable.getNewScheduledExecutorService();
    private static final ReferenceQueue<Object> QUEUE = new ReferenceQueue();
    protected final AtomicReference<DelayedRunnable> delayedRunnable;
    protected final AtomicReference<MaxTimeSoftReferenceCleanupCallback> cleanupMaxTimeSoftReference;
    protected final String id;

    public MaxTimeSoftReference(T ret, long minlifetime, String id) {
        this(ret, minlifetime, id, null);
    }

    public MaxTimeSoftReference(T ret, long maxLifeTime, final String id, MaxTimeSoftReferenceCleanupCallback cleanupMaxTimeSoftReference) {
        super(ret, QUEUE);
        this.id = id;
        this.cleanupMaxTimeSoftReference = new AtomicReference<MaxTimeSoftReferenceCleanupCallback>(cleanupMaxTimeSoftReference);
        this.delayedRunnable = new AtomicReference<2>(new DelayedRunnable(EXECUTER, maxLifeTime){

            @Override
            public void delayedrun() {
                if (MaxTimeSoftReference.this.delayedRunnable.compareAndSet(this, null)) {
                    MaxTimeSoftReference.this.clear();
                }
            }

            @Override
            public String getID() {
                return "MaxTimeSoftReference_" + id;
            }

            @Override
            public boolean stop() {
                this.delayedrun();
                return super.stop();
            }
        });
        this.get();
    }

    @Override
    public void clear() {
        super.clear();
        this.enqueue();
        this.stopDelayedReferenceClear();
    }

    @Override
    public T get() {
        Object ret = super.get();
        if (ret == null) {
            this.stopDelayedReferenceClear();
            return null;
        }
        this.resetDelayedReferenceClear();
        return ret;
    }

    protected boolean resetDelayedReferenceClear() {
        DelayedRunnable delayedRunnable = this.delayedRunnable.get();
        if (delayedRunnable != null) {
            delayedRunnable.resetAndStart();
            return true;
        }
        return false;
    }

    protected boolean stopDelayedReferenceClear() {
        DelayedRunnable delayedRunnable = this.delayedRunnable.get();
        if (delayedRunnable != null) {
            return delayedRunnable.stop();
        }
        return false;
    }

    public String getID() {
        return this.id;
    }

    public boolean isGone() {
        Object ret = super.get();
        if (ret == null) {
            this.stopDelayedReferenceClear();
            return true;
        }
        return false;
    }

    protected void onCleanup() {
        MaxTimeSoftReferenceCleanupCallback cleanupMaxTimeSoftReference = this.cleanupMaxTimeSoftReference.getAndSet(null);
        if (cleanupMaxTimeSoftReference != null) {
            cleanupMaxTimeSoftReference.onMaxTimeSoftReferenceCleanup(this);
        }
    }

    public T superget() {
        return super.get();
    }

    public String toString() {
        return "MaxTimeSoftReference_" + this.getID() + "|Gone:" + this.isGone();
    }

    static {
        QUEUECLEANUP.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    Reference remove = null;
                    while ((remove = QUEUE.poll()) != null) {
                        ((MaxTimeSoftReference)remove).onCleanup();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, 10L, 60L, TimeUnit.SECONDS);
    }
}

