/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.MinTimeWeakReferenceCleanup;

public class MinTimeWeakReference<T>
extends WeakReference<T> {
    private static final ScheduledExecutorService EXECUTER = DelayedRunnable.getNewScheduledExecutorService();
    private static final ScheduledExecutorService QUEUECLEANUP = DelayedRunnable.getNewScheduledExecutorService();
    private static final ReferenceQueue<Object> QUEUE = new ReferenceQueue();
    private final AtomicReference<DelayedRunnable> hardReference = new AtomicReference<Object>(null);
    private final AtomicReference<MinTimeWeakReferenceCleanup> cleanupMinTimeWeakReference;
    private final String id;
    private final long minLifeTime;

    public MinTimeWeakReference(T ret, long minlifetime, String id) {
        this(ret, minlifetime, id, null);
    }

    public MinTimeWeakReference(final T ret, long minLifeTime, final String id, MinTimeWeakReferenceCleanup cleanupMinTimeWeakReference) {
        super(ret, QUEUE);
        this.id = id;
        this.minLifeTime = minLifeTime;
        this.cleanupMinTimeWeakReference = new AtomicReference<MinTimeWeakReferenceCleanup>(cleanupMinTimeWeakReference);
        this.hardReference.set(new DelayedRunnable(EXECUTER, minLifeTime){
            private final T hardReference;
            {
                super(service, delayInMS);
                this.hardReference = ret;
            }

            @Override
            public void delayedrun() {
                MinTimeWeakReference.this.hardReference.compareAndSet(this, null);
            }

            @Override
            public String getID() {
                return "MinTimeWeakReference_" + id;
            }

            @Override
            public boolean stop() {
                this.delayedrun();
                return super.stop();
            }
        });
        this.get();
    }

    @Override
    public void clear() {
        super.clear();
        this.removeDelayedHardReference();
        this.enqueue();
    }

    protected void removeDelayedHardReference() {
        DelayedRunnable old = this.hardReference.getAndSet(null);
        if (old != null) {
            old.stop();
        }
    }

    @Override
    public T get() {
        final Object ret = super.get();
        if (ret == null) {
            this.removeDelayedHardReference();
        } else {
            DelayedRunnable minHardReference = this.hardReference.get();
            if (minHardReference != null) {
                minHardReference.resetAndStart();
                this.hardReference.compareAndSet(null, minHardReference);
            } else {
                minHardReference = new DelayedRunnable(EXECUTER, this.minLifeTime){
                    private final T hardReference;
                    {
                        super(service, delayInMS);
                        this.hardReference = ret;
                    }

                    @Override
                    public void delayedrun() {
                        MinTimeWeakReference.this.hardReference.compareAndSet(this, null);
                    }

                    @Override
                    public String getID() {
                        return "MinTimeWeakReference_" + MinTimeWeakReference.this.id;
                    }

                    @Override
                    public boolean stop() {
                        this.delayedrun();
                        return super.stop();
                    }
                };
                if (this.hardReference.compareAndSet(null, minHardReference)) {
                    minHardReference.resetAndStart();
                }
            }
        }
        return ret;
    }

    public String getID() {
        return this.id;
    }

    public boolean isGone() {
        Object ret = super.get();
        if (ret == null) {
            this.removeDelayedHardReference();
            return true;
        }
        return false;
    }

    protected void onCleanup() {
        MinTimeWeakReferenceCleanup cleanupMinTimeWeakReference = this.cleanupMinTimeWeakReference.getAndSet(null);
        if (cleanupMinTimeWeakReference != null) {
            cleanupMinTimeWeakReference.onMinTimeWeakReferenceCleanup(this);
        }
    }

    public T superget() {
        return super.get();
    }

    public String toString() {
        return "MinTimeWeakReference_" + this.id + "|Gone:" + this.isGone();
    }

    static {
        QUEUECLEANUP.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    Reference remove = null;
                    while ((remove = QUEUE.poll()) != null) {
                        ((MinTimeWeakReference)remove).onCleanup();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, 10L, 60L, TimeUnit.SECONDS);
    }
}

