/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.annotations.DefaultDoubleValue;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.StringUtils;

public class DoubleKeyHandler
extends KeyHandler<Double> {
    public DoubleKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultDoubleValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(0.0);
    }

    @Override
    protected Double getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        if (rawValue instanceof Number) {
            return ((Number)rawValue).doubleValue();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (StringUtils.equalsIgnoreCase("null", stringValue)) {
                if (this.isRealPrimitive()) {
                    return 0.0;
                }
                return null;
            }
            return Double.valueOf(stringValue);
        }
        return (Double)rawValue;
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Double && y instanceof Double) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    protected void initHandler() throws Throwable {
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected void putValue(Double object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected void validateValue(Double object) throws Throwable {
    }
}

