/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.remoteapi.annotations.ApiDoc;
import org.appwork.remoteapi.annotations.ApiDocExample;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDateFormat;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.StorableHidden;
import org.appwork.storage.StorableLink;
import org.appwork.storage.StorableOrder;
import org.appwork.storage.StorableSee;
import org.appwork.storage.StorableTypeAlternatives;
import org.appwork.storage.StorableValidateMandatoryInJson;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.ClassCastFlexiMapperException;
import org.appwork.storage.flexijson.mapper.FailedToCreateInstanceFlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.mapper.FlexiTypeMapper;
import org.appwork.storage.flexijson.mapper.interfacestorage.InterfaceStorage;
import org.appwork.storage.flexijson.mapper.typemapper.DateMapper;
import org.appwork.storage.flexijson.mapper.typemapper.LocaleMapMapper;
import org.appwork.storage.flexijson.mapper.typemapper.TimeSpanMapper;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.storage.validator.classvalidator.StorableClassValidator1;
import org.appwork.storage.validator.classvalidator.StorableClassValidator2;
import org.appwork.storage.validator.classvalidator.StorableClassValidator3;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class FlexiJSonMapper {
    private static final String TYPE = "Type: ";
    private static final ArrayList<FlexiTypeMapper> DEFAULTMAPPER = new ArrayList();
    public static final ThreadLocal<ArrayList<FlexiTypeMapper>> THREAD_MAPPERS;
    private boolean ignorePrimitiveNullMapping = false;
    private boolean ignoreIllegalArgumentMappings = false;
    private boolean ignoreIllegalEnumMappings = false;
    protected final ArrayList<FlexiTypeMapper> typeMapper;
    protected CompiledType autoMapFlexiJSonObjectClass = CompiledType.create(new TypeRef<LinkedHashMap<String, Object>>(){});
    protected CompiledType autoMapFlexiJSonArrayclass;
    protected CompiledType autoMapCollectionInterface = this.autoMapFlexiJSonArrayclass = CompiledType.create(new TypeRef<LinkedList<Object>>(){});
    protected CompiledType autoMapMapInterface = this.autoMapFlexiJSonObjectClass;
    protected CompiledType autoMapSetInterface = CompiledType.create(new TypeRef<LinkedHashSet<Object>>(){});
    private ArrayList<FlexiMapperException> exceptions;
    private boolean ignoreDefaultValuesEnabled;
    private boolean tagDefaultValuesEnabled;
    private boolean collectExceptions = false;

    public static void addDefaultMapper(FlexiTypeMapper mapper) {
        DEFAULTMAPPER.add(mapper);
    }

    public static FlexiTypeMapper addThreadMapper(FlexiTypeMapper newMapper) {
        if (THREAD_MAPPERS.get() == null) {
            THREAD_MAPPERS.set(new ArrayList());
        }
        for (FlexiTypeMapper existing : THREAD_MAPPERS.get()) {
            if (existing.getClass() != newMapper.getClass()) continue;
            return null;
        }
        THREAD_MAPPERS.get().add(newMapper);
        return newMapper;
    }

    public static boolean removeThreadMapper(FlexiTypeMapper newMapper) {
        if (newMapper == null || THREAD_MAPPERS.get() == null) {
            return false;
        }
        return THREAD_MAPPERS.get().remove(newMapper);
    }

    public FlexiJSonMapper() {
        this.typeMapper = new ArrayList<FlexiTypeMapper>(DEFAULTMAPPER);
    }

    public void addMapper(FlexiTypeMapper mapper) {
        this.typeMapper.add(0, mapper);
    }

    public void removeMapperByType(Class<?> class1) {
        Iterator<FlexiTypeMapper> it = this.typeMapper.iterator();
        while (it.hasNext()) {
            if (!Clazz.isInstanceof(it.next().getClass(), class1)) continue;
            it.remove();
        }
    }

    public void setTypeMapper(List<FlexiTypeMapper> customs) {
        this.typeMapper.clear();
        this.typeMapper.addAll(customs);
    }

    public List<FlexiTypeMapper> getTypeMapper() {
        return Collections.unmodifiableList(this.typeMapper);
    }

    public FlexiJSonNode objectToJsonNode(Object obj, CompiledType type) throws FlexiMapperException {
        return this.objectToJsonNode(null, obj, new LinkedList<CompiledType>(Arrays.asList(type)));
    }

    public FlexiJSonNode objectToJsonNode(Object obj) throws FlexiMapperException {
        return this.objectToJsonNode(null, obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlexiJSonNode objectToJsonNode(Getter reference, Object obj, LinkedList<CompiledType> typeHirarchy) throws FlexiMapperException {
        FlexiJSonNode node;
        if (typeHirarchy == null) {
            typeHirarchy = new LinkedList();
            typeHirarchy.add(obj == null ? CompiledType.OBJECT : CompiledType.create(obj.getClass()));
        }
        if (obj instanceof FlexiJSonNode) {
            return (FlexiJSonNode)obj;
        }
        FlexiJSonNode mapped = this.handleMapperObjectToJsonNode(reference, obj, typeHirarchy);
        if (mapped != null) {
            return mapped;
        }
        CompiledType cType = this.getTargetClass(obj, typeHirarchy);
        if (cType.isPrimitiveWrapper()) {
            if (obj == null) {
                return this.createFlexiJSonValue();
            }
            if (cType.isBoolean()) {
                return this.createFlexiJSonValue((Boolean)obj);
            }
            if (cType.isCharacter()) {
                return this.createFlexiJSonValue('\u0000' + ((Character)obj).charValue());
            }
            if (cType.isNumber()) {
                return this.createFlexiJSonValue((Number)obj);
            }
            throw new WTFException("Unknown Primitive Type: " + cType);
        }
        if (cType.isPrimitive()) {
            if (cType.isBoolean()) {
                return this.createFlexiJSonValue((Boolean)obj);
            }
            if (cType.isCharacter()) {
                return this.createFlexiJSonValue('\u0000' + ((Character)obj).charValue());
            }
            if (cType.isNumber()) {
                return this.createFlexiJSonValue((Number)obj);
            }
            throw new WTFException("Unknown Primitive Type: " + cType);
        }
        if (cType.isString()) {
            return this.createFlexiJSonValue((String)obj);
        }
        if (cType.isInstanceOf(new Type[]{CharSequence.class})) {
            return this.createFlexiJSonValue(obj == null ? (String)null : ((CharSequence)obj).toString());
        }
        if (cType.isEnum(true)) {
            FlexiJSonValue ret = obj == null ? this.createFlexiJSonValue((String)null) : this.createFlexiJSonValue(String.valueOf(obj));
            FlexiJSonComments comments = this.addEnumCommentByAnnotations(null, obj, cType);
            ret.addCommentsAfter(comments);
            return ret;
        }
        if (cType.isMap()) {
            FlexiJSonNode node2 = obj == null ? this.createFlexiJSonValue() : this.createFlexiJSonObject();
            this.addClassHeaderCommentsByAnnotations(node2, cType);
            CompiledType[] compTypes = cType.getComponentTypes(Map.class);
            if (compTypes.length == 2 && compTypes[1].isGenericsResolved()) {
                this.addClassHeaderCommentsByAnnotations(node2, compTypes[1]);
            }
            if (obj == null) {
                return node2;
            }
            FlexiJSonObject ret = (FlexiJSonObject)node2;
            for (Map.Entry next : ((Map)obj).entrySet()) {
                if (!(next.getKey() instanceof String)) {
                    this.returnFallbackOrThrowException(new FlexiMapperException((FlexiJSonNode)ret, cType, "Map keys have to be Strings: " + cType.type + " Keyclass:" + (next.getKey() == null ? "<null>" : next.getKey().getClass())));
                }
                CompiledType type = CompiledType.OBJECT;
                if (compTypes.length == 2 && compTypes[1].isGenericsResolved()) {
                    type = compTypes[1];
                }
                if (type.isObject() && next.getValue() != null) {
                    type = CompiledType.create(next.getValue().getClass());
                }
                try {
                    typeHirarchy.add(type);
                    ret.add(this.createKeyValueElement(ret, next.getKey().toString(), this.objectToJsonNode(reference, next.getValue(), typeHirarchy)));
                }
                finally {
                    typeHirarchy.removeLast();
                }
            }
            return ret;
        }
        if (cType.isCollection()) {
            FlexiJSonValue node3 = obj == null ? this.createFlexiJSonValue() : this.createFlexiJSonArray(((Collection)obj).size());
            this.addClassHeaderCommentsByAnnotations(node3, cType);
            CompiledType[] compTypes = cType.getComponentTypes(Collection.class);
            if (compTypes.length == 1 && compTypes[0].isGenericsResolved()) {
                this.addClassHeaderCommentsByAnnotations(node3, compTypes[0]);
            }
            if (obj == null) {
                return node3;
            }
            FlexiJSonArray ret = (FlexiJSonArray)((Object)node3);
            for (Object o : (Collection)obj) {
                CompiledType type = CompiledType.OBJECT;
                if (compTypes.length == 1 && compTypes[0].isGenericsResolved()) {
                    type = compTypes[0];
                }
                if (type.isObject() && o != null) {
                    type = CompiledType.create(o.getClass());
                }
                try {
                    typeHirarchy.add(type);
                    ret.add(this.objectToJsonNode(reference, o, typeHirarchy));
                }
                finally {
                    typeHirarchy.removeLast();
                }
            }
            return ret;
        }
        if (cType.isArray()) {
            CompiledType[] compTypes;
            int length = obj == null ? 0 : Array.getLength(obj);
            FlexiJSonNode node4 = obj == null ? this.createFlexiJSonValue() : this.createFlexiJSonArray(length);
            this.addClassHeaderCommentsByAnnotations(node4, cType);
            for (CompiledType c : compTypes = cType.componentTypes) {
                this.addClassHeaderCommentsByAnnotations(node4, c);
            }
            if (obj == null) {
                return node4;
            }
            FlexiJSonArray ret = (FlexiJSonArray)node4;
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(obj, i);
                CompiledType type = CompiledType.OBJECT;
                if (compTypes.length == 1 && compTypes[0].isGenericsResolved()) {
                    type = compTypes[0];
                }
                if (type.isObject() && o != null) {
                    type = CompiledType.create(o.getClass());
                }
                try {
                    typeHirarchy.add(type);
                    ret.add(this.objectToJsonNode(reference, o, typeHirarchy));
                    continue;
                }
                finally {
                    typeHirarchy.removeLast();
                }
            }
            return ret;
        }
        InterfaceStorage<Object> is = null;
        if (obj instanceof Proxy && this.isIncludeInterfaceStorageBackendNode()) {
            is = InterfaceStorage.get(obj);
        }
        FlexiJSonNode flexiJSonNode = node = obj == null ? this.createFlexiJSonValue() : this.createFlexiJSonObject();
        if (is != null) {
            node.addCommentsAfter(is.backendNode.getCommentsAfter());
            node.addCommentsBefore(is.backendNode.getCommentsBefore());
            this.cleanUpComments(node.getCommentsAfter());
            this.cleanUpComments(node.getCommentsBefore());
        }
        this.addClassHeaderCommentsByAnnotations(node, cType);
        CompiledType[] compTypes = cType.componentTypes;
        for (CompiledType c : compTypes) {
            this.addClassHeaderCommentsByAnnotations(node, c);
        }
        if (obj == null) {
            return node;
        }
        FlexiJSonObject ret = (FlexiJSonObject)node;
        if (is != null) {
            ret.addCommentsInside(is.backendNode.getCommentsInside());
            this.cleanUpComments(ret.getCommentsInside());
        }
        try {
            Object empty = null;
            ClassCache cc = cType.getClassCache();
            Collection<Getter> getters = cc.getGetterMap().values();
            HashMap<KeyValueElement, Integer> orderMap = null;
            for (Getter g : getters) {
                try {
                    List<StorableOrder> orders;
                    KeyValueElement backEndElement;
                    KeyValueElement element;
                    typeHirarchy.add(CompiledType.create(g.getMethod().getGenericReturnType(), cType.type));
                    if (cType.getClassCache().getAnnotations(g.key, StorableHidden.class).size() > 0) continue;
                    Object value = g.getValue(obj);
                    if (this.isIgnoreDefaultValuesEnabled(obj, cType, g)) {
                        if (empty == null) {
                            empty = this.createDefaultObject(obj, cType, ret, g, cType.getClassCache().getSetter(g.key), typeHirarchy);
                        }
                        if (empty != null && CompareUtils.equalsDeep(g.getValue(empty), value)) continue;
                    }
                    FlexiJSonNode subNode = this.objectToJsonNode(g, value, typeHirarchy);
                    if (this.isTagDefaultValuesEnabled(obj, cType, g)) {
                        if (empty == null) {
                            empty = this.createDefaultObject(obj, cType, ret, g, cType.getClassCache().getSetter(g.key), typeHirarchy);
                        }
                        if (empty != null && CompareUtils.equalsDeep(g.getValue(empty), value)) {
                            subNode.tag(FlexiMapperTags.DEFAULT_VALUE);
                        }
                    }
                    if (this.isAddDefaultValueCommentEnabled(obj, cType, g)) {
                        if (empty == null) {
                            empty = this.createDefaultObject(obj, cType, ret, g, cType.getClassCache().getSetter(g.key), typeHirarchy);
                        }
                        element = empty == null ? this.methodOrFieldAnnotationsToComments(g, typeHirarchy, this.createKeyValueElement(ret, g.getKey(), subNode), null, false) : this.methodOrFieldAnnotationsToComments(g, typeHirarchy, this.createKeyValueElement(ret, g.getKey(), subNode), g.getValue(empty), true);
                    } else {
                        element = this.methodOrFieldAnnotationsToComments(g, typeHirarchy, this.createKeyValueElement(ret, g.getKey(), subNode), null, false);
                    }
                    if (is != null && (backEndElement = is.backendNode.getElement(g.key)) != null) {
                        element.addCommentsAfterKey(backEndElement.getCommentsAfterKey());
                        element.addCommentsBeforeKey(backEndElement.getCommentsBeforeKey(), true);
                        this.cleanUpComments(element.getCommentsBeforeKey());
                        this.cleanUpComments(element.getCommentsAfterKey());
                    }
                    if ((orders = cc.getAnnotations(g.key, StorableOrder.class)).size() > 0) {
                        if (orderMap == null) {
                            orderMap = new HashMap<KeyValueElement, Integer>();
                        }
                        orderMap.put(element, orders.get(0).value());
                    }
                    ret.add(element);
                }
                catch (IllegalArgumentException e) {
                    this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
                }
                catch (IllegalAccessException e) {
                    this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
                }
                catch (InvocationTargetException e) {
                    this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
                }
                finally {
                    typeHirarchy.removeLast();
                }
            }
            if (is != null) {
                for (KeyValueElement el : is.backendNode.getElements()) {
                    if (el.getKey() == null) {
                        KeyValueElement emptyKeyValueElement = this.createKeyValueElement(ret, el.getKey(), el.getValue());
                        emptyKeyValueElement.addCommentsAfterKey(el.getCommentsAfterKey());
                        emptyKeyValueElement.addCommentsBeforeKey(el.getCommentsBeforeKey(), true);
                        this.cleanUpComments(emptyKeyValueElement.getCommentsBeforeKey());
                        this.cleanUpComments(emptyKeyValueElement.getCommentsAfterKey());
                        ret.add(emptyKeyValueElement);
                        continue;
                    }
                    if (cc.getGetterMap().containsKey(el.getKey())) continue;
                    KeyValueElement element = this.createKeyValueElement(ret, el.getKey(), el.getValue());
                    element.addCommentsAfterKey(el.getCommentsAfterKey());
                    element.addCommentsBeforeKey(el.getCommentsBeforeKey(), true);
                    this.cleanUpComments(element.getCommentsBeforeKey());
                    this.cleanUpComments(element.getCommentsAfterKey());
                    ret.add(element);
                }
            }
            if (orderMap != null) {
                final HashMap<KeyValueElement, Integer> fOrderMap = orderMap;
                ret.sort(new Comparator<KeyValueElement>(){

                    @Override
                    public int compare(KeyValueElement o1, KeyValueElement o2) {
                        int result;
                        Integer id1 = (Integer)fOrderMap.get(o1);
                        Integer id2 = (Integer)fOrderMap.get(o2);
                        if (id1 == null) {
                            id1 = 0;
                        }
                        if (id2 == null) {
                            id2 = 0;
                        }
                        if ((result = CompareUtils.compare(id1, id2)) == 1) {
                            return CompareUtils.compare((Comparable)((Object)o1.getKey()), (Comparable)((Object)o2.getKey()));
                        }
                        return result;
                    }
                });
            }
        }
        catch (SecurityException e) {
            this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
        }
        catch (NoSuchMethodException e) {
            this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
        }
        return ret;
    }

    private void cleanUpComments(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.cleanUpDupes();
    }

    protected boolean isIncludeInterfaceStorageBackendNode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlexiJSonObject interfaceStorageToNode(InterfaceStorage<Object> is, Object obj, CompiledType cType, LinkedList<CompiledType> typeHirarchy) throws FlexiMapperException {
        CompiledType[] compTypes;
        FlexiJSonObject ret = this.createFlexiJSonObject();
        this.addClassHeaderCommentsByAnnotations(ret, cType);
        for (CompiledType c : compTypes = cType.componentTypes) {
            this.addClassHeaderCommentsByAnnotations(ret, c);
        }
        ret.addCommentsAfter(is.backendNode.getCommentsAfter());
        ret.addCommentsBefore(is.backendNode.getCommentsBefore());
        ret.addCommentsInside(is.backendNode.getCommentsInside());
        try {
            Object empty = null;
            Collection<Getter> getters = cType.getClassCache().getGetterMap().values();
            for (Getter g : getters) {
                try {
                    typeHirarchy.add(CompiledType.create(g.getMethod().getGenericReturnType(), cType.type));
                    if (cType.getClassCache().getAnnotations(g.key, StorableHidden.class).size() > 0) continue;
                    Object value = g.getValue(obj);
                    if (this.isIgnoreDefaultValuesEnabled(obj, cType, g)) {
                        if (empty == null) {
                            empty = this.createDefaultObject(obj, cType, ret, g, cType.getClassCache().getSetter(g.key), typeHirarchy);
                        }
                        if (empty != null && CompareUtils.equalsDeep(g.getValue(empty), value)) continue;
                    }
                    FlexiJSonNode subNode = this.objectToJsonNode(g, value, typeHirarchy);
                    if (this.isTagDefaultValuesEnabled(obj, cType, g)) {
                        if (empty == null) {
                            empty = this.createDefaultObject(obj, cType, ret, g, cType.getClassCache().getSetter(g.key), typeHirarchy);
                        }
                        if (empty != null && CompareUtils.equalsDeep(g.getValue(empty), value)) {
                            subNode.tag(FlexiMapperTags.DEFAULT_VALUE);
                        }
                    }
                    if (this.isAddDefaultValueCommentEnabled(obj, cType, g)) {
                        if (empty == null) {
                            empty = this.createDefaultObject(obj, cType, ret, g, cType.getClassCache().getSetter(g.key), typeHirarchy);
                        }
                        if (empty == null) {
                            ret.add(this.methodOrFieldAnnotationsToComments(g, typeHirarchy, this.createKeyValueElement(ret, g.getKey(), subNode), null, false));
                            continue;
                        }
                        ret.add(this.methodOrFieldAnnotationsToComments(g, typeHirarchy, this.createKeyValueElement(ret, g.getKey(), subNode), g.getValue(empty), true));
                        continue;
                    }
                    ret.add(this.methodOrFieldAnnotationsToComments(g, typeHirarchy, this.createKeyValueElement(ret, g.getKey(), subNode), null, false));
                }
                catch (IllegalArgumentException e) {
                    this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
                }
                catch (IllegalAccessException e) {
                    this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
                }
                catch (InvocationTargetException e) {
                    this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
                }
                finally {
                    typeHirarchy.removeLast();
                }
            }
        }
        catch (SecurityException e) {
            this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
        }
        catch (NoSuchMethodException e) {
            this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
        }
        return ret;
    }

    public FlexiJSonArray createFlexiJSonArray(int length) {
        return new FlexiJSonArray(length);
    }

    private FlexiJSonComments addEnumCommentByAnnotations(FlexiJSonComments comments, Object obj, CompiledType cType) throws FlexiMapperException {
        if (obj == null || !this.isAnnotationCommentsEnabled()) {
            return comments;
        }
        try {
            Field field = cType.raw.getField(((Enum)obj).name());
            for (Annotation an : field.getAnnotations()) {
                comments = this.addComment(comments, an, null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return comments;
    }

    protected CompiledType getTargetClass(Object obj, LinkedList<CompiledType> typeHirarchy) {
        InvocationHandler handler;
        if (obj == null) {
            return typeHirarchy.getLast();
        }
        if (obj instanceof Proxy && (handler = Proxy.getInvocationHandler(obj)) instanceof InterfaceStorage) {
            return ((InterfaceStorage)handler).cType;
        }
        return CompiledType.create(obj.getClass());
    }

    protected KeyValueElement createKeyValueElement(FlexiJSonObject parent, String key, FlexiJSonNode node) {
        return new KeyValueElement(parent, key, node);
    }

    protected FlexiJSonNode handleMapperObjectToJsonNode(Getter getter, Object obj, LinkedList<CompiledType> typeHirarchy) throws FlexiMapperException {
        for (FlexiTypeMapper mapper : this.typeMapper) {
            if (!mapper.canConvert2Json(obj, getter)) continue;
            return mapper.obj2JSon(this, obj, getter, typeHirarchy);
        }
        ArrayList<FlexiTypeMapper> mappers = THREAD_MAPPERS.get();
        if (mappers != null) {
            for (FlexiTypeMapper mapper : mappers) {
                if (!mapper.canConvert2Json(obj, getter)) continue;
                return mapper.obj2JSon(this, obj, getter, typeHirarchy);
            }
        }
        return null;
    }

    protected boolean isTagDefaultValuesEnabled(Object obj, CompiledType cType, Getter g) {
        return this.tagDefaultValuesEnabled;
    }

    public boolean isTagDefaultValuesEnabled() {
        return this.tagDefaultValuesEnabled;
    }

    public void setTagDefaultValuesEnabled(boolean tagDefaultValuesEnabled) {
        this.tagDefaultValuesEnabled = tagDefaultValuesEnabled;
    }

    protected Object createDefaultObject(Object obj, CompiledType cType, FlexiJSonObject ret, Getter getter, Setter setter, LinkedList<CompiledType> typeHirarchy) throws NoSuchMethodException, FlexiMapperException {
        Object handler;
        if (obj instanceof Proxy && (handler = Proxy.getInvocationHandler(obj)) instanceof InterfaceStorage) {
            FlexiJSonObject dummy = new FlexiJSonObject();
            return this.initProxy(cType, dummy);
        }
        for (FlexiTypeMapper mapper : this.typeMapper) {
            FlexiJSonNode tryNode;
            if (mapper.canConvert2Object(tryNode = this.createFlexiJSonValue((String)null), cType, setter)) {
                return mapper.json2Obj(this, tryNode, cType, setter);
            }
            tryNode = this.createFlexiJSonObject();
            if (mapper.canConvert2Object(tryNode, cType, setter)) {
                return mapper.json2Obj(this, tryNode, cType, setter);
            }
            tryNode = this.createFlexiJSonArray(0);
            if (!mapper.canConvert2Object(tryNode, cType, setter)) continue;
            return mapper.json2Obj(this, tryNode, cType, setter);
        }
        try {
            return cType.newInstance();
        }
        catch (InstantiationException e) {
            this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
        }
        catch (IllegalAccessException e) {
            this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
        }
        catch (IllegalArgumentException e) {
            this.returnFallbackOrThrowException(new FlexiMapperException(ret, cType, e.getMessage(), e));
        }
        return null;
    }

    private Object initProxy(CompiledType cType, FlexiJSonObject obj) throws NoSuchMethodException {
        Object proxy = this.createProxy(cType, obj);
        ((InterfaceStorage)Proxy.getInvocationHandler(proxy)).setStorage(proxy);
        return proxy;
    }

    protected boolean isAddDefaultValueCommentEnabled(Object obj, CompiledType cType, Getter g) {
        return false;
    }

    public boolean isIgnoreDefaultValuesEnabled(Object obj, CompiledType cType, Getter g) {
        return this.ignoreDefaultValuesEnabled;
    }

    public void setIgnoreDefaultValuesEnabled(boolean ignoreDefaultValuesEnabled) {
        this.ignoreDefaultValuesEnabled = ignoreDefaultValuesEnabled;
    }

    public FlexiJSonMapper ignoreDefaultValuesEnabled(boolean ignoreDefaultValuesEnabled) {
        this.ignoreDefaultValuesEnabled = ignoreDefaultValuesEnabled;
        return this;
    }

    protected boolean isTypeCommentsEnabled() {
        return false;
    }

    protected KeyValueElement methodOrFieldAnnotationsToComments(Getter g, LinkedList<CompiledType> typeHirarchy, KeyValueElement create, Object defaultValue, boolean addDefaultValueAnnotation) throws FlexiMapperException {
        FlexiJSonComments comments = create.getValue().getCommentsBefore();
        Class<?> cls = g.getMethod().getDeclaringClass();
        create.getValue().setCommentsBefore(null);
        if (this.isTypeCommentsEnabled()) {
            if (addDefaultValueAnnotation) {
                comments = this.addComment(comments, "Default: " + new FlexiJSonStringBuilder().toJSONString(new FlexiJSonMapper().objectToJsonNode(defaultValue)), FlexiMapperTags.DEFAULT_VALUE);
            }
            comments = this.addComment(comments, TYPE + this.typeToString(CompiledType.createFromCompiledHirarchy(typeHirarchy)), FlexiMapperTags.TYPE);
        } else if (addDefaultValueAnnotation) {
            comments = this.addComment(comments, "Default: " + defaultValue, FlexiMapperTags.DEFAULT_VALUE);
        }
        if (!this.isAnnotationCommentsEnabled()) {
            return create;
        }
        comments = this.addCommentByAnnotations(g, comments, cls);
        if ((comments = this.addEnumOptionsComments(comments, typeHirarchy.getLast())) != null) {
            create.setCommentsBeforeKey(comments);
        }
        return create;
    }

    protected FlexiJSonComments addCommentByAnnotations(Getter g, FlexiJSonComments comments, Class<?> cls) throws FlexiMapperException {
        Class<?> targetClass = ReflectionUtils.getRaw(g.type);
        if (targetClass != null) {
            for (Annotation a : targetClass.getAnnotations()) {
                comments = this.addComment(comments, a, null);
            }
        }
        try {
            for (Type c : ClassCache.getClassCache(cls).getTypeHierarchy()) {
                CompiledType ct = CompiledType.create(c);
                try {
                    if (ct.raw == null) continue;
                    Method method = ct.raw.getDeclaredMethod(g.getMethod().getName(), g.getMethod().getParameterTypes());
                    for (Annotation a : method.getAnnotations()) {
                        comments = this.addComment(comments, a, null);
                    }
                    if (ct.raw.isInterface()) continue;
                    Field field = ct.raw.getDeclaredField(g.getKey());
                    for (Annotation a : field.getAnnotations()) {
                        comments = this.addComment(comments, a, null);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (SecurityException securityException) {
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return comments;
    }

    protected FlexiJSonComments addEnumOptionsComments(FlexiJSonComments comments, CompiledType cType) {
        while (cType != null && cType.raw == null) {
            cType = cType.superType;
        }
        if (cType.isEnum(false) && this.isEnumOptionsCommentsEnabled(cType)) {
            try {
                Object[] options = ReflectionUtils.getEnumValues(cType.raw);
                try {
                    String str = "Options: ";
                    int max = 0;
                    for (Object o : options) {
                        max = Math.max(max, o.toString().length());
                    }
                    for (Object o : options) {
                        FlexiJSonComments enumComments = this.addEnumCommentByAnnotations(null, o, cType);
                        str = str + "\r\n   " + StringUtils.fillPre(o.toString(), " ", max);
                        boolean commentsep = false;
                        if (enumComments == null || enumComments.size() <= 0) continue;
                        for (FlexiCommentJsonNode cs : enumComments) {
                            if (!(cs instanceof FlexiComment)) continue;
                            str = !commentsep ? str + ": " : str + "; ";
                            commentsep = true;
                            str = str + ((FlexiComment)cs).getText().replaceAll("[\r\n]{1,2}", " ");
                        }
                    }
                    comments = this.addComment(comments, str, FlexiMapperTags.OPTIONS);
                }
                catch (FlexiMapperException e) {
                    e.printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        for (CompiledType c : cType.componentTypes) {
            this.addEnumOptionsComments(comments, c);
        }
        return comments;
    }

    protected boolean isEnumOptionsCommentsEnabled(CompiledType enumClass) {
        return false;
    }

    private String typeToString(CompiledType com) {
        return com.toString(null);
    }

    private FlexiJSonComments addComment(FlexiJSonComments comments, Object anno, FlexiMapperTags tag) throws FlexiMapperException {
        if (anno == null) {
            return comments;
        }
        if (anno instanceof String) {
            comments = this.pushComment(comments, (String)anno, tag);
        }
        if (anno instanceof ApiDoc) {
            comments = this.pushComment(comments, ((ApiDoc)anno).value(), FlexiMapperTags.DOCS);
            if (StringUtils.isNotEmpty(((ApiDoc)anno).authentication())) {
                comments = this.pushComment(comments, "Authentication: " + ((ApiDoc)anno).authentication(), FlexiMapperTags.AUTH);
            }
        }
        if (anno instanceof StorableSee) {
            Class<?>[] classes;
            Class<?>[] classArray = classes = ((StorableSee)anno).value();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> cl = classArray[i];
                try {
                    if (cl.isEnum()) {
                        Object[] options = ReflectionUtils.getEnumValues(cl);
                        try {
                            String str = cl.getSimpleName() + "-Options: ";
                            for (Object o : options) {
                                str = str + "\r\n   " + FlexiUtils.serializeConfigStorable(o);
                            }
                            comments = this.addComment(comments, str, FlexiMapperTags.SEE);
                        }
                        catch (FlexiMapperException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    comments = this.pushComment(comments, cl.getSimpleName() + ": \r\n" + FlexiUtils.serializeConfigStorable(cl.newInstance()), FlexiMapperTags.SEE);
                    continue;
                }
                catch (InstantiationException e) {
                    throw new WTFException(e);
                }
                catch (IllegalAccessException e) {
                    throw new WTFException(e);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                    continue;
                }
                catch (NoSuchMethodException e1) {
                    e1.printStackTrace();
                    continue;
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (anno instanceof StorableLink) {
            String[] hrefs = ((StorableLink)anno).hrefs();
            String[] lables = ((StorableLink)anno).labels();
            for (int i = 0; i < hrefs.length; ++i) {
                comments = this.pushComment(comments, "\"" + lables[i] + "\":" + hrefs[i], FlexiMapperTags.HREF);
            }
        }
        if (anno instanceof StorableValidateNotNull) {
            comments = this.pushComment(comments, "Constraint: Must not be null", FlexiMapperTags.DOCS);
        }
        if (anno instanceof StorableClassValidator1) {
            try {
                comments = this.pushComment(comments, ((StorableClassValidator1)anno).cls().newInstance().getDocsDescription(((StorableClassValidator1)anno).parameter(), anno), FlexiMapperTags.DOCS);
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        if (anno instanceof StorableClassValidator2) {
            try {
                comments = this.pushComment(comments, ((StorableClassValidator2)anno).cls().newInstance().getDocsDescription(((StorableClassValidator2)anno).parameter(), anno), FlexiMapperTags.DOCS);
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        if (anno instanceof StorableClassValidator3) {
            try {
                comments = this.pushComment(comments, ((StorableClassValidator3)anno).cls().newInstance().getDocsDescription(((StorableClassValidator3)anno).parameter(), anno), FlexiMapperTags.DOCS);
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
        if (anno instanceof StorableValidateMandatoryInJson) {
            comments = this.pushComment(comments, "Constraint: Mandatory! The json must contain this property!", FlexiMapperTags.DOCS);
        }
        if (anno instanceof ApiDocExample && StringUtils.isNotEmpty(((ApiDocExample)anno).value())) {
            comments = this.pushComment(comments, "Example: " + ((ApiDocExample)anno).value(), FlexiMapperTags.EXAMPLE);
        }
        if (anno instanceof StorableDoc) {
            comments = this.pushComment(comments, ((StorableDoc)anno).value(), FlexiMapperTags.DOCS);
        }
        if (anno instanceof StorableExample && StringUtils.isNotEmpty(((StorableExample)anno).value())) {
            comments = this.pushComment(comments, "Example: " + ((StorableExample)anno).value(), FlexiMapperTags.EXAMPLE);
        }
        if (anno instanceof StorableTypeAlternatives && ((StorableTypeAlternatives)anno).value().length > 0) {
            for (Class cl : ((StorableTypeAlternatives)anno).value()) {
                comments = this.pushComment(comments, "Possible type: " + cl.getName(), FlexiMapperTags.TYPE);
            }
        }
        if (anno instanceof StorableDeprecatedSince && StringUtils.isNotEmpty(((StorableDeprecatedSince)anno).value())) {
            try {
                comments = StringUtils.isNotEmpty(((StorableDeprecatedSince)anno).message()) ? this.pushComment(comments, "[WARNING]Deprecated since: " + ((StorableDeprecatedSince)anno).value() + "\r\n[WARNING]" + ((StorableDeprecatedSince)anno).message(), FlexiMapperTags.DEPRECATED) : this.pushComment(comments, "[WARNING]Deprecated since: " + ((StorableDeprecatedSince)anno).value(), FlexiMapperTags.DEPRECATED);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (anno instanceof StorableAvailableSince && StringUtils.isNotEmpty(((StorableAvailableSince)anno).value())) {
            try {
                comments = StringUtils.isNotEmpty(((StorableAvailableSince)anno).message()) ? this.pushComment(comments, "Available since: " + ((StorableAvailableSince)anno).value() + "\r\n" + ((StorableAvailableSince)anno).message(), FlexiMapperTags.AVAILABLE_SINCE) : this.pushComment(comments, "Available since: " + ((StorableAvailableSince)anno).value(), FlexiMapperTags.AVAILABLE_SINCE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (anno instanceof StorableDateFormat && StringUtils.isNotEmpty(((StorableDateFormat)anno).value())) {
            comments = this.pushComment(comments, "Date Format: " + ((StorableDateFormat)anno).value(), FlexiMapperTags.DATE_FORMAT);
        }
        return comments;
    }

    protected FlexiJSonComments pushComment(FlexiJSonComments comments, String value, FlexiMapperTags tag) {
        if (StringUtils.isEmpty(value)) {
            return comments;
        }
        if (comments == null) {
            comments = this.createFlexiJsonCommentsContainer();
        }
        for (FlexiCommentJsonNode c : comments) {
            if (!(c instanceof FlexiComment) || !StringUtils.equalsIgnoreCase(((FlexiComment)c).getText(), value)) continue;
            return comments;
        }
        comments.add(this.createFlexiJsonComment(value, tag, this.getCommentType(value)));
        return comments;
    }

    public FlexiComment createFlexiJsonComment(String value, FlexiMapperTags tag, FlexiComment.Type type) {
        return new FlexiComment(value, type, tag);
    }

    public FlexiJSonComments createFlexiJsonCommentsContainer() {
        return new FlexiJSonComments();
    }

    protected void addClassHeaderCommentsByAnnotations(FlexiJSonNode ret, CompiledType cType) throws FlexiMapperException {
        if (!this.isAnnotationCommentsEnabled()) {
            return;
        }
        FlexiJSonComments comments = null;
        for (Annotation a : cType.raw.getAnnotations()) {
            comments = this.addComment(comments, a, null);
        }
        if (comments != null) {
            ret.setCommentsBefore(comments);
        }
    }

    protected boolean isAnnotationCommentsEnabled() {
        return false;
    }

    protected FlexiComment.Type getCommentType(String value) {
        if (value.contains("*/")) {
            return FlexiComment.Type.LINE;
        }
        return FlexiComment.Type.INLINE;
    }

    public FlexiJSonObject createFlexiJSonObject() {
        return new FlexiJSonObject();
    }

    public FlexiJSonValue createFlexiJSonValue() {
        return new FlexiJSonValue((String)null);
    }

    public FlexiJSonValue createFlexiJSonValue(Number longValue) {
        return new FlexiJSonValue(longValue);
    }

    public FlexiJSonValue createFlexiJSonValue(boolean value) {
        return new FlexiJSonValue(value);
    }

    public FlexiJSonValue createFlexiJSonValue(String value) {
        return new FlexiJSonValue(value);
    }

    public boolean isIgnoreIllegalArgumentMappings() {
        return this.ignoreIllegalArgumentMappings;
    }

    public boolean isIgnoreIllegalEnumMappings() {
        return this.ignoreIllegalEnumMappings;
    }

    public boolean isIgnorePrimitiveNullMapping() {
        return this.ignorePrimitiveNullMapping;
    }

    public Object jsonToObject(FlexiJSonNode json, CompiledType cType) throws FlexiMapperException {
        return this.jsonToObject(json, cType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object jsonToObject(FlexiJSonNode json, CompiledType cType, Setter setter) throws FlexiMapperException {
        int i;
        Object arr;
        FlexiJSonArray obj;
        try {
            cType = this.guessTypeForObject(json, cType);
            if (cType.isInstanceOf(new Type[]{FlexiJSonObject.class}) && json instanceof FlexiJSonObject) {
                return json;
            }
            if (cType.isInstanceOf(new Type[]{FlexiJSonArray.class}) && json instanceof FlexiJSonArray) {
                return json;
            }
            if (cType.isInstanceOf(new Type[]{FlexiJSonValue.class}) && json instanceof FlexiJSonValue) {
                return json;
            }
            Object mapped = this.handleMapperJsonNodeToObject(json, cType, setter);
            if (mapped != json) {
                return mapped;
            }
            if (json instanceof FlexiJSonValue && ((FlexiJSonValue)json).getValue() == null) {
                try {
                    return this.cast((FlexiJSonValue)json, null, cType);
                }
                catch (ClassCastException e) {
                    if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastFlexiMapperException(json, cType, null, e, null));
                    return null;
                }
            }
            if (cType.isCollection()) {
                Collection inst;
                try {
                    inst = (Collection)this.mapClasses(cType).newInstance();
                }
                catch (Exception e) {
                    return this.returnFallbackOrThrowException(new FailedToCreateInstanceFlexiMapperException(json, cType, e));
                }
                FlexiJSonArray obj2 = (FlexiJSonArray)json;
                CompiledType[] compTypes = cType.getComponentTypes(Collection.class);
                CompiledType componentType = compTypes.length == 0 ? CompiledType.OBJECT : compTypes[0];
                Iterator iterator = obj2.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return inst;
                    }
                    FlexiJSonNode n = (FlexiJSonNode)iterator.next();
                    inst.add(this.jsonToObject(n, componentType, setter));
                }
            }
            if (cType.isMap()) {
                Map inst;
                try {
                    inst = (Map)this.mapClasses(cType).newInstance();
                }
                catch (Exception e) {
                    return this.returnFallbackOrThrowException(new FailedToCreateInstanceFlexiMapperException(json, cType, e));
                }
                FlexiJSonObject obj3 = (FlexiJSonObject)json;
                CompiledType[] componentTypes = cType.getComponentTypes(Map.class);
                CompiledType componentType = componentTypes.length < 1 ? CompiledType.OBJECT : componentTypes[1];
                Iterator iterator = obj3.getElements().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return inst;
                    }
                    KeyValueElement el = (KeyValueElement)iterator.next();
                    if (el.getKey() == null) continue;
                    inst.put(el.getKey(), this.jsonToObject(el.getValue(), this.mapTypeByKey(el.getKey(), componentType), setter));
                }
            }
            if (!cType.isArray()) {
                if (cType.isBoolean() || cType.isNumber() || cType.isString()) {
                    try {
                        return this.cast((FlexiJSonValue)json, ((FlexiJSonValue)json).getValue(), cType);
                    }
                    catch (ClassCastException e) {
                        if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastFlexiMapperException(json, cType, null, e, null));
                        return null;
                    }
                }
                if (cType.isAnyOf(new Type[]{CharSequence.class})) {
                    try {
                        return this.cast((FlexiJSonValue)json, ((FlexiJSonValue)json).getValue(), CompiledType.STRING);
                    }
                    catch (ClassCastException e) {
                        if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastFlexiMapperException(json, cType, null, e, null));
                        return null;
                    }
                }
                if (cType.isEnum(true)) {
                    try {
                        return this.nodeToEnum(json, cType);
                    }
                    catch (IllegalArgumentException e) {
                        if (this.isIgnoreIllegalArgumentMappings()) return null;
                        if (this.isIgnoreIllegalEnumMappings()) return null;
                        return this.returnFallbackOrThrowException(new ClassCastFlexiMapperException(json, cType, null, e, null));
                    }
                }
                if (cType.isInterface()) {
                    try {
                        return this.initProxy(cType, (FlexiJSonObject)json);
                    }
                    catch (Exception e1) {
                        return this.returnFallbackOrThrowException(new FailedToCreateInstanceFlexiMapperException(json, cType, e1));
                    }
                }
                Object inst = null;
                try {
                    inst = this.getInstance(cType);
                }
                catch (Exception e1) {
                    return this.returnFallbackOrThrowException(new FailedToCreateInstanceFlexiMapperException(json, cType, e1));
                }
                this.writeNodeToObject(cType, (FlexiJSonObject)json, inst);
                return inst;
            }
            obj = (FlexiJSonArray)json;
            arr = this.mapClasses(cType.componentTypes[0]).newArrayInstance(obj.size());
            i = 0;
        }
        catch (FlexiMapperException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return this.returnFallbackOrThrowException(new FlexiMapperException(json, cType, e));
        }
        while (i < obj.size()) {
            Object v = this.jsonToObject((FlexiJSonNode)obj.get(i), cType.componentTypes[0], setter);
            try {
                Array.set(arr, i, v);
            }
            catch (IllegalArgumentException e) {
                this.returnFallbackOrThrowException(new FlexiMapperException((FlexiJSonNode)obj.get(i), this.mapClasses(cType.componentTypes[0]), "Cannot convert index [" + i + "] = " + obj.get(i) + " to type " + this.mapClasses(cType.componentTypes[0]), e));
                Array.set(arr, i, null);
            }
            ++i;
        }
        return arr;
    }

    protected CompiledType mapTypeByKey(String key, CompiledType componentType) {
        return componentType;
    }

    public CompiledType guessTypeForObject(FlexiJSonNode json, CompiledType cType) {
        if (cType.isObject() || cType.raw == null) {
            if (json instanceof FlexiJSonArray) {
                cType = this.autoMapFlexiJSonArrayclass;
            } else if (json instanceof FlexiJSonObject) {
                cType = this.autoMapFlexiJSonObjectClass;
            } else if (json instanceof FlexiJSonValue) {
                switch (((FlexiJSonValue)json).getType()) {
                    case BOOLEAN: {
                        cType = CompiledType.BOOLEAN_PRIMITIVE;
                        break;
                    }
                    case DOUBLE: {
                        cType = CompiledType.DOUBLE_PRIMITIVE;
                        break;
                    }
                    case LONG: {
                        cType = CompiledType.LONG_PRIMITIVE;
                        break;
                    }
                    case NULL: 
                    case STRING: 
                    case UNDEFINED: {
                        cType = CompiledType.STRING;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("All cases should already have been handled");
                    }
                }
            }
        }
        return cType;
    }

    protected Object createProxy(CompiledType cType, FlexiJSonObject obj) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        Class<?> clazz = cType.raw;
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, this.createInterfaceInvocationHandler(cType, obj));
    }

    protected InterfaceStorage<Object> createInterfaceInvocationHandler(CompiledType cType, FlexiJSonObject obj) throws SecurityException, NoSuchMethodException {
        return new InterfaceStorage<Object>(this, cType, obj);
    }

    protected Object getInstance(CompiledType cType) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return cType.newInstance();
    }

    private Object cast(FlexiJSonValue node, Object value, CompiledType destType) {
        if (value == null) {
            if (destType.isNumber()) {
                if (!destType.isPrimitiveWrapper()) {
                    return this.convertNullToNumber(node, destType);
                }
                return null;
            }
            if (destType.isBoolean()) {
                if (!destType.isPrimitiveWrapper()) {
                    return this.convertNullToBoolean(node);
                }
                return null;
            }
            return null;
        }
        if (destType == CompiledType.STRING) {
            if (!(value instanceof String)) {
                return this.convertToString(node);
            }
            return value;
        }
        if (value instanceof CharSequence) {
            if (destType.isNumber()) {
                return this.convertStringToNumber(node, StringUtils.valueOfOrNull(value), destType);
            }
            if (destType.isBoolean()) {
                return this.convertStringToBoolean(node, StringUtils.valueOfOrNull(value), destType);
            }
            if (destType.isAnyOf(new Type[]{Number.class})) {
                return this.convertStringToNumber(node, StringUtils.valueOfOrNull(value), destType);
            }
            throw new ClassCastException("Cannot cast " + value + "+ to " + destType);
        }
        return ReflectionUtils.cast(value, destType.type);
    }

    protected Object convertStringToBoolean(FlexiJSonValue node, String value, CompiledType destType) {
        if ("true".equals(value)) {
            return this.cast(node, Boolean.TRUE, destType);
        }
        if ("false".equals(value)) {
            return this.cast(node, Boolean.FALSE, destType);
        }
        if (destType == CompiledType.BOOLEAN_WRAPPER && value == null) {
            return null;
        }
        throw new ClassCastException("Cannot cast " + value + " to " + destType);
    }

    protected Object convertStringToNumber(FlexiJSonValue node, String value, CompiledType destType) {
        if (destType.isFixedPointNumber()) {
            return this.cast(node, Long.valueOf(value), destType);
        }
        if (destType.isFloatingPointNumber()) {
            return this.cast(node, Double.valueOf(value), destType);
        }
        if (value.matches("-?\\d+")) {
            return Long.parseLong(value);
        }
        if (value.matches("-?\\d+\\.\\d+")) {
            return Double.valueOf(value).longValue();
        }
        throw new ClassCastException("Cannot cast " + value + " to " + destType);
    }

    protected Object convertToString(FlexiJSonValue node) {
        return StringUtils.valueOfOrNull(node.getValue());
    }

    protected Object convertNullToBoolean(FlexiJSonValue node) {
        return false;
    }

    protected Object convertNullToNumber(FlexiJSonValue node, CompiledType destType) {
        return this.cast(node, 0, destType);
    }

    protected Enum nodeToEnum(FlexiJSonNode json, CompiledType type) throws FlexiMapperException {
        if (((FlexiJSonValue)json).getValue() == null) {
            return null;
        }
        return Enum.valueOf(type.raw, StringUtils.valueOfOrNull(((FlexiJSonValue)json).getValue()));
    }

    protected Object handleMapperJsonNodeToObject(FlexiJSonNode json, CompiledType type, Setter setter) throws FlexiMapperException {
        boolean returnFallbackNull = false;
        for (FlexiTypeMapper mapper : this.typeMapper) {
            try {
                if (!mapper.canConvert2Object(json, type, setter)) continue;
                return mapper.json2Obj(this, json, type, setter);
            }
            catch (FlexiMapperException e) {
                this.returnFallbackOrThrowException(e);
                returnFallbackNull = true;
            }
        }
        ArrayList<FlexiTypeMapper> mappers = THREAD_MAPPERS.get();
        if (mappers != null) {
            for (FlexiTypeMapper mapper : mappers) {
                try {
                    if (!mapper.canConvert2Object(json, type, setter)) continue;
                    return mapper.json2Obj(this, json, type, setter);
                }
                catch (FlexiMapperException e) {
                    this.returnFallbackOrThrowException(e);
                    returnFallbackNull = true;
                }
            }
        }
        if (returnFallbackNull) {
            return null;
        }
        return json;
    }

    public void writeNodeToObject(CompiledType cType, FlexiJSonObject obj, Object inst) throws FlexiMapperException {
        for (KeyValueElement es : obj.getElements()) {
            Object v;
            String key = es.getKey();
            if (key == null) continue;
            Setter s = this.getSetterByKey(cType, key);
            if (s == null) {
                this.onClassFieldMissing(inst, es.getKey(), es.getValue(), cType);
                continue;
            }
            FlexiJSonNode value = es.getValue();
            CompiledType fieldType = CompiledType.create(s.getType(), cType.type);
            if (!fieldType.isGenericsResolved()) {
                this.returnFallbackOrThrowException(new FlexiMapperException(value, cType, "Cannot resolve Type " + fieldType + " " + es.getKey() + "=" + value + " to actual type ", null));
            }
            try {
                v = this.jsonToObject(value, this.mapTypeByKey(key, fieldType), s);
            }
            catch (IllegalArgumentException e) {
                this.returnFallbackOrThrowException(new FlexiMapperException(value, cType, "Cannot convert " + es.getKey() + "=" + value + " to type " + fieldType, e));
                continue;
            }
            try {
                this.setValueToObject(es.getValue(), inst, cType, v, s);
            }
            catch (FlexiMapperException e) {
                throw e;
            }
            catch (NullPointerException e) {
                if (this.isIgnoreIllegalArgumentMappings() || v == null && this.isIgnorePrimitiveNullMapping()) continue;
                this.returnFallbackOrThrowException(new ClassCastFlexiMapperException(value, fieldType, null, e, v));
            }
            catch (IllegalArgumentException e) {
                if (this.isIgnoreIllegalArgumentMappings() || v == null && this.isIgnorePrimitiveNullMapping()) continue;
                this.returnFallbackOrThrowException(new ClassCastFlexiMapperException(value, fieldType, null, e, v));
            }
            catch (Exception e) {
                this.returnFallbackOrThrowException(new ClassCastFlexiMapperException(value, fieldType, null, e, v));
            }
        }
    }

    protected void setValueToObject(FlexiJSonNode node, Object inst, CompiledType instType, Object value, Setter setter) throws IllegalAccessException, InvocationTargetException, FlexiMapperException {
        setter.setValue(inst, value);
    }

    protected Object returnFallbackOrThrowException(FlexiMapperException ex) throws FlexiMapperException {
        if (this.isCollectExceptions()) {
            if (this.exceptions == null) {
                this.exceptions = new ArrayList();
            }
            this.exceptions.add(ex);
            return null;
        }
        throw ex;
    }

    public ArrayList<FlexiMapperException> getExceptions() {
        return this.exceptions;
    }

    protected Setter getSetterByKey(CompiledType cType, String key) {
        if (key == null) {
            return null;
        }
        Setter ret = cType.getClassCache().getSetter(key);
        if (ret == null && Character.isUpperCase(key.charAt(0)) && this.isUpperCaseFirstKeyLetterIsEnabled()) {
            key = key.substring(0, 1).toLowerCase(Locale.ENGLISH) + key.substring(1);
            ret = cType.getClassCache().getSetter(key);
        }
        if (ret == null && this.isGuessKeyNameCaseEnabled()) {
            for (Setter ss : cType.getClassCache().getSetter()) {
                if (!ss.getKey().equalsIgnoreCase(key)) continue;
                if (ret != null) {
                    return null;
                }
                ret = ss;
            }
        }
        return ret;
    }

    public boolean isGuessKeyNameCaseEnabled() {
        return true;
    }

    public boolean isUpperCaseFirstKeyLetterIsEnabled() {
        return true;
    }

    protected void onClassFieldMissing(Object inst, String key, FlexiJSonNode value, CompiledType cType) throws FlexiMapperException {
    }

    public <T> T jsonToObject(FlexiJSonNode json, TypeRef<T> type) throws FlexiMapperException {
        return (T)this.jsonToObject(json, CompiledType.create(type.getType()), null);
    }

    protected CompiledType mapClasses(CompiledType class1) throws FlexiMapperException {
        if (class1.isInterface()) {
            if (class1.isSet()) {
                return CompiledType.create(this.autoMapSetInterface.type, class1.getAssignableSuperClass(Set.class).type);
            }
            if (class1.isCollection()) {
                return CompiledType.create(this.autoMapCollectionInterface.type, class1.getAssignableSuperClass(Collection.class).type);
            }
            if (class1.isMap()) {
                return CompiledType.create(this.autoMapMapInterface.type, class1.getAssignableSuperClass(Map.class).type);
            }
        }
        return class1;
    }

    public boolean isCollectExceptions() {
        return this.collectExceptions;
    }

    public void setCollectExceptions(boolean collectExceptions) {
        this.collectExceptions = collectExceptions;
    }

    public void setIgnoreIllegalArgumentMappings(boolean ignoreIllegalArgumentMappings) {
        this.ignoreIllegalArgumentMappings = ignoreIllegalArgumentMappings;
    }

    public void setIgnoreIllegalEnumMappings(boolean ignoreIllegalEnumMappings) {
        this.ignoreIllegalEnumMappings = ignoreIllegalEnumMappings;
    }

    public void setIgnorePrimitiveNullMapping(boolean ignoreIllegalNullArguments) {
        this.ignorePrimitiveNullMapping = ignoreIllegalNullArguments;
    }

    public <T> T convert(Object obj, TypeRef<T> targetType) throws FlexiMapperException {
        return this.jsonToObject(this.objectToJsonNode(obj), targetType);
    }

    public FlexiJSonNode objectToJsonNode(Object obj, TypeRef<?> targetType) throws FlexiMapperException {
        return this.objectToJsonNode(obj, CompiledType.create(targetType.getType()));
    }

    public static ArrayList<FlexiTypeMapper> getThreadMappers() {
        return THREAD_MAPPERS.get();
    }

    static {
        DEFAULTMAPPER.add(new DateMapper());
        DEFAULTMAPPER.add(new TimeSpanMapper());
        DEFAULTMAPPER.add(new LocaleMapMapper());
        THREAD_MAPPERS = new ThreadLocal();
    }
}

