/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.tests;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.SimpleMapper;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.tests.ClassWithSetsListMaps;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.simplejson.mapper.test.GenList2DTestForSImpleJson;
import org.appwork.storage.simplejson.mapper.test.GenericListTypeTestClass;
import org.appwork.storage.simplejson.mapper.test.TestClass;
import org.appwork.testframework.AWTest;

public class FlexiMapperTest
extends AWTest {
    public static void main(String[] args) throws FlexiMapperException, FlexiParserException, ParseException {
        FlexiMapperTest.run();
    }

    protected void testOnTestClass() throws Exception {
        TestClass obj = TestClass.createObject();
        this.compareTest(obj);
        this.compareTest(ClassWithSetsListMaps.filledInstance());
        FlexiJSonMapper mapper = new FlexiJSonMapper();
        FlexiJSonValue intValue = (FlexiJSonValue)mapper.objectToJsonNode(1);
        FlexiMapperTest.assertEquals(intValue.getValue(), 1);
        FlexiJSonNode node = mapper.objectToJsonNode(obj);
        FlexiMapperTest.assertEquals(((FlexiJSonValue)((FlexiJSonObject)node).resolvePath("objArray.[1].intArray.0")).getValue(), 1);
        FlexiMapperTest.assertEquals(((FlexiJSonValue)((FlexiJSonObject)node).resolvePath("objArray.[1][\"intArray\"].0")).getValue(), 1);
        FlexiMapperTest.assertEquals(((FlexiJSonValue)((FlexiJSonObject)node).resolvePath("genericClass.key")).getValue(), "mykey");
        FlexiMapperTest.assertEquals(((FlexiJSonValue)((FlexiJSonObject)node).resolvePath(".genericClass...key")).getValue(), "mykey");
        FlexiMapperTest.assertEquals(((FlexiJSonValue)((FlexiJSonObject)node).resolvePath("genericClass[\"key\"]")).getValue(), "mykey");
        FlexiMapperTest.assertEquals(((FlexiJSonValue)((FlexiJSonObject)node).resolvePath("genericClass.[\"key\"]")).getValue(), "mykey");
        FlexiMapperTest.assertEquals(((FlexiJSonValue)((FlexiJSonObject)node).resolvePath("[genericClass].[\"key\"]")).getValue(), "mykey");
        String json = new FlexiJSonStringBuilder().toJSONString(mapper.objectToJsonNode(ClassWithSetsListMaps.filledInstance()));
        System.out.println(1);
    }

    protected <T> void compareTest(final T obj) throws Exception {
        FlexiJSonMapper mapper = new FlexiJSonMapper();
        FlexiJSonNode json = mapper.objectToJsonNode(null, obj, null);
        Object re = mapper.jsonToObject(json, new TypeRef<Object>(){

            @Override
            public Type getType() {
                return obj.getClass();
            }
        });
        String a = JSonStorage.serializeToJson(obj);
        String b = JSonStorage.serializeToJson(re);
        FlexiMapperTest.assertEqualsDeep(a, b);
        FlexiMapperTest.assertEqualsDeep(obj, re);
    }

    @Override
    public void runTest() throws Exception {
        GenericListTypeTestClass ist = new GenericListTypeTestClass();
        ist.setList2D(new ArrayList(Arrays.asList(new ArrayList<Integer>(Arrays.asList(1, 2, 3)), new ArrayList<Integer>(Arrays.asList(1, 2, 3)))));
        String json = FlexiUtils.serializeToPrettyJson(ist);
        GenericListTypeTestClass<Integer> restored = FlexiUtils.jsonToObject(json, new TypeRef<GenericListTypeTestClass<Integer>>(){});
        FlexiMapperTest.assertEqualsDeep(ist, restored);
        ist = new GenericListTypeTestClass();
        ist.setList2D(new ArrayList(Arrays.asList(new ArrayList<Double>(Arrays.asList(1.0, 2.0, 3.0)), new ArrayList<Double>(Arrays.asList(1.0, 2.0, 3.0)))));
        SimpleMapper mapper = new SimpleMapper();
        String json2 = FlexiUtils.serializeToPrettyJson(ist);
        GenericListTypeTestClass<Object> restored2 = FlexiUtils.jsonToObject(json2, new TypeRef<GenericListTypeTestClass<Double>>(){});
        FlexiMapperTest.assertEqualsDeep(ist, restored2);
        ist = new GenericListTypeTestClass();
        ist.setList2D(new ArrayList(Arrays.asList(new ArrayList<GenList2DTestForSImpleJson.TEstENum>(Arrays.asList(GenList2DTestForSImpleJson.TEstENum.A, GenList2DTestForSImpleJson.TEstENum.B)), new ArrayList<GenList2DTestForSImpleJson.TEstENum>(Arrays.asList(GenList2DTestForSImpleJson.TEstENum.B, GenList2DTestForSImpleJson.TEstENum.A)))));
        mapper = new SimpleMapper();
        json2 = FlexiUtils.serializeToPrettyJson(ist);
        restored2 = FlexiUtils.jsonToObject(json2, new TypeRef<GenericListTypeTestClass<GenList2DTestForSImpleJson.TEstENum>>(){});
        FlexiMapperTest.assertEqualsDeep(ist, restored2);
        this.testOnTestClass();
    }
}

