/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.tests;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.appwork.remoteapi.annotations.ApiDocExample;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDateFormat;
import org.appwork.storage.StorableDeprecatedSince;
import org.appwork.storage.StorableExample;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.ParsingError;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiKeyLookup;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.tests.ClassPathScanner;
import org.appwork.testframework.AWTest;
import org.appwork.utils.Exceptions;

public class ValidateFlexiAnnotationsTest
extends AWTest {
    @Override
    public void runTest() throws Exception {
        new ClassPathScanner<Exception>(){

            @Override
            public void handle(Class<?> cls) throws Exception {
                if (Storable.class.isAssignableFrom(cls) && Storable.class != cls) {
                    ValidateFlexiAnnotationsTest.this.validateClass(cls);
                }
            }
        }.run();
    }

    private void validateClass(Class<?> cls) throws Exception {
        ClassCache cc = ClassCache.getClassCache(cls);
        this.extracted(cc, StorableExample.class);
        this.extracted(cc, ApiDocExample.class);
        this.extracted(cc, StorableDeprecatedSince.class);
        this.extracted(cc, StorableAvailableSince.class);
        this.extracted(cc, Deprecated.class);
        this.extracted(cc, FlexiKeyLookup.class);
    }

    public <TT extends Annotation> void extracted(ClassCache cc, Class<TT> an) throws Exception {
        for (Annotation a : cc.getAnnotations(null, an)) {
            try {
                this.validate(a, cc, null);
            }
            catch (Exception e) {
                throw Exceptions.addSuppressed(e, new Exception(a + "\r\nContext: Class: " + cc.getCachedClass() + " " + an));
            }
        }
        for (String key : cc.getKeys()) {
            for (Annotation a : cc.getAnnotations(key, an)) {
                try {
                    this.validate(a, cc, key);
                }
                catch (Exception e) {
                    throw Exceptions.addSuppressed(e, new Exception(a + "\r\nContext: Method " + cc.getCachedClass() + " - " + key + " " + an + " \r\n" + cc.getGetter(key) + "\r\n" + cc.getSetter(key)));
                }
            }
        }
    }

    private void validate(Annotation a, ClassCache cc, String key) throws Exception {
        if (a instanceof StorableExample) {
            this.validateAnnotation((StorableExample)a);
        } else if (a instanceof ApiDocExample) {
            this.validateAnnotation((ApiDocExample)a);
        } else if (a instanceof StorableDateFormat) {
            this.validateAnnotation((StorableDateFormat)a);
        } else if (a instanceof StorableAvailableSince) {
            this.validateAnnotation((StorableAvailableSince)a);
        } else if (a instanceof StorableDeprecatedSince) {
            this.validateAnnotation((StorableDeprecatedSince)a);
            if (cc.getAnnotations(key, Deprecated.class).size() == 0) {
                throw new Exception("Excepcted a @Deprecated here as well");
            }
        } else if (a instanceof Deprecated && cc.getAnnotations(key, StorableDeprecatedSince.class).size() == 0) {
            throw new Exception("Excepcted a @StorableDeprecatedSince here: " + cc + "." + key);
        }
    }

    private void validateAnnotation(StorableDeprecatedSince a) throws Exception {
        Date date = (Date)FlexiUtils.jsonToObject(FlexiUtils.serializeMinimized(a.value()), FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, new SimpleTypeRef((Type)((Object)Date.class)));
        ValidateFlexiAnnotationsTest.assertNotNull(date);
        ValidateFlexiAnnotationsTest.assertTrue(date.getTime() > ((Date)FlexiUtils.jsonToObject("\"2010-06-01T00:00+0200\"", FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, new SimpleTypeRef((Type)((Object)Date.class)))).getTime());
        ValidateFlexiAnnotationsTest.assertTrue(date.getTime() < System.currentTimeMillis());
    }

    private void validateAnnotation(StorableAvailableSince a) throws Exception {
        Date date = (Date)FlexiUtils.jsonToObject(FlexiUtils.serializeMinimized(a.value()), FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, new SimpleTypeRef((Type)((Object)Date.class)));
        ValidateFlexiAnnotationsTest.assertNotNull(date);
        ValidateFlexiAnnotationsTest.assertTrue(date.getTime() > ((Date)FlexiUtils.jsonToObject("\"2010-06-01T00:00+0200\"", FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES, new SimpleTypeRef((Type)((Object)Date.class)))).getTime());
        ValidateFlexiAnnotationsTest.assertTrue(date.getTime() < System.currentTimeMillis());
    }

    private void validateAnnotation(StorableDateFormat a) {
        new SimpleDateFormat(a.value());
    }

    private void validateAnnotation(ApiDocExample a) throws FlexiParserException, FlexiMapperException {
        FlexiJSONParser parser = new FlexiJSONParser(a.value()){

            @Override
            public boolean isParseInlineCommentEnabled() {
                return true;
            }

            @Override
            public boolean isParseLineCommentEnabled() {
                return true;
            }
        };
        parser.setDebug(new StringBuilder());
        HashSet<ParsingError> ignore = new HashSet<ParsingError>(FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES);
        parser.setIgnoreIssues(ignore);
        Object example = new FlexiJSonMapper().jsonToObject(parser.parse(), TypeRef.OBJECT);
    }

    private void validateAnnotation(StorableExample a) throws FlexiParserException, FlexiMapperException {
        FlexiJSONParser parser = new FlexiJSONParser(a.value()){

            @Override
            public boolean isParseInlineCommentEnabled() {
                return true;
            }

            @Override
            public boolean isParseLineCommentEnabled() {
                return true;
            }
        };
        parser.setDebug(new StringBuilder());
        HashSet<ParsingError> ignore = new HashSet<ParsingError>(FlexiJSONParser.IGNORE_LIST_ENSURE_CORRECT_VALUES);
        parser.setIgnoreIssues(ignore);
        Object example = new FlexiJSonMapper().jsonToObject(parser.parse(), TypeRef.OBJECT);
    }

    public static void main(String[] args) {
        ValidateFlexiAnnotationsTest.run();
    }
}

