/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.typemapper;

import java.awt.Color;
import java.util.List;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiTypeMapper;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.utils.reflection.CompiledType;

public class ColorMapper
implements FlexiTypeMapper {
    @Override
    public FlexiJSonNode obj2JSon(FlexiJSonMapper mapper, Object obj, Getter reference, List<CompiledType> typeHirarchy) {
        int length;
        String hex;
        Color c = (Color)obj;
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        if (c.getAlpha() == 255) {
            hex = Integer.toHexString(c.getRGB() & 0xFFFFFF);
            length = 6;
        } else {
            hex = Integer.toHexString(c.getRGB() & 0xFFFFFFFF);
            length = 8;
        }
        for (int i = 0; i < length - hex.length(); ++i) {
            sb.append("0");
        }
        sb.append(hex);
        if (mapper != null) {
            return mapper.createFlexiJSonValue(sb.toString());
        }
        return new FlexiJSonValue(sb.toString());
    }

    @Override
    public Object json2Obj(FlexiJSonMapper mapper, FlexiJSonNode json, CompiledType type, Setter setter) {
        String str = (String)((FlexiJSonValue)json).getValue();
        if (str.length() > 7) {
            return new Color(Integer.parseInt(str.substring(1), 16), true);
        }
        return new Color(Integer.parseInt(str.substring(1), 16), false);
    }

    @Override
    public boolean canConvert2Json(Object obj, Getter getter) {
        return obj != null && obj instanceof Color;
    }

    @Override
    public boolean canConvert2Object(FlexiJSonNode node, CompiledType type, Setter setter) {
        return type.type == Color.class;
    }
}

