/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.tests;

import org.appwork.loggingv3.LogV3;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.FlexiVisitor;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.tests.ObjectContainsAll;
import org.appwork.testframework.AWTest;
import org.appwork.utils.Hash;

public class FlexiUtilsWalkTest
extends AWTest {
    @Override
    public void runTest() throws Exception {
        FlexiJSonMapper mapper = new FlexiJSonMapper(){

            @Override
            protected boolean isAnnotationCommentsEnabled() {
                return true;
            }
        };
        FlexiJSonObject node = (FlexiJSonObject)mapper.objectToJsonNode(new ObjectContainsAll());
        node.getNode("integerArray").addCommentsBefore(new FlexiJSonComments(new FlexiComment("Before", FlexiComment.Type.INLINE, FlexiMapperTags.DOCS), new FlexiComment("Before2", FlexiComment.Type.INLINE, FlexiMapperTags.DOCS)));
        node.getNode("integerArray").addCommentsAfter(new FlexiJSonComments(new FlexiComment("After", FlexiComment.Type.INLINE, FlexiMapperTags.DOCS)));
        final StringBuilder sb = new StringBuilder();
        FlexiUtils.walk(node, new FlexiVisitor(){

            @Override
            public void openObject(FlexiJSonObject obj, JSPath path) {
                sb.append("Open " + path.toPathString(true));
                sb.append("\r\n");
            }

            @Override
            public void openArray(FlexiJSonArray array, JSPath path) {
                sb.append("Open " + path.toPathString(true));
                sb.append("\r\n");
            }

            @Override
            public void onValue(FlexiJSonValue value, JSPath path) {
                sb.append("Value " + path.toPathString(true) + " = " + value.getValue());
                sb.append("\r\n");
            }

            @Override
            public void onComment(FlexiCommentJsonNode comment, JSPath path) {
                sb.append("Comment " + path.toPathString(true) + " = " + ((FlexiComment)comment).getText());
                sb.append("\r\n");
            }

            @Override
            public void closeObject(FlexiJSonObject obj, JSPath path) {
                sb.append("Close " + path.toPathString(true));
                sb.append("\r\n");
            }

            @Override
            public void closeArray(FlexiJSonArray array, JSPath path) {
                sb.append("Close " + path.toPathString(true));
                sb.append("\r\n");
            }
        });
        LogV3.info(sb.toString());
        FlexiUtilsWalkTest.assertEquals(Hash.getSHA256(sb.toString()), "b5e87ef4cacb5ad9c676af2c7491097e6890a1819ead9178268919dc23d3beea");
    }

    public static void main(String[] args) {
        FlexiUtilsWalkTest.run();
    }
}

