/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.GetterOrSetter;

public class Getter
implements GetterOrSetter {
    private static final List<String> NULL_LIST = Collections.unmodifiableList(new ArrayList());
    public final List<String> alternativeKeys;
    public final String key;
    public final Type type;
    public final Method method;
    public final Field field;
    public final ClassCache classCache;

    public Field getField() {
        return this.field;
    }

    public Getter(ClassCache cc, String name, List<String> alternativeKeys, Method m, Field field) {
        this.classCache = cc;
        this.key = name;
        this.field = field;
        this.method = m;
        this.alternativeKeys = alternativeKeys == null ? NULL_LIST : Collections.unmodifiableList(alternativeKeys);
        m.setAccessible(true);
        this.type = m.getGenericReturnType();
    }

    public Getter(ClassCache cc, String name, Method m) {
        this(cc, name, null, m, null);
    }

    public List<String> getAlternativeKeys() {
        return this.alternativeKeys;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public Object getValue(Object obj) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.method.invoke(obj, new Object[0]);
    }

    public String toString() {
        return this.method.toString();
    }
}

