/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.MapperType;
import org.appwork.storage.StorableSupportedMappers;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.JSonArray;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.storage.simplejson.JSonValue;
import org.appwork.storage.simplejson.JsonObjectLinkedHashMap;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.ClassCastMappingException;
import org.appwork.storage.simplejson.mapper.DateMapper;
import org.appwork.storage.simplejson.mapper.FailedToCreateInstanceMapperException;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.storage.simplejson.mapper.MapperException;
import org.appwork.storage.simplejson.mapper.Setter;
import org.appwork.storage.simplejson.mapper.TimeSpanMapper;
import org.appwork.storage.simplejson.mapper.TypeMapper;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.reflection.Clazz;

public class JSonMapper {
    private boolean ignorePrimitiveNullMapping = false;
    private boolean ignoreIllegalArgumentMappings = false;
    private boolean ignoreIllegalEnumMappings = false;
    protected final HashMap<Class<?>, TypeMapper<?>> typeMapper = new HashMap();
    protected Class<?> autoMapJsonObjectClass = LinkedHashMap.class;
    protected Class<?> autoMapJsonArrayclass = LinkedList.class;
    private ArrayList<MapperException> exceptions;
    private boolean collectExceptions = false;

    public JSonMapper() {
        this.addMapper(Date.class, new DateMapper());
        this.addMapper(TimeSpan.class, new TimeSpanMapper());
    }

    public <T> void addMapper(Class<T> class1, TypeMapper<T> fileMapper) {
        this.typeMapper.put(class1, fileMapper);
    }

    public JSonNode create(Object obj) throws MapperException {
        if (obj == null) {
            return this.createJsonValue((String)null);
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return this.createJsonValue((Boolean)obj);
            }
            if (clazz == Character.TYPE) {
                return this.createJsonValue('\u0000' + ((Character)obj).charValue());
            }
            if (Clazz.isNumberType(clazz)) {
                return this.createJsonValue((Number)obj);
            }
            throw new WTFException("Unknown Primitive Type: " + clazz);
        }
        if (clazz.isEnum() || Enum.class.isAssignableFrom(clazz)) {
            return this.createJsonValue(obj + "");
        }
        if (obj instanceof Boolean) {
            return this.createJsonValue((Boolean)obj);
        }
        if (obj instanceof Character) {
            return this.createJsonValue('\u0000' + ((Character)obj).charValue());
        }
        if (obj instanceof Number) {
            return this.createJsonValue((Number)obj);
        }
        if (obj instanceof String) {
            return this.createJsonValue((String)obj);
        }
        if (obj instanceof CharSequence) {
            return this.createJsonValue(((CharSequence)obj).toString());
        }
        if (obj instanceof Map) {
            JSonObject ret = this.createJSonObject(null);
            for (Map.Entry next : ((Map)obj).entrySet()) {
                if (!(next.getKey() instanceof String)) {
                    this.returnFallbackOrThrowException(new MapperException((JSonNode)ret, obj.getClass(), "Map keys have to be Strings: " + clazz + " Keyclass:" + (next.getKey() == null ? "<null>" : next.getKey().getClass())));
                    continue;
                }
                ret.put(next.getKey().toString(), this.create(next.getValue()));
            }
            return this.createJSonObject(ret);
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            JSonArray ret = new JSonArray(col.size());
            for (Object o : col) {
                ret.add(this.create(o));
            }
            return ret;
        }
        if (clazz.isArray()) {
            int length = Array.getLength(obj);
            JSonArray ret = new JSonArray(length);
            for (int i = 0; i < length; ++i) {
                ret.add(this.create(Array.get(obj, i)));
            }
            return ret;
        }
        if (obj instanceof Class) {
            return this.createJsonValue(((Class)obj).getName());
        }
        TypeMapper<?> mapper = this.typeMapper.get(clazz);
        if (mapper != null) {
            return mapper.map(obj);
        }
        JSonObject ret = this.createJSonObject(null);
        try {
            ClassCache cc = this.getClassCache(clazz);
            for (Getter g : cc.getGetter()) {
                try {
                    this.serialize(obj, ret, cc, g);
                }
                catch (IllegalArgumentException e) {
                    this.returnFallbackOrThrowException(new MapperException(ret, clazz, e.getMessage(), e));
                }
                catch (IllegalAccessException e) {
                    this.returnFallbackOrThrowException(new MapperException(ret, clazz, e.getMessage(), e));
                }
                catch (InvocationTargetException e) {
                    this.returnFallbackOrThrowException(new MapperException(ret, clazz, e.getMessage(), e));
                }
            }
        }
        catch (SecurityException e) {
            this.returnFallbackOrThrowException(new MapperException(ret, clazz, e.getMessage(), e));
        }
        catch (NoSuchMethodException e) {
            this.returnFallbackOrThrowException(new MapperException(ret, clazz, e.getMessage(), e));
        }
        return this.createJSonObject(ret);
    }

    protected void serialize(Object obj, JSonObject ret, ClassCache cc, Getter getter) throws MapperException, IllegalAccessException, InvocationTargetException {
        String key = getter.getKey();
        Object value = getter.getValue(obj);
        JSonNode node = this.create(value);
        ret.put(key, node);
    }

    public ClassCache getClassCache(Class<? extends Object> clazz) throws SecurityException, NoSuchMethodException {
        return ClassCache.getClassCache(clazz);
    }

    protected JSonObject createJSonObject(JSonObject map) {
        if (map == null) {
            return new JsonObjectLinkedHashMap();
        }
        return new JsonObjectLinkedHashMap(map);
    }

    protected JSonValue createJsonValue(Number longValue) {
        return new JSonValue(longValue);
    }

    protected JSonValue createJsonValue(Boolean value) {
        if (value == null) {
            return JSonValue.BOOLEAN_NULL;
        }
        if (value.booleanValue()) {
            return JSonValue.BOOLEAN_TRUE;
        }
        return JSonValue.BOOLEAN_FALSE;
    }

    protected JSonValue createJsonValue(String value) {
        if (value == null) {
            return JSonValue.NULL;
        }
        return new JSonValue(value);
    }

    public boolean isIgnoreIllegalArgumentMappings() {
        return this.ignoreIllegalArgumentMappings;
    }

    public boolean isIgnoreIllegalEnumMappings() {
        return this.ignoreIllegalEnumMappings;
    }

    public boolean isIgnorePrimitiveNullMapping() {
        return this.ignorePrimitiveNullMapping;
    }

    protected Collection<Object> optimizeCollection(Class mapClass, Collection<Object> col) {
        try {
            if (col instanceof CopyOnWriteArraySet || col instanceof CopyOnWriteArrayList) {
                return col;
            }
            if (col instanceof ArrayList) {
                ((ArrayList)col).trimToSize();
                return col;
            }
            if (col instanceof LinkedList) {
                return col;
            }
            Constructor constructor = mapClass.getConstructor(Collection.class);
            Collection ret = (Collection)constructor.newInstance(col);
            return ret;
        }
        catch (Exception e) {
            return col;
        }
    }

    protected Map<String, Object> optimizeMap(Class mapClass, Map<String, Object> map) {
        try {
            Constructor constructor = mapClass.getConstructor(Map.class);
            Map ret = (Map)constructor.newInstance(map);
            return ret;
        }
        catch (Exception e) {
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object jsonToObject(JSonNode json, Type type) throws MapperException {
        try {
            ClassCache cc;
            Object inst;
            JSonNode obj;
            Object inst2;
            Class<?> mapClass;
            TypeMapper<?> tm;
            StorableSupportedMappers supported;
            Class<Object> clazz = null;
            if (type instanceof ParameterizedType) {
                Type typ = ((ParameterizedType)((Object)type)).getRawType();
                if (typ instanceof Class) {
                    clazz = (Class<?>)typ;
                }
            } else if (type instanceof Class) {
                clazz = type;
            } else if (type instanceof GenericArrayType) {
                clazz = Array.newInstance((Class)((GenericArrayType)((Object)type)).getGenericComponentType(), 0).getClass();
                type = clazz;
            }
            if (clazz == null || clazz == Object.class) {
                if (json instanceof JSonArray) {
                    clazz = this.autoMapJsonArrayclass;
                    type = clazz;
                } else if (json instanceof JSonObject) {
                    clazz = this.autoMapJsonObjectClass;
                    type = clazz;
                } else if (json instanceof JSonValue) {
                    JSonValue jsonValue = (JSonValue)json;
                    Object value = jsonValue.getValue();
                    switch (jsonValue.getType()) {
                        case BOOLEAN: {
                            clazz = Boolean.TYPE;
                            type = clazz;
                            break;
                        }
                        case DOUBLE: {
                            if (value != null && Clazz.isFloatingPointNumber(value.getClass())) {
                                clazz = value.getClass();
                                type = clazz;
                                break;
                            }
                            clazz = Double.TYPE;
                            type = clazz;
                            break;
                        }
                        case LONG: {
                            if (value != null && Clazz.isFixedPointNumber(value.getClass())) {
                                clazz = value.getClass();
                                type = clazz;
                                break;
                            }
                            clazz = Long.TYPE;
                            type = clazz;
                            break;
                        }
                        case NULL: 
                        case STRING: {
                            clazz = String.class;
                            type = String.class;
                            break;
                        }
                    }
                }
            }
            if (!Application.isJared(null) && (supported = clazz.getAnnotation(StorableSupportedMappers.class)) != null && !Arrays.asList(supported.value()).contains((Object)MapperType.AW_SIMPLE)) {
                DebugMode.debugger();
            }
            if ((tm = this.typeMapper.get(clazz)) != null) {
                return tm.reverseMap(json);
            }
            if (json instanceof JSonValue) {
                if (!(Clazz.isPrimitive(type) || Clazz.isString(type) || type == Object.class || ((JSonValue)json).getValue() == null || Clazz.isEnum(type))) {
                    return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, null, null, null));
                }
                switch (((JSonValue)json).getType()) {
                    case BOOLEAN: 
                    case DOUBLE: 
                    case LONG: {
                        if (!(type instanceof Class)) {
                            return ((JSonValue)json).getValue();
                        }
                        try {
                            return ReflectionUtils.cast(((JSonValue)json).getValue(), type);
                        }
                        catch (ClassCastException e) {
                            if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, null, e, null));
                            return null;
                        }
                    }
                    case STRING: {
                        if (type instanceof Class && type.isEnum()) {
                            try {
                                return Enum.valueOf(type, StringUtils.valueOfOrNull(((JSonValue)json).getValue()));
                            }
                            catch (IllegalArgumentException e) {
                                if (this.isIgnoreIllegalArgumentMappings()) return null;
                                if (this.isIgnoreIllegalEnumMappings()) return null;
                                return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, null, e, null));
                            }
                        }
                        if (!(type instanceof Class)) return ((JSonValue)json).getValue();
                        if (!Clazz.isNumberType(type)) {
                            if (!Clazz.isBoolean(type)) return ((JSonValue)json).getValue();
                        }
                        try {
                            return ReflectionUtils.cast(((JSonValue)json).getValue(), type);
                        }
                        catch (ClassCastException e) {
                            if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, null, e, null));
                            return null;
                        }
                    }
                    case NULL: {
                        if (!(type instanceof Class)) return null;
                        if (!Clazz.isNumberType(type)) {
                            if (!Clazz.isBoolean(type)) return null;
                        }
                        try {
                            return ReflectionUtils.cast(((JSonValue)json).getValue(), type);
                        }
                        catch (ClassCastException e) {
                            if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, null, e, null));
                            return null;
                        }
                    }
                }
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)((Object)type);
                Type raw = pType.getRawType();
                if (raw instanceof Class && Collection.class.isAssignableFrom((Class)raw)) {
                    Collection inst3;
                    Class<?> mapClass2;
                    try {
                        mapClass2 = this.mapClasses((Class)raw);
                        inst3 = (Collection)mapClass2.newInstance();
                    }
                    catch (Exception e) {
                        return this.returnFallbackOrThrowException(new FailedToCreateInstanceMapperException(json, type, (Class)raw, e));
                    }
                    JSonArray obj2 = (JSonArray)json;
                    Iterator iterator = obj2.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return this.optimizeCollection(mapClass2, inst3);
                        }
                        JSonNode n = (JSonNode)iterator.next();
                        inst3.add(this.jsonToObject(n, pType.getActualTypeArguments()[0]));
                    }
                }
                if (raw instanceof Class && Map.class.isAssignableFrom((Class)raw)) {
                    Map inst4;
                    Class<?> mapClass3;
                    try {
                        mapClass3 = this.mapClasses((Class)raw);
                        inst4 = (Map)mapClass3.newInstance();
                    }
                    catch (Exception e) {
                        return this.returnFallbackOrThrowException(new FailedToCreateInstanceMapperException(json, type, (Class)raw, e));
                    }
                    JSonObject obj3 = (JSonObject)json;
                    Iterator it = obj3.entrySet().iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            return this.optimizeMap(mapClass3, inst4);
                        }
                        Map.Entry next = it.next();
                        inst4.put(next.getKey(), this.jsonToObject((JSonNode)next.getValue(), pType.getActualTypeArguments()[1]));
                    }
                }
            }
            if (clazz == null) {
                System.err.println("TYPE?!");
                return null;
            }
            if (clazz == Object.class) {
                if (json instanceof JSonArray) {
                    type = this.autoMapJsonArrayclass;
                } else if (json instanceof JSonObject) {
                    type = this.autoMapJsonObjectClass;
                }
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                try {
                    mapClass = this.mapClasses(clazz);
                    inst2 = (Collection)mapClass.newInstance();
                }
                catch (Exception e) {
                    return this.returnFallbackOrThrowException(new FailedToCreateInstanceMapperException(json, type, clazz, e));
                }
                JSonArray obj4 = (JSonArray)json;
                Type gs = clazz.getGenericSuperclass();
                Type gType = gs instanceof ParameterizedType ? ((ParameterizedType)gs).getActualTypeArguments()[0] : Void.TYPE;
                Iterator next = obj4.iterator();
                while (true) {
                    if (!next.hasNext()) {
                        return this.optimizeCollection(mapClass, (Collection<Object>)inst2);
                    }
                    JSonNode n = (JSonNode)next.next();
                    inst2.add(this.jsonToObject(n, gType));
                }
            }
            if (Map.class.isAssignableFrom(clazz)) {
                try {
                    mapClass = this.mapClasses(clazz);
                    inst2 = (Map)mapClass.newInstance();
                }
                catch (Exception e) {
                    return this.returnFallbackOrThrowException(new FailedToCreateInstanceMapperException(json, type, clazz, e));
                }
                JSonObject obj5 = (JSonObject)json;
                Type gs = clazz.getGenericSuperclass();
                Type gType = gs instanceof ParameterizedType ? ((ParameterizedType)gs).getActualTypeArguments()[1] : Void.TYPE;
                Iterator it = obj5.entrySet().iterator();
                while (true) {
                    if (!it.hasNext()) {
                        return this.optimizeMap(mapClass, (Map<String, Object>)inst2);
                    }
                    Map.Entry next = it.next();
                    inst2.put(next.getKey(), this.jsonToObject((JSonNode)next.getValue(), gType));
                }
            }
            if (!clazz.isArray()) {
                if (json instanceof JSonArray) {
                    obj = (JSonArray)json;
                    inst = new ArrayList(((ArrayList)((Object)obj)).size());
                    Type gs = clazz.getGenericSuperclass();
                    Object gType = gs instanceof ParameterizedType ? ((ParameterizedType)gs).getActualTypeArguments()[0] : Object.class;
                    Iterator iterator = ((ArrayList)((Object)obj)).iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return inst;
                        }
                        JSonNode n = (JSonNode)iterator.next();
                        inst.add(this.jsonToObject(n, (Type)gType));
                    }
                }
                obj = (JSonObject)json;
                if (Clazz.isPrimitive(clazz)) {
                    if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, "Cannot map JSonObject to a Primitive " + clazz, null, null));
                    return null;
                }
                if (Clazz.isString(clazz)) {
                    if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, "Cannot map JSonObject to a String " + clazz, null, null));
                    return null;
                }
                if (clazz.isEnum() || Enum.class.isAssignableFrom(clazz)) {
                    if (!this.isIgnoreIllegalArgumentMappings()) return this.returnFallbackOrThrowException(new ClassCastMappingException(json, type, "Cannot map JSonObject to a Enum " + clazz, null, null));
                    return null;
                }
                inst = null;
                try {
                    cc = ClassCache.getClassCache(clazz);
                    inst = this.createNewInstance(cc);
                }
                catch (Exception e1) {
                    return this.returnFallbackOrThrowException(new FailedToCreateInstanceMapperException(json, type, clazz, e1));
                }
            }
            obj = (JSonArray)json;
            Object arr = Array.newInstance(this.mapClasses(clazz.getComponentType()), ((ArrayList)((Object)obj)).size());
            int i = 0;
            while (true) {
                if (i >= ((ArrayList)((Object)obj)).size()) {
                    return arr;
                }
                Object v = this.jsonToObject((JSonNode)((ArrayList)((Object)obj)).get(i), clazz.getComponentType());
                try {
                    Array.set(arr, i, v);
                }
                catch (IllegalArgumentException e) {
                    this.returnFallbackOrThrowException(new MapperException((JSonNode)((ArrayList)((Object)obj)).get(i), this.mapClasses(clazz.getComponentType()), "Cannot convert index [" + i + "] = " + ((ArrayList)((Object)obj)).get(i) + " to type " + this.mapClasses(clazz.getComponentType()), e));
                    Array.set(arr, i, null);
                }
                ++i;
            }
            Iterator iterator = obj.entrySet().iterator();
            block48: while (true) {
                if (!iterator.hasNext()) {
                    return inst;
                }
                Map.Entry es = iterator.next();
                String key = (String)es.getKey();
                Setter s = this.getSetterByKey(cc, key);
                if (s == null) {
                    this.onClassFieldMissing(inst, (String)es.getKey(), (JSonNode)es.getValue());
                    continue;
                }
                JSonNode value = (JSonNode)es.getValue();
                Type fieldType = s.getType();
                Class cls = s.getMethod().getDeclaringClass();
                block49: while (true) {
                    Object[] types;
                    Type[] actual;
                    if (fieldType instanceof TypeVariable) {
                        ParameterizedType parameterized = cc.getParameterizedType(cls);
                        if (parameterized == null && type instanceof ParameterizedType) {
                            parameterized = (ParameterizedType)((Object)type);
                        }
                        actual = parameterized.getActualTypeArguments();
                        types = cls.getTypeParameters();
                    } else {
                        Object v;
                        try {
                            v = this.jsonToObject(value, fieldType);
                        }
                        catch (IllegalArgumentException e) {
                            this.returnFallbackOrThrowException(new MapperException(value, type, "Cannot convert " + (String)es.getKey() + "=" + value + " to type " + fieldType, e));
                            continue block48;
                        }
                        try {
                            s.setValue(inst, v);
                        }
                        catch (NullPointerException e) {
                            if (this.isIgnoreIllegalArgumentMappings() || v == null && this.isIgnorePrimitiveNullMapping()) continue block48;
                            this.returnFallbackOrThrowException(new ClassCastMappingException(value, s.getType(), null, e, v));
                        }
                        catch (IllegalArgumentException e) {
                            if (this.isIgnoreIllegalArgumentMappings() || v == null && this.isIgnorePrimitiveNullMapping()) continue block48;
                            this.returnFallbackOrThrowException(new ClassCastMappingException(value, s.getType(), null, e, v));
                        }
                        catch (Exception e) {
                            this.returnFallbackOrThrowException(new ClassCastMappingException(value, s.getType(), null, e, v));
                        }
                        continue block48;
                    }
                    for (int i2 = 0; i2 < types.length; ++i2) {
                        if (!StringUtils.equals(((TypeVariable)fieldType).getName(), types[i2].getName())) continue;
                        fieldType = actual[i2];
                        Type extendingClass = cc.getExtendedType(cls);
                        if (extendingClass == null) continue block49;
                        if (extendingClass instanceof Class) {
                            cls = (Class)extendingClass;
                            continue block49;
                        }
                        cls = (Class)((ParameterizedType)extendingClass).getRawType();
                        continue block49;
                    }
                    this.returnFallbackOrThrowException(new MapperException(value, type, "Cannot resolve Type " + cls + "/" + Arrays.toString(types) + " - " + fieldType + " " + (String)es.getKey() + "=" + value + " to type " + fieldType, null));
                }
                break;
            }
        }
        catch (MapperException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return this.returnFallbackOrThrowException(new MapperException(json, type, e));
        }
    }

    protected Object createNewInstance(ClassCache cc) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return cc.getInstance();
    }

    protected Object returnFallbackOrThrowException(MapperException ex) throws MapperException {
        if (this.isCollectExceptions()) {
            if (this.exceptions == null) {
                this.exceptions = new ArrayList();
            }
            this.exceptions.add(ex);
            return null;
        }
        throw ex;
    }

    public ArrayList<MapperException> getExceptions() {
        return this.exceptions;
    }

    protected Setter getSetterByKey(ClassCache cc, String key) {
        return cc.getSetter(key);
    }

    protected void onClassFieldMissing(Object inst, String key, JSonNode value) throws MapperException {
    }

    public <T> T jsonToObject(JSonNode json, TypeRef<T> type) throws MapperException {
        return (T)this.jsonToObject(json, type.getType());
    }

    protected Class<?> mapClasses(Class<?> class1) throws MapperException {
        if (class1.isInterface()) {
            if (List.class.isAssignableFrom(class1)) {
                return ArrayList.class;
            }
            if (Map.class.isAssignableFrom(class1)) {
                return LinkedHashMap.class;
            }
            if (Set.class.isAssignableFrom(class1)) {
                return CopyOnWriteArraySet.class;
            }
            throw new WTFException("Interface not supported: " + class1);
        }
        return class1;
    }

    public boolean isCollectExceptions() {
        return this.collectExceptions;
    }

    public void setCollectExceptions(boolean collectExceptions) {
        this.collectExceptions = collectExceptions;
    }

    public void setIgnoreIllegalArgumentMappings(boolean ignoreIllegalArgumentMappings) {
        this.ignoreIllegalArgumentMappings = ignoreIllegalArgumentMappings;
    }

    public void setIgnoreIllegalEnumMappings(boolean ignoreIllegalEnumMappings) {
        this.ignoreIllegalEnumMappings = ignoreIllegalEnumMappings;
    }

    public void setIgnorePrimitiveNullMapping(boolean ignoreIllegalNullArguments) {
        this.ignorePrimitiveNullMapping = ignoreIllegalNullArguments;
    }
}

