/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.tests;

import java.lang.reflect.Type;
import org.appwork.storage.JSONMapper;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.tests.SimpleStorable;
import org.appwork.testframework.AWTest;

public abstract class AbstractMapperTest
extends AWTest {
    public void runWith(JSONMapper mapper) throws Exception {
        AbstractMapperTest.assertEquals("10", mapper.stringToObject("10", String.class));
        AbstractMapperTest.assertEquals("1.0", mapper.stringToObject("1.0", String.class));
        AbstractMapperTest.assertEquals("false", mapper.stringToObject("false", String.class));
        AbstractMapperTest.assertEquals(0.0, mapper.stringToObject("null", Double.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Double.class))));
        AbstractMapperTest.assertEquals(Float.valueOf(0.0f), mapper.stringToObject("null", Float.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Float.class))));
        AbstractMapperTest.assertEquals(0L, mapper.stringToObject("null", Long.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Long.class))));
        AbstractMapperTest.assertEquals(0, mapper.stringToObject("null", Integer.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Integer.class))));
        AbstractMapperTest.assertEquals(Character.valueOf('\u0000'), mapper.stringToObject("null", Character.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Character.class))));
        AbstractMapperTest.assertEquals((short)0, mapper.stringToObject("null", Short.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Short.class))));
        AbstractMapperTest.assertEquals((byte)0, mapper.stringToObject("null", Byte.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Byte.class))));
        AbstractMapperTest.assertEquals(false, mapper.stringToObject("null", Boolean.TYPE));
        AbstractMapperTest.assertEquals(null, mapper.stringToObject("null", new SimpleTypeRef((Type)((Object)Boolean.class))));
        SimpleStorable obj = new SimpleStorable();
        obj.setB(true);
        obj.setBa(new boolean[]{true, false, true});
        obj.setI(12367);
        obj.setL(System.currentTimeMillis());
        obj.setLa(new long[]{System.currentTimeMillis(), 0L, System.currentTimeMillis()});
        obj.setIa(new int[]{1, 2, 3, 4, 5});
        obj.setString("Hello again");
        obj.setStringa(new String[]{"a", "b", "C"});
        String json = mapper.objectToString(obj);
        SimpleStorable restored = (SimpleStorable)mapper.stringToObject(json, new SimpleTypeRef((Type)((Object)SimpleStorable.class)));
        AbstractMapperTest.assertEqualsDeep(restored, obj);
    }
}

