/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.tests;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.test.BadTestObject;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.test.TestClass;
import org.appwork.storage.tests.ClassPathScanner;
import org.appwork.storage.tests.StorableValidatorTest;
import org.appwork.testframework.IgnoreInAWTest;

public class ConfigInterfaceValidator
extends StorableValidatorTest {
    public static void main(String[] args) {
        ConfigInterfaceValidator.run();
    }

    @Override
    public void runTest() throws Exception {
        final ArrayList tested = new ArrayList();
        new ClassPathScanner<Exception>(){

            @Override
            public void handle(Class<?> cls) throws Exception {
                if (ConfigInterface.class.isAssignableFrom(cls) && ConfigInterface.class != cls) {
                    ConfigInterfaceValidator.this.validateClass(cls);
                    tested.add(cls);
                }
            }
        }.run();
    }

    @Override
    protected ClassCache createClassCache(Class<?> cls) throws Exception {
        ClassCache.Rules rules = new ClassCache.Rules();
        rules.setIgnoreMissingConstructor(true);
        return ClassCache.create(cls, rules);
    }

    @Override
    protected void checkNoGetterSetter(ClassCache classCache, Class<?> cls) throws Exception {
    }

    @Override
    protected boolean skipValidation(Class<?> cls) throws Exception {
        if (BadTestObject.class == cls) {
            return true;
        }
        if (TestClass.class == cls) {
            return true;
        }
        if (cls.getAnnotation(IgnoreInAWTest.class) != null) {
            return true;
        }
        if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
            return false;
        }
        return false;
    }

    @Override
    protected void checkMissingConstructor(Class<?> cls) throws Exception {
    }
}

