/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;

public class ExtTextHighlighter {
    protected final Highlighter.HighlightPainter painter;
    protected final Matcher matcher;

    public ExtTextHighlighter(Highlighter.HighlightPainter painter, Pattern pattern) {
        this.painter = painter;
        this.matcher = pattern.matcher("");
    }

    public boolean highlight(Highlighter highlighter, CharSequence charSequence) {
        this.matcher.reset(charSequence);
        boolean ret = false;
        while (this.matcher.find()) {
            int start = this.matcher.start(1);
            int stop = this.matcher.end(1);
            if (start == -1 || stop == -1) continue;
            try {
                highlighter.addHighlight(start, stop, this.painter);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            ret = true;
        }
        return ret;
    }
}

