/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.appwork.exceptions.WTFException;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.tree.TreeNodeInterface;
import org.appwork.swing.exttable.tree.TreePosition;

public abstract class ExtTreeTableModel<T extends TreeNodeInterface>
extends ExtTableModel<T> {
    private List<T> tree;

    public List<T> getTree() {
        return this.tree;
    }

    public ExtTreeTableModel(String id) {
        super(id);
    }

    public void setTreeData(ArrayList<T> newtableData, boolean refreshSOrt) {
        ArrayList list = new ArrayList();
        for (TreeNodeInterface node : newtableData) {
            this.unpack(list, node);
        }
        this.tree = newtableData;
        this._fireTableStructureChanged(list, refreshSOrt);
    }

    @Override
    public void addAllElements(Collection<T> entries) {
        throw new WTFException("Not Implemented");
    }

    @Override
    public void addAllElements(T ... files) {
        throw new WTFException("Not Implemented");
    }

    @Override
    public void addElement(T at) {
        throw new WTFException("Not Implemented");
    }

    @Override
    public List<T> getElements() {
        return super.getElements();
    }

    @Override
    public void refreshSort() {
        super.refreshSort();
    }

    public boolean move(T group, int i, List<T> imports) {
        try {
            List<Object> children;
            List<Object> list = children = group == null ? this.tree : group.getChildren();
            if (i < 0) {
                i = children.size();
            }
            ArrayList<Object> newdata = new ArrayList<Object>(children.size());
            ArrayList<Object> before = new ArrayList<Object>(children.subList(0, i));
            ArrayList<Object> after = new ArrayList<Object>(children.subList(i, children.size()));
            this.internalRemove(before, new HashSet<T>(imports));
            this.internalRemove(after, new HashSet<T>(imports));
            this.internalRemove(this.tree, new HashSet<T>(imports));
            newdata.addAll(before);
            newdata.addAll(imports);
            newdata.addAll(after);
            for (TreeNodeInterface t : imports) {
                t.setParent((TreeNodeInterface)group);
            }
            children.clear();
            children.addAll(newdata);
            this.setTreeData((ArrayList)this.tree, true);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public T getParentByRow(int dropRow) {
        for (int i = dropRow - 1; i >= 0; --i) {
            TreeNodeInterface rowObject = (TreeNodeInterface)this.getObjectbyRow(i);
            if (rowObject.isLeaf()) continue;
            return (T)rowObject;
        }
        return null;
    }

    public TreePosition<T> getTreePositionByRow(int dropRow) {
        TreeNodeInterface rowObject;
        TreeNodeInterface beforeElement = (TreeNodeInterface)this.getObjectbyRow(dropRow - 1);
        TreeNodeInterface afterElement = (TreeNodeInterface)this.getObjectbyRow(dropRow);
        if (beforeElement == null) {
            return new TreePosition<Object>(null, 0);
        }
        TreeNodeInterface parent = beforeElement.getParent();
        if (afterElement != null && afterElement.getParent() == beforeElement) {
            parent = beforeElement;
        }
        int index = 0;
        for (int i = dropRow - 1; i >= 0 && (rowObject = (TreeNodeInterface)this.getObjectbyRow(i)).getParent() == parent; --i) {
            ++index;
        }
        return new TreePosition<TreeNodeInterface>(parent, index);
    }

    public void remove(T ai) {
        HashSet<T> del = new HashSet<T>();
        del.add(ai);
        this.internalRemove(this.tree, del);
        this.setTreeData((ArrayList)this.tree, true);
    }

    public TreePosition<T> getTreePositionByObject(T parent) {
        int counter = -1;
        for (int i = this.getTableData().size() - 1; i >= 0; --i) {
            TreeNodeInterface obj = (TreeNodeInterface)this.getTableData().get(i);
            if (parent == obj) {
                counter = 0;
                continue;
            }
            if (parent.getParent() != obj.getParent() || counter < 0) continue;
            ++counter;
        }
        if (counter < 0) {
            return null;
        }
        return new TreePosition<TreeNodeInterface>(parent.getParent(), counter);
    }

    public int getIndexByRow(int dropRow) {
        int index = 0;
        for (int i = dropRow - 1; i >= 0; --i) {
            TreeNodeInterface rowObject = (TreeNodeInterface)this.getObjectbyRow(i);
            if (!rowObject.isLeaf()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void internalRemove(List<T> children, HashSet<T> hashSet) {
        Iterator<T> it = children.iterator();
        while (it.hasNext()) {
            TreeNodeInterface node = (TreeNodeInterface)it.next();
            if (hashSet.contains(node)) {
                it.remove();
                continue;
            }
            if (node.isLeaf()) continue;
            this.internalRemove(node.getChildren(), hashSet);
        }
    }

    @Override
    public List<T> refreshSort(List<T> data) {
        return super.refreshSort(data);
    }

    @Override
    public boolean move(List<T> transferData, int dropRow) {
        throw new WTFException("Not Implemented");
    }

    @Override
    public void removeAll(List<T> selectedObjects) {
        this.internalRemove(this.tree, new HashSet<T>(selectedObjects));
    }

    @Override
    public List<T> sort(List<T> data, ExtColumn<T> column) {
        return data;
    }

    @Override
    public void _fireTableStructureChanged(List<T> newtableData, boolean refreshSort) {
        super._fireTableStructureChanged(newtableData, refreshSort);
    }

    protected void unpack(ArrayList<T> list, T node) {
        list.add(node);
        if (!node.isLeaf()) {
            for (TreeNodeInterface t : node.getChildren()) {
                this.unpack(list, t);
            }
        }
    }

    public static <T extends TreeNodeInterface> List<T> getAllChildren(List<T> imports) {
        ArrayList ret = new ArrayList();
        ExtTreeTableModel.fillWithChildren(ret, imports);
        return ret;
    }

    private static <T extends TreeNodeInterface> void fillWithChildren(List<T> ret, List<T> imports) {
        for (TreeNodeInterface t : imports) {
            if (t.isLeaf()) {
                ret.add(t);
                continue;
            }
            ExtTreeTableModel.fillWithChildren(ret, t.getChildren());
        }
    }

    public static <T extends TreeNodeInterface> List<T> getAllParents(List<T> imports) {
        ArrayList ret = new ArrayList();
        ExtTreeTableModel.fillWithParents(ret, imports);
        return ret;
    }

    private static <T extends TreeNodeInterface> void fillWithParents(List<T> ret, List<T> imports) {
        for (TreeNodeInterface t : imports) {
            if (t.isLeaf()) continue;
            ret.add(t);
            ExtTreeTableModel.fillWithParents(ret, t.getChildren());
        }
    }
}

