/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.trayicon;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.appwork.loggingv3.LogV3;
import org.appwork.resources.AWUTheme;
import org.appwork.resources.IconRef;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.trayicon.MenuHeader;
import org.appwork.swing.trayicon.MenuHeaderWrapper;
import org.appwork.swing.trayicon.TrayIconExtender;
import org.appwork.swing.trayicon.TrayIconPopup;
import org.appwork.swing.trayicon.TrayIconRef;
import org.appwork.swing.trayicon.TrayMouseAdapter;
import org.appwork.swing.trayicon.TrayMouseListener;
import org.appwork.utils.DebugMode;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;

public abstract class AbstractTray
implements TrayMouseListener {
    private static final int POPUP_INSETS = 5;
    protected TrayIcon trayIcon;
    private TrayMouseAdapter ma;
    private TrayIconPopup jpopup;
    protected BasicAction[] actions;
    private DelayedRunnable doubleclickDelayer;
    private Runnable executeSingleClick;
    private static final ScheduledExecutorService EXECUTER = Executors.newSingleThreadScheduledExecutor();

    public AbstractTray(BasicAction ... basicActions) {
        this.actions = basicActions;
    }

    public void closePopup() {
        TrayIconPopup localJpopup = this.jpopup;
        if (localJpopup != null) {
            this.jpopup = null;
            localJpopup.setVisible(false);
            localJpopup.dispose();
        }
    }

    public void run() throws AWTException {
        this.runTray();
    }

    public void setToolTip(final String tt) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (AbstractTray.this.trayIcon != null) {
                    AbstractTray.this.trayIcon.setToolTip(tt);
                }
            }
        };
    }

    private void runTray() throws AWTException {
        SystemTray systemTray = SystemTray.getSystemTray();
        this.trayIcon = this.initTray();
        this.ma = new TrayMouseAdapter(this, this.trayIcon);
        this.trayIcon.addMouseListener(this.ma);
        this.trayIcon.addMouseMotionListener(this.ma);
        this.initTrayIconImpl(this.trayIcon);
        this.doubleclickDelayer = new DelayedRunnable(EXECUTER, this.getDoubleClickDelay()){

            @Override
            public void delayedrun() {
                if (AbstractTray.this.executeSingleClick != null) {
                    AbstractTray.this.executeSingleClick.run();
                }
            }
        };
        systemTray.add(this.trayIcon);
    }

    protected String getBaseIconKey() {
        return "icon";
    }

    protected TrayIcon initTray() {
        IconRef icon = this.getIconRef();
        Image img = this.createTrayImage(icon, null);
        TrayIcon trayIcon = new TrayIcon(img, null, null);
        trayIcon.setImageAutoSize(true);
        return trayIcon;
    }

    protected IconRef getIconRef() {
        IconRef icon = TrayIconRef.trayicon;
        if (!TrayIconRef.trayicon.exists()) {
            icon = new IconRef(){

                @Override
                public String path() {
                    return AbstractTray.this.getBaseIconKey();
                }

                @Override
                public Image image(int size) {
                    return AWUTheme.I().getImage(AbstractTray.this.getBaseIconKey(), size);
                }

                @Override
                public Icon icon(int size) {
                    return AWUTheme.I().getIcon(AbstractTray.this.getBaseIconKey(), size);
                }
            };
        }
        return icon;
    }

    protected abstract void initTrayIconImpl(TrayIcon var1);

    protected long getDoubleClickDelay() {
        return 300L;
    }

    protected Image createTrayImage(IconRef id, TrayIconExtender extend) {
        SystemTray systemTray = SystemTray.getSystemTray();
        Dimension traySize = systemTray.getTrayIconSize();
        if (CrossSystem.isWindows() && !JavaVersion.getVersion().isMinimum(JavaVersion.JVM_9_0)) {
            try {
                AffineTransform tx = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                Image img = IconIO.centerImage(id.image(Math.max((int)((double)traySize.width * tx.getScaleX()), (int)((double)traySize.height * tx.getScaleY()))), (int)((double)traySize.width * tx.getScaleX()), (int)((double)traySize.height * tx.getScaleY()), null);
                return extend == null ? img : extend.modify(img);
            }
            catch (Exception e) {
                LogV3.log(e);
                DebugMode.debugger();
            }
        }
        Image img = IconIO.centerImage(id.image(Math.max(traySize.width, traySize.height)), traySize.width, traySize.height, null);
        return extend == null ? img : extend.modify(img);
    }

    public void showAbout(MouseEvent mouseevent) {
    }

    @Override
    public void mouseClicked(final MouseEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            new Exception().printStackTrace();
        }
        if (CrossSystem.isContextMenuTrigger(e)) {
            this.onContextClick(e);
        } else if (e.getClickCount() == 1) {
            this.executeSingleClick = new Runnable(){

                @Override
                public void run() {
                    new EDTRunner(){

                        @Override
                        protected void runInEDT() {
                            AbstractTray.this.onSingleClick(e);
                        }
                    };
                }
            };
            this.doubleclickDelayer.resetAndStart();
        } else if (e.getClickCount() == 2) {
            this.doubleclickDelayer.stop();
            this.executeSingleClick = new Runnable(){

                @Override
                public void run() {
                    new EDTRunner(){

                        @Override
                        protected void runInEDT() {
                            AbstractTray.this.onDoubleClick(e);
                        }
                    };
                }
            };
            this.doubleclickDelayer.resetAndStart();
        }
    }

    protected void onContextClick(MouseEvent e) {
        this.showMenu(e);
    }

    protected void onDoubleClick(MouseEvent e) {
        this.showAbout(e);
    }

    protected void onSingleClick(MouseEvent e) {
        this.showMenu(e);
    }

    public static Point calculateLocation(Container popup, TrayMouseAdapter ma, MouseEvent e) {
        Dimension ps = popup.getPreferredSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        Point position = e.getPoint();
        for (GraphicsDevice screen : screens) {
            GraphicsConfiguration screenConfiguration = screen.getDefaultConfiguration();
            Point clickedPoint = e.getPoint();
            double scaleY = 1.0;
            double scaleX = 1.0;
            try {
                AffineTransform transformation = screenConfiguration.getDefaultTransform();
                Point2D p2d = transformation.inverseTransform(clickedPoint, null);
                clickedPoint = new Point((int)p2d.getX(), (int)p2d.getY());
                scaleY = transformation.getScaleY();
                scaleX = transformation.getScaleX();
            }
            catch (NoninvertibleTransformException e1) {
                LogV3.log(e1);
            }
            Rectangle bounds = screenConfiguration.getBounds();
            if (!bounds.contains(clickedPoint)) continue;
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(screenConfiguration);
            if (clickedPoint.getX() - bounds.getX() > bounds.getX() + bounds.getWidth() - clickedPoint.getX()) {
                position.x = (int)((double)(bounds.x + bounds.width - ps.width) - 5.0 / scaleX - (double)insets.right / scaleX);
                if (position.x > clickedPoint.x) {
                    position.x = clickedPoint.x;
                }
            } else {
                position.x = (int)((double)bounds.x + 5.0 / scaleX + (double)insets.left / scaleX);
                if (position.x < clickedPoint.x) {
                    position.x = clickedPoint.x;
                }
            }
            if (clickedPoint.getY() - bounds.getY() > bounds.getY() + bounds.getHeight() - clickedPoint.getY()) {
                position.y = (int)((double)(bounds.y + bounds.height - ps.height) - 5.0 / scaleY - (double)insets.bottom / scaleY);
                break;
            }
            position.y = (int)((double)bounds.y + 5.0 / scaleY + (double)insets.top / scaleY);
            if (position.y >= clickedPoint.y) break;
            position.y = clickedPoint.y;
            break;
        }
        return position;
    }

    public void showMenu(MouseEvent e) {
        TrayIconPopup localJpopup = this.jpopup;
        if (localJpopup != null && localJpopup.isShowing()) {
            localJpopup.setVisible(false);
            localJpopup.dispose();
            this.jpopup = null;
        } else {
            this.jpopup = this.createMenu(e);
            int countMenuItems = 0;
            AbstractButton theOneAndOnly = null;
            for (Component c : this.jpopup.getComponents()) {
                if (!(c instanceof JMenuItem)) continue;
                theOneAndOnly = ++countMenuItems == 1 ? (JMenuItem)c : null;
            }
            if (theOneAndOnly != null) {
                theOneAndOnly.doClick();
            } else {
                Point position = AbstractTray.calculateLocation(this.jpopup, this.ma, e);
                if (position != null) {
                    this.jpopup.show(position.x, position.y);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    protected TrayIconPopup createMenu(MouseEvent e) {
        TrayIconPopup jpopup = this.createPopup(e);
        MenuHeaderWrapper header = new MenuHeaderWrapper(this.createMenuHeader(e));
        jpopup.add(header);
        header.setOpaque(false);
        header.setBackground(null);
        this.createMenuNormal(e, jpopup);
        return jpopup;
    }

    protected void addMenuEntry(TrayIconPopup jpopup, MouseEvent e, BasicAction a) {
        JMenuItem m = this.createMenuItem(a);
        jpopup.add(m);
    }

    protected void createMenuNormal(MouseEvent e, TrayIconPopup jpopup) {
        for (BasicAction a : this.actions) {
            if (a == null) {
                jpopup.add(new JSeparator());
                continue;
            }
            if (this.isActionHidden(a)) continue;
            this.addMenuEntry(jpopup, e, a);
        }
    }

    public boolean isActionHidden(BasicAction a) {
        return Boolean.TRUE.equals(a.getValue("debug"));
    }

    protected JMenuItem createMenuItem(BasicAction a) {
        JMenuItem m = a.isToggle() ? new JCheckBoxMenuItem(a) : new JMenuItem(a);
        m.setPreferredSize(new Dimension(m.getPreferredSize().width, 24));
        return m;
    }

    protected TrayIconPopup createPopup(MouseEvent e) {
        return new TrayIconPopup();
    }

    public abstract MenuHeader createMenuHeader(MouseEvent var1);

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseStay(MouseEvent me) {
    }

    public void setName(String trayTitle) {
        this.trayIcon.setToolTip(trayTitle);
    }

    public void showMessage(String title, String msg) {
        this.trayIcon.displayMessage(title, msg, TrayIcon.MessageType.WARNING);
    }
}

