/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.trayicon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import org.appwork.swing.trayicon.TrayMouseListener;
import org.appwork.utils.Time;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;

public class TrayMouseAdapter
implements MouseListener,
MouseMotionListener {
    private final TrayMouseListener deligate;
    private boolean mouseover;
    protected volatile Thread mouseLocationObserver;
    private Point min;
    private Point max;
    private final Dimension size;
    private MouseEvent lastEvent;
    private final Component dummy;
    private Rectangle bounds;
    private TrayIcon trayIcon;
    private static int TOOLTIP_DELAY = 1000;

    public TrayMouseAdapter(TrayMouseListener lightTray, TrayIcon trayIcon) {
        this.deligate = lightTray;
        this.trayIcon = trayIcon;
        this.dummy = new Component(){
            private static final long serialVersionUID = 1L;
        };
        this.size = trayIcon.getSize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.deligate.mouseClicked(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseover = true;
        final long enterTime = Time.systemIndependentCurrentJVMTimeMillis();
        this.mouseLocationObserver = new Thread("Mouse Over Observer"){
            private boolean mouseStay;
            private boolean loop;

            @Override
            public void run() {
                try {
                    this.mouseStay = false;
                    this.loop = true;
                    while (this.loop) {
                        new EDTRunner(){

                            @Override
                            protected void runInEDT() {
                                PointerInfo pi = MouseInfo.getPointerInfo();
                                if (pi == null) {
                                    return;
                                }
                                if (TrayMouseAdapter.this.bounds == null) {
                                    return;
                                }
                                Point point = SwingUtils.convertToUnscaled(pi.getDevice(), pi.getLocation());
                                if (!TrayMouseAdapter.this.isOver(point)) {
                                    MouseEvent me = new MouseEvent(TrayMouseAdapter.this.dummy, 0, Time.systemIndependentCurrentJVMTimeMillis(), 0, point.x, point.y, 0, false);
                                    me.setSource(TrayMouseAdapter.this.lastEvent.getSource());
                                    TrayMouseAdapter.this.mouseExited(me);
                                    loop = false;
                                    return;
                                }
                                if (Time.systemIndependentCurrentJVMTimeMillis() - enterTime >= (long)TOOLTIP_DELAY && !mouseStay) {
                                    mouseStay = true;
                                    MouseEvent me = new MouseEvent(TrayMouseAdapter.this.dummy, 0, Time.systemIndependentCurrentJVMTimeMillis(), 0, point.x, point.y, 0, false);
                                    me.setSource(TrayMouseAdapter.this);
                                    TrayMouseAdapter.this.deligate.mouseStay(me);
                                }
                            }
                        }.waitForEDT();
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    TrayMouseAdapter.this.mouseLocationObserver = null;
                }
            }
        };
        this.mouseLocationObserver.start();
        this.deligate.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            new Exception().printStackTrace();
        }
        this.mouseover = false;
        System.out.println("Exit");
        this.max = null;
        this.min = null;
        this.bounds = null;
        this.deligate.mouseExited(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            new Exception().printStackTrace();
        }
        this.deligate.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            new Exception().printStackTrace();
        }
        this.deligate.mouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            new Exception().printStackTrace();
        }
        this.deligate.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            new Exception().printStackTrace();
        }
        if (e == null || e.getPoint() == null) {
            return;
        }
        this.lastEvent = e;
        if (this.min == null) {
            this.min = new Point(e.getPoint().x, e.getPoint().y);
            this.max = new Point(e.getPoint().x, e.getPoint().y);
        } else {
            this.min.x = Math.min(e.getPoint().x, this.min.x);
            this.min.y = Math.min(e.getPoint().y, this.min.y);
            this.max.x = Math.max(e.getPoint().x, this.max.x);
            this.max.y = Math.max(e.getPoint().y, this.max.y);
        }
        this.bounds = new Rectangle(this.min.x, this.min.y, this.max.x - this.min.x, this.max.y - this.min.y);
        if (this.bounds.width < this.size.width) {
            this.bounds.x -= (this.size.width - this.bounds.width) / 2;
            this.bounds.width = this.size.width;
        }
        if (this.bounds.height < this.size.height) {
            this.bounds.y -= (this.size.height - this.bounds.height) / 2;
            this.bounds.height = this.size.height;
        }
        if (!this.mouseover) {
            this.mouseEntered(e);
        } else {
            this.deligate.mouseMoved(e);
        }
    }

    protected boolean isOver(Point point) {
        Rectangle bounds = this.bounds;
        if (bounds == null) {
            return false;
        }
        return bounds.contains(point);
    }

    public Rectangle getUnscaledBounds() {
        return this.bounds;
    }
}

