/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.testframework.tests;

import java.io.File;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.appwork.app.launcher.parameterparser.CommandSwitch;
import org.appwork.app.launcher.parameterparser.ParameterParser;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.PostBuildTestInterface;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;

public class SourceParserPostBuildTest
implements PostBuildTestInterface {
    @Override
    public void runPostBuildTest(String[] args, File applicationRoot) throws Exception {
        ParameterParser pp = new ParameterParser(args).parse();
        CommandSwitch sourceP = pp.getCommandSwitch("source");
        if (sourceP != null) {
            String folders = sourceP.getParameters()[0];
            for (String folder : StringUtils.splitNoEmpty(folders, ";")) {
                AWTest.logInfoAnyway(folder);
                if (!new File(folder).isDirectory()) {
                    throw new Exception(new File(folder).getCanonicalPath() + " does not exist");
                }
                final AtomicInteger count = new AtomicInteger(0);
                Files.walkThroughStructure(new Files.Handler<Exception>(){

                    @Override
                    public void intro(File f) throws Exception {
                    }

                    @Override
                    public void onFile(File f) throws Exception {
                        if (f.isFile() && f.getName().endsWith(".java")) {
                            SourceParserPostBuildTest.this.scanJavaFile(f);
                            count.incrementAndGet();
                        }
                    }

                    @Override
                    public void outro(File f) throws Exception {
                    }
                }, new File(folder));
                if (count.get() != 0) continue;
                throw new Exception("No Source Files in " + folder);
            }
        }
    }

    protected void scanJavaFile(File f) throws Exception {
        String code = IO.readFileToString(f);
        String packageName = new Regex(code, "package ([^;]+);").getMatch(0);
        String className = new Regex(code, "class (\\w+)\\s+").getMatch(0);
        if (SourceParserPostBuildTest.class.getSimpleName().equals(className)) {
            return;
        }
        int index = (code = code.replaceAll("\\/\\/[^\r\n]*DebugMode\\.TRIGGER_BUILD_ERROR", "IGNORE IN TEST-comment")).indexOf("DebugMode.TRIGGER_BUILD_ERROR");
        if (index >= 0) {
            CrossSystem.openFile(f);
            throw new Exception("DebugMode.TRIGGER_BUILD_ERROR in " + packageName + ". (" + className + ".java:" + code.substring(0, index).split("[\r\n]{1,2}").length + ")");
        }
        index = code.toLowerCase(Locale.ROOT).indexOf("todo");
        if (index >= 0) {
            AWTest.logInfoAnyway("TODO in " + packageName + ". (" + className + ".java:" + code.substring(0, index).split("[\r\n]{1,2}").length + ")");
        }
    }

    public static void main(String[] args) throws Exception {
        new SourceParserPostBuildTest().runPostBuildTest(args, null);
    }
}

