/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.util.Arrays;

public class TranslatedStringBuilder {
    protected char[] value = null;
    protected int count = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    protected TranslatedStringBuilder(int capacity) {
        this.value = new char[capacity];
    }

    private TranslatedStringBuilder appendNull() {
        int c = this.count;
        this.ensureCapacityInternal(c + 4);
        char[] value = this.value;
        value[c++] = 110;
        value[c++] = 117;
        value[c++] = 108;
        value[c++] = 108;
        this.count = c;
        return this;
    }

    public TranslatedStringBuilder append(Object obj) {
        if (obj == null) {
            return this.appendNull();
        }
        return this.append(obj.toString());
    }

    public TranslatedStringBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        return this.append(str, 0, str.length());
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void clear() {
        this.count = 0;
    }

    public TranslatedStringBuilder append(char[] str) {
        if (str == null) {
            return this.appendNull();
        }
        int len = str.length;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    public TranslatedStringBuilder append(String str, int from, int to) {
        if (str == null) {
            return this.appendNull();
        }
        int len = to - from;
        this.ensureCapacityInternal(this.count + len);
        str.getChars(from, to, this.value, this.count);
        this.count += len;
        return this;
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            this.value = Arrays.copyOf(this.value, this.newCapacity(minimumCapacity));
        }
    }

    private int newCapacity(int minCapacity) {
        int newCapacity = (this.value.length << 1) + 2;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        return newCapacity <= 0 || 0x7FFFFFF7 - newCapacity < 0 ? this.hugeCapacity(minCapacity) : newCapacity;
    }

    private int hugeCapacity(int minCapacity) {
        if (Integer.MAX_VALUE - minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? minCapacity : 0x7FFFFFF7;
    }
}

