/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.txtresource.Defaults;
import org.appwork.txtresource.TranslateData;
import org.appwork.txtresource.TranslateInterface;
import org.appwork.txtresource.TranslatedEntry;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.utils.Application;
import org.appwork.utils.IO;

public class TranslationUtils {
    public static void createFiles(boolean addComments, Class<? extends TranslateInterface> ... classes) throws URISyntaxException, IOException {
        for (Class<? extends TranslateInterface> class1 : classes) {
            String rel = class1.getName().replace(".", "/") + ".class";
            String file = new File(Application.getRessourceURL(rel).toURI()).getParentFile().getAbsolutePath().replace("\\bin\\", "\\src\\");
            for (String lng : class1.getAnnotation(Defaults.class).lngs()) {
                File f = new File(file + "/" + class1.getSimpleName() + "." + lng + ".lng");
                String txt = TranslationFactory.create(class1)._getHandler().createFile(lng, null, addComments);
                f.delete();
                IO.writeStringToFile(f, txt);
                System.out.println("Wrote " + f);
            }
        }
    }

    public static void createFiles(boolean addComments, File dist, String[] lngs, TranslationProviderInterface prov, Class<? extends TranslateInterface> ... classes) throws URISyntaxException, IOException {
        for (Class<? extends TranslateInterface> class1 : classes) {
            String rel = class1.getName().replace(".", "/") + ".class";
            String file = dist != null ? new File(dist, rel).getParentFile().getAbsolutePath() : new File(Application.getRessourceURL(rel).toURI()).getParentFile().getAbsolutePath().replace("\\bin\\", "\\src\\");
            for (String lng : lngs) {
                File f = new File(file + "/" + class1.getSimpleName() + "." + lng + ".lng");
                String txt = TranslationFactory.create(class1, "en")._getHandler().createFile(lng, prov, addComments);
                f.delete();
                IO.writeStringToFile(f, txt);
                System.out.println("Wrote " + f);
                System.out.println(txt);
            }
        }
    }

    public static TranslateData restoreFromString(String txt, Class<TranslateData> class1) {
        if (txt.startsWith("{")) {
            return TranslateData.convertFromMap(JSonStorage.restoreFromString(txt, TypeRef.HASHMAP_STRING));
        }
        TranslateData ret = new TranslateData();
        int index = 0;
        int found = 0;
        int found2 = 0;
        int found3 = 0;
        while ((found = txt.indexOf("=", index)) >= 0) {
            String key = txt.substring(index, found).trim();
            found2 = txt.indexOf("\r", found + 1);
            found3 = txt.indexOf("\n", found + 1);
            String value = found2 < 0 && found3 < 0 ? txt.substring(found + 1) : (found2 < found3 && found2 >= 0 || found3 < 0 ? txt.substring(found + 1, found2) : txt.substring(found + 1, found3));
            ret.put(key, new TranslatedEntry(TranslationUtils.clean(value)));
            index = Math.max(found2, found3) + 1;
            if (index > 0) continue;
            break;
        }
        return ret;
    }

    private static String clean(String value) {
        StringBuilder sb = new StringBuilder();
        value = value.trim();
        block8: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i == value.length()) {
                        sb.append(c);
                        continue block8;
                    }
                    char c2 = value.charAt(i);
                    switch (c2) {
                        case 'n': {
                            sb.append('\n');
                            continue block8;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block8;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block8;
                        }
                    }
                    sb.append(c);
                    sb.append(c2);
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String serialize(TranslateData map) {
        StringBuilder ret = new StringBuilder();
        ArrayList keys = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys);
        for (String key : keys) {
            ret.append(key);
            ret.append("=");
            ret.append(((TranslatedEntry)map.get(key)).getRaw().replace("\r", "\\r").replace("\n", "\\n"));
            ret.append("\r\n");
        }
        return ret.toString();
    }

    public static interface TranslationProviderInterface {
        public Translated get(Method var1, String var2, String var3, String var4);
    }

    public static class Translated {
        public final String value;
        public final String comment;

        public Translated(String value, String comment) {
            this.value = value;
            this.comment = comment.trim();
        }
    }
}

