/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.appwork.loggingv3.LogV3;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.PathBuilder;
import org.appwork.updatesys.client.ReplacementModifier;
import org.appwork.updatesys.client.StaticReplacerValue;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.DesktopSupportWindows;

public class DefaultPathBuilder
implements PathBuilder {
    protected static final String PROGRAM_DATA = ".%ProgramData";
    protected volatile File root;
    protected final List<PathBuilder.ReplacerInterface> replacerListSortedOnKeyLength = new ArrayList<PathBuilder.ReplacerInterface>();
    protected final LogInterface logger;

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(File root) {
        if (root == null) {
            throw new IllegalArgumentException("root==null?");
        }
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathBuilder.ReplacerInterface getReplacerByKey(String key) {
        String get = this.cleanReplacerKey(key);
        List<PathBuilder.ReplacerInterface> list = this.replacerListSortedOnKeyLength;
        synchronized (list) {
            for (PathBuilder.ReplacerInterface es : this.replacerListSortedOnKeyLength) {
                if (!es.getKey().equals(get)) continue;
                return es;
            }
        }
        return null;
    }

    private String cleanReplacerKey(String key) {
        return key.replace("\\", "/");
    }

    protected void initDefaultReplacer() {
        if (CrossSystem.isWindows()) {
            this.addReplacer(new StaticReplacerValue(PROGRAM_DATA, this.getProgramData(), true));
            String programFiles32Bit = this.getProgramFiles();
            this.addReplacer(new StaticReplacerValue(".%ProgramFiles", programFiles32Bit, true));
            this.addReplacer(new StaticReplacerValue(".%Program Files", programFiles32Bit, true));
        }
    }

    public DefaultPathBuilder(UpdateClient client) {
        this.root = new File(Application.getHome());
        this.logger = client == null ? LogV3.defaultLogger() : client.getLogger();
        this.initDefaultReplacer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearReplacer() {
        List<PathBuilder.ReplacerInterface> list = this.replacerListSortedOnKeyLength;
        synchronized (list) {
            this.replacerListSortedOnKeyLength.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReplacer(PathBuilder.ReplacerInterface replacer) {
        if (replacer == null) {
            this.logger.info("addReplacer replacer==null?!");
        } else if (replacer.getKey() == null) {
            this.logger.info("addReplacer(" + replacer + ") with replacer.key==null?!");
            return;
        }
        String addKey = this.cleanReplacerKey(replacer.getKey());
        ArrayList<PathBuilder.ReplacerInterface> toRemove = new ArrayList<PathBuilder.ReplacerInterface>();
        List<PathBuilder.ReplacerInterface> list = this.replacerListSortedOnKeyLength;
        synchronized (list) {
            for (PathBuilder.ReplacerInterface es : this.replacerListSortedOnKeyLength) {
                if (!es.getKey().equals(addKey)) continue;
                toRemove.add(es);
            }
            this.replacerListSortedOnKeyLength.removeAll(toRemove);
            this.replacerListSortedOnKeyLength.add(replacer);
            if (this.replacerListSortedOnKeyLength.size() > 1) {
                Collections.sort(this.replacerListSortedOnKeyLength, new Comparator<PathBuilder.ReplacerInterface>(){

                    @Override
                    public int compare(int x, int y) {
                        return x < y ? -1 : (x == y ? 0 : 1);
                    }

                    @Override
                    public int compare(PathBuilder.ReplacerInterface o1, PathBuilder.ReplacerInterface o2) {
                        return this.compare(o2.getKey().length(), o1.getKey().length());
                    }
                });
            }
        }
    }

    public void addReplacer(String key, String value) {
        this.addReplacer(new StaticReplacerValue(key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathBuilder.ReplacerInterface> getReplacerList() {
        List<PathBuilder.ReplacerInterface> list = this.replacerListSortedOnKeyLength;
        synchronized (list) {
            return new ArrayList<PathBuilder.ReplacerInterface>(this.replacerListSortedOnKeyLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbsoluteFile fromRelPath(UpdateClient updateClient, String relPath) throws IOException {
        relPath = relPath.replaceAll("\\\\", "/");
        List<PathBuilder.ReplacerInterface> list = this.replacerListSortedOnKeyLength;
        synchronized (list) {
            for (PathBuilder.ReplacerInterface es : this.replacerListSortedOnKeyLength) {
                if (!relPath.startsWith(es.getKey())) continue;
                String value = es.getValue(updateClient);
                return new AbsoluteFile(es.getKey(), value, relPath);
            }
        }
        if (relPath.startsWith(".%")) {
            throw new IOException("Unresolveable Relative Path: " + relPath);
        }
        return new AbsoluteFile(null, updateClient.getWorkingDirectory().getAbsolutePath(), relPath);
    }

    protected String getProgramData() {
        return DefaultPathBuilder.getProgramData(this.logger);
    }

    protected String getProgramFiles() {
        return DesktopSupportWindows.get32BitProgramFiles(this.logger);
    }

    public static String getProgramData(LogInterface logger) {
        String appdata;
        String ret;
        block15: {
            ret = null;
            String[] pathes = new String[]{"PROGRAMDATA", "ALLUSERSPROFILE"};
            try {
                for (String name : pathes) {
                    for (Map.Entry<String, String> es : System.getenv().entrySet()) {
                        File testProgramFiles;
                        if (!StringUtils.equalsIgnoreCase(es.getKey(), name) || !StringUtils.isNotEmpty(es.getValue()) || !(testProgramFiles = new File(es.getValue())).exists()) continue;
                        ret = es.getValue();
                        break block15;
                    }
                }
            }
            catch (Throwable e) {
                if (logger == null) break block15;
                logger.log(e);
            }
        }
        if (StringUtils.isEmpty(ret) && (appdata = System.getenv("APPDATA")) != null && StringUtils.isNotEmpty(appdata = appdata.substring(0, appdata.indexOf("\\") + 1))) {
            ret = appdata + "Users\\All Users";
            if (new File(ret).exists()) {
                try {
                    ret = new File(ret).getCanonicalPath();
                }
                catch (Throwable e) {
                    if (logger != null) {
                        logger.log(e);
                    }
                }
            } else {
                ret = null;
            }
        }
        if (StringUtils.isEmpty(ret)) {
            appdata = System.getenv("APPDATA");
            String username = System.getenv("USERNAME");
            if (appdata != null && username != null && StringUtils.containsIgnoreCase(appdata, username) && !new File(ret = appdata.replace("\\" + username + "\\", "\\All Users\\")).exists()) {
                ret = null;
            }
        }
        if (StringUtils.isEmpty(ret) && !new File(ret = "c:\\ProgramData").exists()) {
            ret = null;
        }
        if (ret != null) {
            while (ret.endsWith("/") || ret.endsWith("\\")) {
                ret = ret.substring(0, ret.length() - 1);
            }
        }
        return ret;
    }

    @Override
    public File getBackupFile(UpdateClient updateClient) {
        return this.getResource(this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/revertlistV2.txt");
    }

    protected String getStorageBase() {
        return "cfg/repos/";
    }

    @Override
    public File getFailedCleanupsFile(UpdateClient updateClient) {
        return this.getResource(this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/failedCleanupsV2.txt");
    }

    @Override
    public File getFilelist(UpdateClient updateClient) {
        return this.getResource(this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/filelist.txt");
    }

    @Override
    public String getOptionalConfigPath(UpdateClient updateClient) {
        return this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/extensions";
    }

    @Override
    public File getRepoStorageResource(UpdateClient updateClient, String path) {
        if (StringUtils.isEmpty(path)) {
            return this.getResource(this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/");
        }
        return this.getResource(this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/" + path);
    }

    @Override
    public File getRevisionFile(UpdateClient updateClient) {
        return this.getResource(this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/rev");
    }

    @Override
    public File getServerOptionsFilePath(UpdateClient updateClient) {
        return this.getResource(this.getStorageBase() + this.getRepoNameSpace(updateClient) + "/serverOptions.json");
    }

    protected String getRepoNameSpace(UpdateClient updateClient) {
        return updateClient.getSetup().getNamespace();
    }

    @Override
    public File getTmpFolder(UpdateClient updateClient) {
        return this.getResource("tmp/update/");
    }

    @Override
    public File getUIDFile(UpdateClient updateClient) {
        return this.getResource("cfg/uid");
    }

    protected File getResource(String path) {
        return new File(this.getRoot(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtectedFolder(UpdateClient client, File file) {
        if (!file.isDirectory()) {
            return false;
        }
        List<PathBuilder.ReplacerInterface> list = this.replacerListSortedOnKeyLength;
        synchronized (list) {
            for (PathBuilder.ReplacerInterface replacer : this.replacerListSortedOnKeyLength) {
                AbsoluteFile value;
                if (!replacer.isProtectedFolder() || !(value = replacer.getValueAsFile(client)).equals(file)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String replaceDynLinks(UpdateClient client, String input, ReplacementModifier mod) {
        String output = input;
        List<PathBuilder.ReplacerInterface> list = this.replacerListSortedOnKeyLength;
        synchronized (list) {
            for (PathBuilder.ReplacerInterface es : this.replacerListSortedOnKeyLength) {
                int index = output.indexOf(es.getKey());
                if (index < 0) continue;
                String value = es.getValue(client);
                if (mod != null) {
                    output = mod.replace(output, es.getKey(), value);
                    continue;
                }
                output = output.replace(es.getKey(), value);
            }
        }
        return output;
    }
}

