/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.iid;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.appwork.exceptions.WTFException;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.iid.AbstractChangeableIDProvider;
import org.appwork.updatesys.client.iid.UIDProviderInterface;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;

public abstract class AbstractUIDProvider
implements UIDProviderInterface {
    protected final UpdateClient client;
    protected File idFile;
    protected final LogInterface logger;
    protected String id;

    public AbstractUIDProvider(UpdateClient updateClient) throws ExtIOException {
        this.client = updateClient;
        this.logger = this.client.getLogger();
        this.init();
    }

    protected void init() throws ExtIOException {
        this.idFile = new File(this.getClient().getPathBuilder().getUIDFile(this.getClient()).getParentFile(), this.getFileName());
        this.setAccecptedID(this.loadIDsFromDisk());
    }

    protected UpdateClient getClient() {
        return this.client;
    }

    protected LogInterface getLogger() {
        return this.logger;
    }

    protected File getIdFile() {
        return this.idFile;
    }

    protected String getFileName() {
        return "uid";
    }

    protected String loadIDsFromDisk() {
        FileAccessHandler fileSystem = this.getClient().getFileSystem();
        File file = this.getIdFile();
        if (file != null && file.isFile()) {
            this.getLogger().info(this + " UID File: " + file);
            try {
                String json = fileSystem.secureReadFileToString(file);
                if (json != null) {
                    json = json.trim();
                }
                if (!StringUtils.isEmpty(json)) {
                    return json;
                }
                this.getLogger().info("FUID: empty!");
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    protected String encode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
    }

    @Override
    public String getAcceptedID() throws InterruptedException, ExtIOException {
        return this.id;
    }

    public void setAccecptedID(String id) {
        this.id = id;
    }

    @Override
    public boolean hasValidID() throws InterruptedException, ExtIOException {
        return this.isValidID(this.getAcceptedID());
    }

    protected abstract boolean isValidID(String var1);

    protected boolean writeString(File file, String uid) throws ExtIOException {
        return AbstractChangeableIDProvider.writeStringSecureAndValidateContents(this.getClient(), file, uid);
    }

    @Override
    public void onServerSentAcceptedID(String uid) throws InterruptedException, ExtIOException {
        this.getLogger().info(this.client + " Server assigned a new UID: " + uid);
        this.writeString(this.getIdFile(), uid);
        this.setAccecptedID(uid);
    }

    @Override
    public void appendToUrl(StringBuilder url) throws InterruptedException, ExtIOException {
        try {
            url.append("&" + this.getParameterKeyName() + "=" + this.encode(this.getAcceptedID()));
        }
        catch (Throwable e) {
            this.getClient().trackException(e);
        }
    }

    protected abstract String getParameterKeyName();
}

