/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.crypto.AWSign;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.formatter.HexFormatter;

public class UpdateSignature {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final File file;
    private final int revision;
    private final String path;
    private boolean compatibilityModeV1 = false;
    private byte[] fileSHA256 = null;

    public UpdateSignature(File f, int revision, String rel) {
        this(f, revision, rel, null);
    }

    public UpdateSignature(File f, int revision, String rel, byte[] fileSHA256) {
        this.file = f;
        this.revision = revision;
        if (rel.endsWith("/")) {
            rel = rel.substring(0, rel.length() - 1);
        }
        this.path = rel;
        this.fileSHA256 = fileSHA256;
    }

    public byte[] create(PrivateKey privateKey) throws UnsupportedEncodingException, SignatureViolationException, IOException, NoSuchAlgorithmException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        if (this.isFile()) {
            sb.append("F\r\n");
        } else {
            sb.append("D\r\n");
        }
        sb.append(this.revision);
        sb.append("\r\n");
        if (this.isFile()) {
            if (this.isCompatibilityModeV1()) {
                String toSign = "F\r\n" + this.revision + "\r\n" + this.path;
                byte[] oldSignature = AWSign.createSign(this.file, privateKey, true, toSign.getBytes(UTF8));
                sb.append(Base64.encodeToString(oldSignature, false));
            } else {
                String toSign = "F\r\n" + this.revision + "\r\n" + this.path + "\r\n" + HexFormatter.byteArrayToHex(this.getSHA256());
                byte[] v2Signature = AWSign.createSign(toSign.getBytes(UTF8), privateKey, true);
                sb.append(Base64.encodeToString(v2Signature, false));
                sb.append("\r\n");
                sb.append("V2");
            }
        } else {
            String toSign = "D\r\n" + this.revision + "\r\n" + this.path;
            byte[] pathSignature = AWSign.createSign(toSign.getBytes(UTF8), privateKey, true);
            sb.append(Base64.encodeToString(pathSignature, false));
        }
        return sb.toString().getBytes(UTF8);
    }

    public InputStream getInputstream() throws IOException {
        return new FileInputStream(this.file);
    }

    public byte[] getSHA256() throws IOException, InterruptedException {
        if (this.fileSHA256 != null) {
            return this.fileSHA256;
        }
        if (!this.isFile()) {
            throw new WTFException("SHA256 of directory!?");
        }
        InputStream is = this.getInputstream();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            DigestInputStream dis = new DigestInputStream(is, md);
            byte[] buffer = new byte[Short.MAX_VALUE];
            while (dis.read(buffer) != -1) {
                if (!Thread.interrupted()) continue;
                dis.close();
                throw new InterruptedException();
            }
            byte[] byArray = this.fileSHA256 = dis.getMessageDigest().digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public boolean isCompatibilityModeV1() {
        return this.compatibilityModeV1;
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public String readSignatureString() throws IOException {
        return IO.readFileToTrimmedString(new File(this.file.getAbsolutePath() + ".updateSignature"));
    }

    public void setCompatibilityModeV1(boolean compatibilityModeV1) {
        this.compatibilityModeV1 = compatibilityModeV1;
    }

    public void verify(PublicKey key) throws SignatureViolationException, InterruptedException {
        InputStream is = null;
        String sha256 = null;
        try {
            Object[] lines = Regex.getLines(this.readSignatureString());
            boolean isFile = lines[0].equals("F");
            int signatureRevision = Integer.parseInt(lines[1]);
            byte[] signature = Base64.decode(lines[2]);
            if (this.isFile() != isFile) {
                throw new SignatureViolationException(Arrays.toString(lines) + " does not match " + (this.file == null ? this.path : this.file) + "(File/Folder mismatch)");
            }
            if (signatureRevision != -1 && signatureRevision != this.revision) {
                throw new SignatureViolationException(Arrays.toString(lines) + " does not match " + (this.file == null ? this.path : this.file) + " (Revision Mismatch " + this.revision + "!=" + signatureRevision + ")");
            }
            if (signature == null || signature.length == 0) {
                throw new SignatureViolationException("empty signature");
            }
            if (this.isFile()) {
                if (lines.length >= 4 && "V2".equals(lines[3])) {
                    sha256 = HexFormatter.byteArrayToHex(this.getSHA256());
                    String toSign = "F\r\n" + this.revision + "\r\n" + this.path + "\r\n" + sha256;
                    AWSign.verify(toSign.getBytes(UTF8), key, signature, true);
                } else {
                    String toSign = "F\r\n" + signatureRevision + "\r\n" + this.path;
                    is = this.getInputstream();
                    AWSign.verify(is, key, signature, true, toSign.getBytes(UTF8));
                }
            } else {
                String toSign = "D\r\n" + signatureRevision + "\r\n" + this.path;
                AWSign.verify(toSign.getBytes(UTF8), key, signature, true);
            }
        }
        catch (SignatureViolationException e) {
            if (e.getCause() == null) {
                throw new SignatureViolationException("Path:" + this.path + "|SHA-256:" + sha256 + "|" + e.getMessage());
            }
            throw new SignatureViolationException("Path:" + this.path + "|SHA-256:" + sha256, e.getCause());
        }
        catch (IOException e) {
            throw new SignatureViolationException("Path:" + this.path + "|SHA-256:" + sha256, e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

