/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.appwork.utils.DebugMode;
import org.appwork.utils.JDK8BufferHelper;
import org.appwork.utils.JavaVersionInterface;
import org.appwork.utils.Regex;

public enum JavaVersion implements JavaVersionInterface
{
    UNKNOWN(-1, "Unknown"),
    JVM_1_0(45, "1.0"),
    JVM_1_1(45, "1.1"),
    JVM_1_2(46, "1.2"),
    JVM_1_3(47, "1.3"),
    JVM_1_4(48, "1.4"),
    JVM_1_5(49, "1.5"),
    JVM_1_6(50, "1.6"),
    JVM_1_7(51, "1.7"),
    JVM_1_8(52, "1.8", true),
    JVM_9_0(53, "9"),
    JVM_10_0(54, "10"),
    JVM_11_0(55, "11", true),
    JVM_12_0(56, "12"),
    JVM_13_0(57, "13"),
    JVM_14_0(58, "14"),
    JVM_15_0(59, "15"),
    JVM_16_0(60, "16"),
    JVM_17_0(61, "17", true),
    JVM_18_0(62, "18"),
    JVM_19_0(63, "19"),
    JVM_20_0(64, "20"),
    JVM_21_0(65, "21", true),
    JVM_22_0(66, "22"),
    JVM_23_0(67, "23"),
    JVM_24_0(68, "24"),
    JVM_25_0(69, "25", true),
    JVM_26_0(70, "26"){
        private final long next = 1.parseJavaVersionString("27");

        @Override
        public long nextVersionsLongID() {
            return this.next;
        }
    };

    public final long longID;
    public final int classID;
    public final String string;
    public final boolean lts;
    private static final JavaVersionInterface VERSION;

    public boolean is(String versionString) {
        return this.is(JavaVersion.parseJavaVersionString(versionString));
    }

    public boolean is(long id) {
        long next;
        return id >= this.longID && id < (next = this.nextVersionsLongID());
    }

    @Override
    public boolean is(JavaVersionInterface version) {
        return this.getBase() == version.getBase() || this.is(version.getLongID());
    }

    public long nextVersionsLongID() {
        int index = this.ordinal() + 1;
        if (index < JavaVersion.values().length) {
            return JavaVersion.values()[index].longID;
        }
        return -1L;
    }

    private JavaVersion(int classMajorVersion, String stringID) {
        this(classMajorVersion, stringID, false);
    }

    private JavaVersion(int classMajorVersion, String stringID, boolean lts) {
        this.longID = JavaVersion.parseJavaVersionString(stringID);
        this.classID = classMajorVersion;
        this.string = stringID;
        this.lts = lts;
    }

    public static long parseJavaVersionString(String version) {
        String b;
        String u;
        if (version != null) {
            version = version.replaceFirst("\\s*-\\s*LTS$", "");
        }
        String majorFeature = new Regex(version, "^(\\d+)").getMatch(0);
        String minorInterim = new Regex(version, "^\\d+\\.(\\d+)").getMatch(0);
        String securityUpdate = new Regex(version, "^\\d+\\.\\d+\\.(\\d+)").getMatch(0);
        long ret = 0L;
        if ("1".equals(majorFeature) && minorInterim != null) {
            ret = Long.parseLong(minorInterim) * 1000L * 1000L + 10000000L;
            u = new Regex(version, "^.*?_(\\d+)").getMatch(0);
            b = new Regex(version, "^.*?(_|-)b(\\d+)$").getMatch(1);
        } else if (majorFeature != null) {
            long major = Long.parseLong(majorFeature);
            u = new Regex(version, "u(\\d+)").getMatch(0);
            b = new Regex(version, "\\+(\\d+)$").getMatch(0);
            if (major < 9L) {
                ret = major * 1000L * 1000L + 10000000L;
            } else {
                ret = major * 1000L * 1000L * 1000L * 1000L;
                if (minorInterim != null) {
                    ret += Math.min(999L, Long.parseLong(minorInterim)) * 1000L * 1000L * 1000L;
                }
                if (securityUpdate != null) {
                    ret += Math.min(999L, Long.parseLong(securityUpdate)) * 1000L * 1000L;
                }
            }
        } else {
            return -1L;
        }
        if (u != null) {
            ret += Math.min(999L, Long.parseLong(u)) * 1000L;
        }
        if (b != null) {
            ret += Math.min(999L, Long.parseLong(b));
        }
        return ret;
    }

    @Override
    public boolean isHigherThan(JavaVersionInterface v) {
        if (this.getBase() == UNKNOWN) {
            return false;
        }
        return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() > v.getLongID();
    }

    private static int getClassID(JavaVersion base) {
        String version = System.getProperty("java.class.version");
        if (version != null) {
            try {
                int ret = (int)Double.parseDouble(version);
                if (base.getClassID() != -1 && ret != base.getClassID()) {
                    DebugMode.debugger();
                }
                return ret;
            }
            catch (NumberFormatException ignore) {
                DebugMode.debugger(ignore);
            }
        }
        return base.getClassID();
    }

    public static JavaVersion readClassJVMVersion(InputStream is) throws IOException {
        try {
            DataInputStream dis = new DataInputStream(is);
            byte[] magic = new byte[4];
            dis.readFully(magic);
            if (Arrays.equals(magic, new byte[]{-54, -2, -70, -66})) {
                byte[] minor = new byte[2];
                dis.readFully(minor);
                byte[] major = new byte[2];
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                byteBuffer.put(major);
                dis.readFully(major);
                byteBuffer.put(major);
                JDK8BufferHelper.flip(byteBuffer);
                int majorVersion = byteBuffer.getInt();
                for (JavaVersion e : JavaVersion.values()) {
                    if (e.classID != majorVersion) continue;
                    return e;
                }
            }
            return UNKNOWN;
        }
        catch (EOFException e) {
            return UNKNOWN;
        }
        catch (IOException e) {
            return UNKNOWN;
        }
    }

    public static JavaVersionInterface toJavaVersion(final String versionString) {
        final long longID = JavaVersion.parseJavaVersionString(versionString);
        final boolean isLTS = versionString != null && versionString.contains("LTS");
        JavaVersion base = UNKNOWN;
        for (JavaVersion v : JavaVersion.values()) {
            if (!v.is(longID)) continue;
            base = v;
            break;
        }
        final JavaVersion finalBase = base;
        return new JavaVersionInterface(){
            private final int classID;
            {
                this.classID = VERSION == null ? JavaVersion.getClassID(finalBase) : finalBase.getClassID();
            }

            @Override
            public boolean is(JavaVersionInterface version) {
                return this.getBase().is(version);
            }

            @Override
            public boolean isHigherThan(JavaVersionInterface v) {
                return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() > v.getLongID();
            }

            @Override
            public boolean isMinimum(JavaVersionInterface v) {
                return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() >= v.getLongID();
            }

            @Override
            public boolean isMaximum(JavaVersionInterface v) {
                return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() <= v.getLongID();
            }

            @Override
            public boolean isLowerThan(JavaVersionInterface v) {
                return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() < v.getLongID();
            }

            @Override
            public long getLongID() {
                return longID;
            }

            @Override
            public JavaVersion getBase() {
                return finalBase;
            }

            @Override
            public int getClassID() {
                return this.classID;
            }

            @Override
            public boolean isLTS() {
                return isLTS || this.getBase().isLTS();
            }

            @Override
            public String getVersionString() {
                return versionString;
            }

            public String toString() {
                return "Base:" + this.getBase().name() + (this.isLTS() ? "(LTS)" : "") + "|Version:" + this.getLongID() + "(" + this.getVersionString() + ")|ClassID:" + this.getClassID();
            }
        };
    }

    public static String getJVMVersion() {
        String version = System.getProperty("java.runtime.version");
        if (version == null || version.trim().length() == 0) {
            return System.getProperty("java.version");
        }
        return version;
    }

    public static JavaVersionInterface getVersion() {
        return VERSION;
    }

    @Override
    public boolean isMinimum(JavaVersionInterface v) {
        if (this.getBase() == UNKNOWN) {
            return false;
        }
        return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() >= v.getLongID();
    }

    @Override
    public boolean isMaximum(JavaVersionInterface v) {
        if (this.getBase() == UNKNOWN) {
            return false;
        }
        return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() <= v.getLongID();
    }

    @Override
    public boolean isLowerThan(JavaVersionInterface v) {
        if (this.getBase() == UNKNOWN) {
            return false;
        }
        return v != null && v != UNKNOWN && this.getLongID() != -1L && v.getLongID() != -1L && this.getLongID() < v.getLongID();
    }

    @Override
    public long getLongID() {
        return this.longID;
    }

    @Override
    public JavaVersion getBase() {
        return this;
    }

    @Override
    public int getClassID() {
        return this.classID;
    }

    @Override
    public boolean isLTS() {
        return this.lts;
    }

    @Override
    public String getVersionString() {
        return this.string;
    }

    public String toString() {
        return "Base:" + this.name() + (this.isLTS() ? "(LTS)" : "") + "|Version:" + this.getLongID() + "(" + this.getVersionString() + ")|ClassID:" + this.getClassID();
    }

    static {
        JavaVersionInterface version = UNKNOWN;
        try {
            String versionString = JavaVersion.getJVMVersion();
            version = JavaVersion.toJavaVersion(versionString);
        }
        catch (Exception e) {
            DebugMode.debugger(e);
        }
        VERSION = version;
    }
}

