/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.Collection;
import org.appwork.utils.StringUtils;

public class Joiner {
    private String separator;
    private boolean ignoreNull = false;
    private boolean ignoreEmpty = false;
    private boolean prefix = false;
    private boolean postfix = false;
    private boolean skipEmptyOrNullElements = false;

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public Joiner(String separator) {
        this.separator = separator;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public Joiner ignoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
        return this;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public Joiner ignoreNull(boolean ignoreNull) {
        this.setIgnoreNull(ignoreNull);
        return this;
    }

    public void setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    public Joiner prefix(boolean prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    public Joiner postfix(boolean postfix) {
        this.postfix = postfix;
        return this;
    }

    public void setPostfix(boolean postfix) {
        this.postfix = postfix;
    }

    public boolean isSkipEmptyOrNullElements() {
        return this.skipEmptyOrNullElements;
    }

    public Joiner skipEmptyOrNullElements(boolean skipEmptyOrNullElements) {
        this.skipEmptyOrNullElements = skipEmptyOrNullElements;
        return this;
    }

    public void setSkipEmptyOrNullElements(boolean skipEmptyOrNullElements) {
        this.skipEmptyOrNullElements = skipEmptyOrNullElements;
    }

    public String join(Collection<?> params) {
        return this.joinInternal(params.toArray(new Object[0]));
    }

    public String join(int[] parameters) {
        Object[] ar = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            ar[i] = parameters[i];
        }
        return this.joinInternal(ar);
    }

    public <T> String join(T ... parameters) {
        return this.joinInternal(parameters);
    }

    public String joinInternal(Object[] parameters) {
        StringBuilder sb = new StringBuilder();
        int added = 0;
        for (Object s : parameters) {
            if (this.skip(s)) continue;
            this.addSeparator(added, s, parameters, sb);
            String toString = this.elementToString(s);
            ++added;
            sb.append(toString);
        }
        if (this.isPostfix()) {
            sb.append(this.getSeparator(added, null, parameters, sb));
        }
        if (this.isPrefix()) {
            sb.insert(0, this.getSeparator(-1, null, parameters, sb));
        }
        return sb.toString();
    }

    protected boolean skip(Object s) {
        if (this.isIgnoreNull() && s == null) {
            return true;
        }
        return s instanceof String && this.isIgnoreEmpty() && StringUtils.isEmpty((String)s);
    }

    protected Object getSeparator(int addedElements, Object element, Object[] parameters, StringBuilder sb) {
        return this.separator;
    }

    protected String elementToString(Object s) {
        return String.valueOf(s);
    }

    protected void addSeparator(int addedElements, Object element, Object[] parameters, StringBuilder sb) {
        if (addedElements > 0) {
            sb.append(this.elementToString(this.getSeparator(addedElements, element, parameters, sb)));
        }
    }
}

