/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.duration.tests;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import org.appwork.exceptions.WTFException;
import org.appwork.testframework.AWTest;
import org.appwork.utils.Time;
import org.appwork.utils.duration.ContextMissingException;
import org.appwork.utils.duration.IllegalTargetUnitsException;
import org.appwork.utils.duration.InvalidTimeSpanException;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.duration.TimeSpanWithContext;
import org.appwork.utils.duration.Unit;

public class TimeSpanTests
extends AWTest {
    @Override
    public void runTest() throws Exception {
        for (Unit u : Unit.values()) {
            for (int i = 0; i < 5000; ++i) {
                BigDecimal inU = Unit.NANO_SECONDS.convertTo(u, TimeSpan.AVERAGE_YEAR, new BigDecimal(i));
                BigDecimal inNano = u.convertTo(Unit.NANO_SECONDS, TimeSpan.AVERAGE_YEAR, inU);
                TimeSpanTests.assertTrue(inNano.compareTo(new BigDecimal(i)) == 0, " Convert " + i + "nanos Test " + (Object)((Object)u) + " with scale " + u.getRequiredScale() + " ");
            }
        }
        TimeSpanWithContext sec = TimeSpan.fromMillis(1000L).withCalendarContext(Time.timestamp());
        TimeSpanWithContext sec2 = TimeSpan.fromMillis(2000L).withCalendarContext(Time.timestamp());
        Thread.sleep(1100L);
        TimeSpanTests.assertTrue(sec.isExpired());
        TimeSpanTests.assertFalse(sec2.isExpired());
        TimeSpan zero = TimeSpan.fromMillis(0L);
        TimeSpan a = TimeSpan.fromMillis(1000L);
        TimeSpan b = TimeSpan.fromMillis(1000L);
        TimeSpanTests.assertTrue(a == b);
        TimeSpanWithContext c = TimeSpan.fromMillis(1000L, 365.0);
        TimeSpanWithContext d = TimeSpan.fromMillis(1000L, 365.0);
        TimeSpanTests.assertTrue(c == d);
        TimeSpanTests.assertTrue(TimeSpan.fromMillis(1000L, 365.0) == TimeSpan.parse("1000S!365.0"));
        TimeSpanTests.assertTrue(TimeSpan.fromMillis(1000L) == TimeSpan.parse("1000S"));
        long epoch151122 = 1668526692913L;
        TimeSpanTests.assertThat(TimeSpan.parse("1234ms")).is(TimeSpan.parse("1234S"));
        TimeSpanTests.assertThat(TimeSpan.parse("1234")).is(TimeSpan.parse("1234S"));
        TimeSpanTests.assertThat(TimeSpan.parse("1234!365")).is(TimeSpan.parse("1s234S!365"));
        new AWTest.AssertAnException<InvalidTimeSpanException>(){

            @Override
            public void run() throws InvalidTimeSpanException {
                TimeSpan.parse("1D2123");
            }
        }.start();
        new AWTest.AssertAnException<InvalidTimeSpanException>(){

            @Override
            public void run() throws InvalidTimeSpanException {
                TimeSpan.parse("1D2D");
            }
        }.start();
        new AWTest.AssertAnException<InvalidTimeSpanException>(){

            @Override
            public void run() throws InvalidTimeSpanException {
                TimeSpan.parse("P1D3D");
            }
        }.start();
        TimeSpanTests.assertThat(TimeSpan.parse("240h").shorten().format(false)).is("10D");
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").withStaticContext(365.0).normalized().format(true), "1Y!365.0");
        TimeSpanTests.assertEquals(this.parse("1Y").withStaticContext(365.0), this.parseJava18("P365D").withStaticContext(365.0));
        TimeSpanTests.assertEqualsNot(this.parse("1Y").withStaticContext(365.0), this.parseJava18("P365D"));
        TimeSpanTests.assertTrue(this.parse("1Y").withStaticContext(365.0).isSameAs(this.parseJava18("P365D")));
        TimeSpanTests.assertTrue(this.parse("1Y").withStaticContext(365.0).getBigDecimal(Unit.DAYS).compareTo(this.parseJava18("P365D").getBigDecimal(Unit.DAYS)) == 0);
        ZonedDateTime now = ZonedDateTime.now();
        long epoch = Instant.from(now).toEpochMilli();
        double month1 = this.parse("33Y99M477W585D644h811m537s378S67\u00b5261n").withCalendarContext(epoch151122).getDouble(Unit.MONTHS);
        double years1 = this.parse("33Y99M477W585D644h811m537s378S67\u00b5261n").withCalendarContext(epoch151122).getDouble(Unit.YEARS);
        double days1 = this.parse("33Y99M477W585D644h811m537s378S67\u00b5261n").withCalendarContext(epoch151122).getDouble(Unit.DAYS);
        long nanos1 = this.parse("33Y99M477W585D644h811m537s378S67\u00b5261n").withCalendarContext(epoch151122).getLong(Unit.NANO_SECONDS);
        TimeSpanTests.assertThat(nanos1).isNumber(1643189997378067261L);
        long millis1 = this.parse("33Y99M477W585D644h811m537s378S67\u00b5261n").withCalendarContext(epoch151122).getLong(Unit.MILLISECONDS);
        TimeSpanTests.assertThat(Math.round((double)nanos1 / 1000000.0)).isNumber(millis1);
        TimeSpanTests.assertThat(Math.round(month1 / years1)).isNumber(12);
        TimeSpanTests.assertThat(Math.round(days1 / years1)).isNumber(365);
        TimeSpanWithContext withCon = TimeSpan.parse("400D").withCalendarContext(epoch151122);
        TimeSpanTests.assertThat(withCon.getExpiresAtEpochMillis()).isNumber(withCon.normalized().getExpiresAtEpochMillis());
        TimeSpan inDAys = withCon.normalized().convert(Unit.DAYS);
        TimeSpanTests.assertEquals(withCon.getLong(Unit.DAYS), withCon.normalized().getLong(Unit.DAYS));
        TimeSpanTests.assertEquals(withCon.getLong(Unit.NANO_SECONDS), withCon.normalized().getLong(Unit.NANO_SECONDS));
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").withCalendarContext(epoch151122), TimeSpan.parse("1Y").withCalendarContext(epoch151122));
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").withCalendarContext(epoch151122).normalized().format(false), "1Y");
        TimeSpanTests.assertEqualsNot(TimeSpan.parse("365D").withCalendarContext(epoch151122), TimeSpan.parse("1Y").withCalendarContext(epoch));
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").withStaticContext(365.0), TimeSpan.parse("1Y").withStaticContext(365.0));
        TimeSpanTests.assertEqualsNot(TimeSpan.parse("365D"), TimeSpan.parse("1Y"));
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").withStaticContext(365.0).normalized().format(false), "1Y");
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").withStaticContext(365.0).normalized().format(true), TimeSpan.parse("1Y").withStaticContext(365.0).normalized().format(true));
        double monthsIn1Y180D = TimeSpan.parse("1Y180D").withCalendarContext(epoch151122).getDouble(Unit.MONTHS);
        long daysIn1Y180D = TimeSpan.parse("1Y180D").withCalendarContext(epoch151122).getLong(Unit.DAYS);
        TimeSpanTests.assertThat(daysIn1Y180D).isNumber(545);
        long dif = TimeSpan.parse("1S").withCalendarContext(epoch).getExpiresAtEpochMillis() - epoch;
        TimeSpanTests.assertThat(dif).isNumber(1);
        long daysIn2YearsFrom = TimeSpan.parse("2Y").withCalendarContext(epoch151122).getBigDecimal(Unit.DAYS).intValueExact();
        TimeSpanTests.assertThat(daysIn2YearsFrom).isNumber(731);
        long in2Years = TimeSpan.parse("2Y").withCalendarContext(epoch).getExpiresAtEpochMillis();
        ZonedDateTime in2YearsDateTime = now.plusYears(2L);
        long in2YearsViaZonedDateTime = Instant.from(in2YearsDateTime).toEpochMilli();
        TimeSpanTests.assertThat(in2YearsViaZonedDateTime).isNumber(in2Years);
        TimeSpanTests.assertTrue(TimeSpan.parse("1h").isMoreThan(TimeSpan.parse("59m59.999s")));
        TimeSpanTests.assertTrue(TimeSpan.parse("59m59.999s").isLessThan(TimeSpan.parse("1h")));
        TimeSpanTests.assertTrue(TimeSpan.parse("59m60s").isSameAs(TimeSpan.parse("1h")));
        TimeSpanTests.assertEquals(this.parse("1.123456789s"), this.parseJava18("PT1.123456789s"));
        this.parseJava18("-PT6H3M");
        new AWTest.AssertAnException<IllegalTargetUnitsException>(){

            @Override
            public void run() throws IllegalTargetUnitsException {
                TimeSpan parsed = null;
                try {
                    parsed = TimeSpanTests.this.parse("2147483647D");
                    TimeSpan timeSpan = parsed.convert(Unit.HOURS, Unit.MINUTES);
                }
                catch (Exception e1) {
                    if (e1 instanceof IllegalTargetUnitsException) {
                        throw (IllegalTargetUnitsException)e1;
                    }
                    throw new WTFException(e1);
                }
            }
        }.start();
        TimeSpan ref = TimeSpan.parse("0s!365");
        Unit.NANO_SECONDS.convertTo(Unit.DAYS, ref, new BigDecimal(8));
        this.parse("878W723D936h491m502s796S350\u00b512n");
        TimeSpanTests.assertEqualsNot(TimeSpan.parse("1D!365"), TimeSpan.parse("1D"));
        TimeSpanTests.assertThat(this.parse("2147483647W8D").normalized().format(true)).is("2147483647W8D");
        this.testByMillis(2149633612L);
        TimeSpanTests.assertThat(TimeSpan.parse("1h")).isHigherThan(TimeSpan.parse("59m"));
        TimeSpanTests.assertThat(TimeSpan.parse("23h")).isLowerThan(TimeSpan.parse("1D"));
        TimeSpanTests.assertThat(TimeSpan.parse("24h")).isSameAs(TimeSpan.parse("1D"));
        TimeSpanTests.assertThat(TimeSpan.parse("61m")).isHigherThan(TimeSpan.parse("1h"));
        TimeSpanTests.assertThat(TimeSpan.parse("2Y")).isHigherThan(TimeSpan.parse("1Y"));
        TimeSpanTests.assertThat(TimeSpan.parse("2Y")).isSameAs(TimeSpan.parse("24M"));
        new AWTest.AssertAnException<TimeSpan.TimeSpanCompareException>(){

            @Override
            public void run() throws TimeSpan.TimeSpanCompareException {
                try {
                    TimeSpan.parse("32D").compareTo(TimeSpan.parse("1M"));
                }
                catch (InvalidTimeSpanException e) {
                    throw new WTFException(e);
                }
            }
        }.start();
        TimeSpanTests.assertTrue(TimeSpan.parse("1h") == TimeSpan.parse("1h"));
        new AWTest.AssertAnException<InvalidTimeSpanException>(){

            @Override
            public void run() throws InvalidTimeSpanException {
                TimeSpan.parse("2147483648m");
            }
        }.start();
        new AWTest.AssertAnException<InvalidTimeSpanException>(){

            @Override
            public void run() throws InvalidTimeSpanException {
                TimeSpan.parse("1.234D");
            }
        }.start();
        TimeSpanTests.assertThat(TimeSpan.parse("1.123456s").normalized()).is(TimeSpan.parse("1s123S456\u00b5").normalized());
        for (int i = 0; i < 100000; ++i) {
            String s = "";
            if (Math.random() > 0.5) {
                s = s + "-";
            }
            for (int l = Unit.values().length - 1; l >= 0; --l) {
                Unit u = Unit.values()[l];
                int amount = (int)(Math.random() * 1000.0);
                if (amount <= 0) continue;
                s = s + amount + "" + u.sign;
            }
            System.out.println(s);
            this.parse(s);
        }
        int speed = 100;
        for (int neg = 0; neg < 2; ++neg) {
            for (int Y = 0; Y < 1000; ++Y) {
                for (int M = 0; M < 24; M += speed * 7) {
                    for (int W = 0; W < 15; W += speed * 3) {
                        for (int D = 0; D < 32; D += speed * 7) {
                            for (int h = 0; h < 32; h += speed * 7) {
                                for (int m = 0; m < 121; m += speed * 7) {
                                    for (int s = 0; s < 121; s += speed * 7) {
                                        for (int ms = 0; ms < 1201; ms += speed * 127) {
                                            for (int us = 0; us < 1201; us += speed * 127) {
                                                for (int ns = 0; ns < 1201; ns += speed * 127) {
                                                    String p;
                                                    String string = p = neg == 0 ? "" : "-";
                                                    if (Y > 0) {
                                                        p = p + Y + "Y";
                                                    }
                                                    if (M > 0) {
                                                        p = p + M + "M";
                                                    }
                                                    if (W > 0) {
                                                        p = p + W + "W";
                                                    }
                                                    if (D > 0) {
                                                        p = p + D + "D";
                                                    }
                                                    if (h > 0) {
                                                        p = p + h + "h";
                                                    }
                                                    if (m > 0) {
                                                        p = p + m + "m";
                                                    }
                                                    if (s > 0) {
                                                        p = p + s + "s";
                                                    }
                                                    if (ms > 0) {
                                                        p = p + ms + "S";
                                                    }
                                                    if (us > 0) {
                                                        p = p + us + "\u00b5";
                                                    }
                                                    if (ns > 0) {
                                                        p = p + ns + "n";
                                                    }
                                                    if (p.length() < 2) {
                                                        p = p + "0s";
                                                    }
                                                    System.out.println(p);
                                                    this.parse(p);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        for (int i = 0; i < 100000; ++i) {
            String s = "";
            if (Math.random() > 0.5) {
                s = s + "-";
            }
            for (int l = Unit.values().length - 1; l >= 0; --l) {
                Unit u = Unit.values()[l];
                int amount = (int)(Math.random() * 2.147483647E9);
                if (amount <= 0) continue;
                s = s + amount + "" + u.sign;
            }
            System.out.println(s);
            this.parse(s);
        }
        TimeSpanTests.assertThat(TimeSpan.fromMillis(300000L)).is(TimeSpan.parse("5m"));
        TimeSpanTests.assertEqualsNot(TimeSpan.parse("365D!365").normalized(), TimeSpan.parse("1Y"));
        TimeSpanTests.assertThat(this.parse("1Y").withStaticContext(365.0)).isSameAs(this.parseJava18("P365D"));
        TimeSpanTests.assertThat(this.parse("1Y!2022-01-01T00:00:00+0100")).isSameAs(this.parseJava18("P365D"));
        TimeSpanTests.assertThat(this.parse("1Y!365.0").withStaticContext(365.0)).isSameAs(this.parseJava18("P365D"));
        TimeSpan.parse("1Y", 365.0).convert(Unit.WEEKS, Unit.HOURS).format(true);
        TimeSpanTests.assertEqualsNot(this.parse("1Y"), this.parseJava18("P365D"));
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").withStaticContext(366.0).normalized().format(false), "11M4W1D12h");
        TimeSpanTests.assertEquals(TimeSpan.parse("365D").normalized().format(true), "52W1D");
        TimeSpanTests.assertEquals(TimeSpan.parse("12M47D49h").normalized().format(true), "1Y7W1h");
        TimeSpanTests.assertEquals(TimeSpan.parse("12M52W47D49h").normalized().format(true), "1Y59W1h");
        TimeSpanTests.assertEquals(TimeSpan.parse("500000000n"), TimeSpan.parse("0.5s"));
        long millis = Instant.from(now).toEpochMilli();
        TimeSpanTests.assertThat(TimeSpan.parse("1Y").withCalendarContext(millis).getLong(Unit.SECONDS)).is(ChronoUnit.SECONDS.between(now, now.plusYears(1L)));
        TimeSpan n = TimeSpan.parse("1Y2000000000n");
        n = n.normalized();
        TimeSpanTests.assertThat(n.format(true)).is("1Y2s");
        long seconds = n.withCalendarContext(millis).getLong(Unit.SECONDS);
        long yearInSeconds = TimeSpan.parse("1Y").withCalendarContext(millis).getLong(Unit.SECONDS);
        TimeSpanTests.assertThat(seconds - yearInSeconds).isNumber(2);
        long byChronos = ChronoUnit.SECONDS.between(now, now.plusYears(1L).plusSeconds(2L));
        TimeSpanTests.assertThat(TimeSpan.parse("1Y2000000000n").withCalendarContext(millis).getLong(Unit.SECONDS)).isNumber(byChronos);
        TimeSpanTests.assertThat(TimeSpan.parse("1Y").withCalendarContext(millis).getLong(Unit.MONTHS)).isNumber(12);
        TimeSpanTests.assertThat(TimeSpan.parse("2Y").withCalendarContext(millis).getLong(Unit.DAYS)).isNumber(ChronoUnit.DAYS.between(now, now.plusYears(2L)));
        TimeSpanTests.assertThat(TimeSpan.parse("1Y").withCalendarContext(millis).getLong(Unit.MINUTES)).isNumber(ChronoUnit.MINUTES.between(now, now.plusYears(1L)));
        TimeSpanTests.assertEquals(TimeSpan.parse("1M", 366.0), TimeSpan.parse("30D12h", 366.0));
        TimeSpanTests.assertEquals(TimeSpan.parse("100Y12M47d49h").normalized().format(true), "101Y7W1h");
        TimeSpanTests.assertEquals(TimeSpan.parse("12M"), TimeSpan.parse("1Y"));
        TimeSpanTests.assertEquals(TimeSpan.parse("12M"), TimeSpan.parse("1Y"));
        TimeSpanTests.assertEquals(TimeSpan.parse("500S"), TimeSpan.parse("0.5s"));
        TimeSpanTests.assertEquals(TimeSpan.parse("7D"), TimeSpan.parse("1W"));
        TimeSpanTests.assertEquals(TimeSpan.parse("168h"), TimeSpan.parse("1W"));
        TimeSpanTests.assertEqualsNot(TimeSpan.parse("1M"), TimeSpan.parse("30d"));
        TimeSpanTests.assertEqualsNot(TimeSpan.parse("1M"), TimeSpan.parse("31d"));
        TimeSpanTests.assertEqualsNot(TimeSpan.parse("1M"), TimeSpan.parse("28d"));
        TimeSpanTests.assertEquals(TimeSpan.parse("6D"), TimeSpan.parse("4D48h"));
        TimeSpanTests.assertEquals(TimeSpan.parse("2m"), TimeSpan.parse("120s"));
        TimeSpanTests.assertEquals(TimeSpan.parse("120s").normalized().format(true), TimeSpan.parse("119s1000S").normalized().format(true));
        TimeSpanTests.assertEquals("24h120s500S", TimeSpan.parse("24h120.5s").format(true));
        TimeSpanTests.assertEquals("1D2m500S", TimeSpan.parse("24h120.5s").normalized().format(true));
        TimeSpanTests.assertThat(TimeSpan.parse("24h120s").format(true)).is("24h120s");
        TimeSpanTests.assertThat(TimeSpan.parse("24 h 120 s").format(true)).is("24h120s");
        TimeSpanTests.assertThat(TimeSpan.parse("24h120s").getDeclared(Unit.SECONDS)).is(120);
        TimeSpanTests.assertThat(TimeSpan.parse("1D").getLong(Unit.HOURS)).isNumber(24);
        TimeSpanTests.assertThat(TimeSpan.parse("24h").getLong(Unit.HOURS)).isNumber(24);
        TimeSpanTests.assertThat(TimeSpan.parse("24h120s").getDeclared(Unit.MINUTES)).isNumber(0);
        TimeSpanTests.assertThat(TimeSpan.parse("1M", 365.0).getLong(Unit.MONTHS)).isNumber(1);
        TimeSpanTests.assertThat(TimeSpan.parse("1M").getLong(Unit.MONTHS)).isNumber(1);
        TimeSpanTests.assertThat(TimeSpan.parse("1M").getMilliseconds()).isNumber(0);
        String format = TimeSpan.parse("1Y", 365.0).convert(Unit.WEEKS, Unit.HOURS).format(false);
        TimeSpanTests.assertThat(format).is("52W24h");
        format = TimeSpan.parse("1Y", 365.0).convert(Unit.MONTHS).format(false);
        TimeSpanTests.assertThat(format).is("12M");
        format = TimeSpan.parse("1Y", 365.5).convert(Unit.DAYS, Unit.HOURS).withoutContext().format(true);
        TimeSpanTests.assertThat(format).is("365D12h");
        try {
            format = TimeSpan.parse("1Y", 365.0).convert(Unit.WEEKS).format(true);
            throw new Exception("Expected Exception");
        }
        catch (IllegalTargetUnitsException ns) {
            TimeSpan dur = TimeSpan.parse("365D");
            dur = dur.withStaticContext(365.0);
            TimeSpanTests.assertTrue(dur.withStaticContext(365.0) == dur);
            TimeSpanTests.assertFalse(TimeSpan.parse("1H").hasContext());
            TimeSpanTests.assertTrue(TimeSpan.parse("1H!NOW").hasCalendarContext());
            TimeSpanTests.assertTrue(TimeSpan.parse("1H").withContext(TimeSpan.parse("1H!NOW")).hasContext());
            TimeSpanTests.assertTrue(TimeSpan.parse("1H").withContext(TimeSpan.parse("1H!NOW")) instanceof TimeSpanWithContext);
            TimeSpanTests.assertTrue(TimeSpan.parse("1H!NOW") instanceof TimeSpanWithContext);
            TimeSpanTests.assertTrue(TimeSpan.parse("1H!365") instanceof TimeSpanWithContext);
            TimeSpanTests.assertTrue(TimeSpan.parse("1H!365").hasStaticContext());
            TimeSpanTests.assertFalse(TimeSpan.parse("1H") instanceof TimeSpanWithContext);
            TimeSpanTests.assertTrue(this.parse("-1Y").withStaticContext(365.0).format(false).equals("-1Y"));
            TimeSpanTests.assertThat(dur.getLong(Unit.DAYS)).isNumber(365);
            TimeSpanTests.assertThat(dur.getDeclared(Unit.DAYS)).isNumber(365);
            TimeSpanTests.assertThat(dur.withStaticContext(365.0).normalized().getDeclared(Unit.DAYS)).isNumber(0);
            TimeSpanTests.assertThat(dur.withStaticContext(366.0).normalized().getDeclared(Unit.DAYS)).isNumber(1);
            long hours = dur.getLong(Unit.HOURS);
            TimeSpanTests.assertThat(hours).isNumber(8760);
            TimeSpanTests.assertThat(dur.convert(Unit.HOURS).format(false)).is((int)hours + "h");
            dur = dur.withStaticContext(365.0);
            TimeSpan normed = dur.normalized();
            TimeSpanTests.assertEquals("1Y", normed.format(false));
            dur = dur.withoutContext();
            normed = dur.normalized();
            TimeSpanTests.assertEquals("52W1D", normed.format(true));
            TimeSpanTests.assertThat(TimeSpan.parse("52W 1D")).is(TimeSpan.parse("52W1D"));
            this.parseJava18("-PT6H3M");
            this.parse("-5h77m");
            try {
                this.parseJava18("PT-6H3M");
                throw new Exception();
            }
            catch (InvalidTimeSpanException invalidTimeSpanException) {
                TimeSpanTests.assertEquals("-4h1m", this.parseJava18("-PT2H121M").normalized().format(true));
                TimeSpanTests.assertEquals(this.parse("-6h3m"), this.parseJava18("-PT6H3M"));
                TimeSpanTests.assertEquals("100s", this.parse("100s").format(true));
                TimeSpanTests.assertEquals("1m40s", this.parse("100s").normalized().format(true));
                String formated = this.parse("2147483647n").normalized().format(true);
                TimeSpanTests.assertEquals("2s147S483\u00b5647n", formated);
                TimeSpan d2 = this.parse("200h");
                formated = d2.normalized().format(true);
                TimeSpanTests.assertEquals("1W1D8h", formated);
                formated = this.parse("25h").normalized().format(true);
                TimeSpanTests.assertEquals("1D1h", formated);
                TimeSpan test = this.parse("2147483647s");
                TimeSpan normalized = test.normalized();
                formated = test.normalized().format(true);
                TimeSpanTests.assertEquals("3550W5D3h14m7s", formated);
                TimeSpanTests.assertEquals(this.parse("2147483647s"), this.parse("3550W5D3h14m7s"));
                double years = this.parse("1000Y").withCalendarContext(millis).getDouble(Unit.YEARS);
                TimeSpanTests.assertThat(years).is(1000.0);
                TimeSpanTests.assertEquals(this.parse("5m"), this.parseJava18("PT5M"));
                TimeSpanTests.assertEquals(this.parse("1W"), this.parseJava18("P7D"));
                TimeSpanTests.assertEquals(this.parse("5m"), this.parseJava18("PT5M"));
                TimeSpanTests.assertEquals(this.parse("2D3h4m"), this.parseJava18("P2DT3H4M"));
                Calendar c2 = Calendar.getInstance();
                int monthMaxDays = c2.getActualMaximum(5);
                TimeSpanTests.assertThat(this.parse("1M").withStaticContext(monthMaxDays * 12)).isSameAs(this.parseJava18("P" + monthMaxDays + "D"));
                TimeSpanTests.assertThat(this.parse("-1Y").withStaticContext(365.0)).isSameAs(this.parseJava18("-P365D"));
                TimeSpanTests.assertThat(this.parse("  -1  Y  ").withStaticContext(365.0)).isSameAs(this.parseJava18("-P365D"));
                TimeSpanTests.assertEquals(this.parse("1D"), this.parseJava18("P1D"));
                TimeSpanTests.assertEquals(this.parse("1h"), this.parseJava18("PT1H"));
                TimeSpanTests.assertEquals(this.parse("1m"), this.parseJava18("PT1M"));
                TimeSpanTests.assertEquals(this.parse("1s"), this.parseJava18("PT1S"));
                TimeSpanTests.assertEquals(this.parse("1.123s"), this.parseJava18("PT1.123S"));
                TimeSpanTests.assertEquals(this.parse("1 . 1 2 3s"), this.parseJava18("PT1.123S"));
                TimeSpanTests.assertEquals(this.parse("15m"), this.parseJava18("PT15M"));
                TimeSpanTests.assertEquals(this.parse("10h"), this.parseJava18("PT10H"));
                TimeSpanTests.assertEquals(this.parse("2D"), this.parseJava18("P2D"));
                TimeSpanTests.assertEquals(this.parse("-6h3m"), this.parseJava18("-PT6H3M"));
                TimeSpanTests.assertEquals(this.parse("1m"), this.parseJava18("PT1M"));
                TimeSpanTests.assertEquals(TimeSpan.parse("14M47D49h").normalized().format(true), "1Y2M7W1h");
                return;
            }
        }
    }

    private void testByMillis(long i) throws ContextMissingException, Exception {
        TimeSpanWithContext span = TimeSpan.fromMillis(i, 365.0);
        TimeSpan normalized = ((TimeSpan)span).normalized();
        String formated = span.format(true);
        TimeSpanTests.assertThat(normalized.format(true)).equals(formated);
        if (i % 10000L == 0L) {
            System.out.println(i + " - " + 100.0 * ((double)i / 9.223372036854776E18) + " - " + formated);
        }
        TimeSpan reparsed = TimeSpan.parse(formated);
        TimeSpanTests.assertThat(reparsed.getLong(Unit.MILLISECONDS)).isNumber(i);
    }

    private TimeSpan parseJava18(String string) throws NumberFormatException, InvalidTimeSpanException, Exception {
        Duration ret = Duration.parse(string);
        long nanosjava = Math.addExact(Math.multiplyExact(ret.getSeconds(), 1000000000L), (long)ret.getNano());
        TimeSpan dur = this.parse(string);
        double nanosAppwork = dur.withCalendarContext(System.currentTimeMillis()).getDouble(Unit.NANO_SECONDS);
        return dur;
    }

    private TimeSpan parse(String string) throws Exception {
        TimeSpan ret = TimeSpan.parse(string);
        double days = ret.withStaticContext(365.0).getDouble(Unit.DAYS);
        if (!(string.contains("P") || string.contains(".") || string.contains("T"))) {
            TimeSpanTests.assertEquals(string.replaceAll("\\s+", ""), ret.toString());
        }
        TimeSpan normed = ret.normalized();
        double normedDays = ret.withStaticContext(365.0).getDouble(Unit.DAYS);
        TimeSpanTests.assertEquals(normedDays, days);
        TimeSpan test = TimeSpan.parse(normed.format(true));
        TimeSpanTests.assertEquals(ret, test);
        test = TimeSpan.parse(ret.format(true));
        TimeSpanTests.assertEquals(ret, test);
        return ret;
    }

    public static void main(String[] args) {
        TimeSpanTests.run();
    }
}

