/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event.ide;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.appwork.utils.IO;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;

public class EventSenderIDEFactory {
    private static void create(String name, File file) throws IOException {
        String pkg = "";
        System.out.println("");
        File p = file;
        do {
            if (pkg.length() > 0) {
                pkg = "." + pkg;
            }
            pkg = p.getName() + pkg;
        } while ((p = p.getParentFile()) != null && !p.getName().equals("src"));
        StringBuilder sb = new StringBuilder();
        String senderName = name + "EventSender";
        String eventName = name + "Event";
        String listenerName = name + "Listener";
        sb.append("package " + pkg + ";\r\n\r\n");
        sb.append("import org.appwork.utils.event.Eventsender;\r\n\r\n");
        sb.append("public class " + senderName + " extends Eventsender<" + listenerName + ", " + eventName + "> {\r\n\r\n");
        sb.append("@Override\r\n");
        sb.append("protected void fireEvent(" + listenerName + " listener, " + eventName + " event) {\r\nswitch (event.getType()) {\r\n//fill\r\ndefault: System.out.println(\"Unhandled Event: \"+event); \r\n}\r\n}");
        sb.append("}");
        new File(file, senderName + ".java").delete();
        IO.writeStringToFile(new File(file, senderName + ".java"), sb.toString());
        sb = new StringBuilder();
        sb.append("package " + pkg + ";\r\n\r\n");
        sb.append("import java.util.EventListener;\r\n\r\n");
        sb.append("public interface " + listenerName + " extends EventListener {\r\n\r\n}");
        new File(file, listenerName + ".java").delete();
        IO.writeStringToFile(new File(file, listenerName + ".java"), sb.toString());
        sb = new StringBuilder();
        sb.append("package " + pkg + ";\r\n\r\n");
        sb.append("import org.appwork.utils.event.SimpleEvent;\r\n\r\n");
        sb.append("public class " + eventName + " extends SimpleEvent<Object, Object, " + eventName + ".Type> {\r\n\r\n");
        sb.append("public static enum Type{\r\n}\r\n");
        sb.append("public " + eventName + "(Object caller, Type type, Object... parameters) {\r\n");
        sb.append("super(caller, type, parameters);\r\n}\r\n");
        sb.append("}");
        new File(file, eventName + ".java").delete();
        IO.writeStringToFile(new File(file, eventName + ".java"), sb.toString());
    }

    public static void main(String[] args) throws DialogClosedException, DialogCanceledException, IOException, URISyntaxException {
        URL root = Thread.currentThread().getClass().getResource("/");
        File rootFile = new File(root.toURI());
        String name = Dialog.getInstance().showInputDialog("Enter Name");
        ExtFileChooserDialog d = new ExtFileChooserDialog(0, "Choose folder", null, null);
        d.setStorageID("EventSenderCReater");
        d.setFileSelectionMode(FileChooserSelectionMode.DIRECTORIES_ONLY);
        d.setType(FileChooserType.OPEN_DIALOG);
        d.setMultiSelection(false);
        d.setPreSelection(rootFile.getParentFile().getParentFile());
        try {
            Dialog.I().showDialog(d);
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
        EventSenderIDEFactory.create(name, d.getSelectedFile());
        System.exit(1);
    }
}

