/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import org.appwork.utils.Regex;
import org.appwork.utils.locale._AWU;

public class SizeFormatter {
    private static final Pattern DOUBLE = Pattern.compile("([\\d]+)[.,:]([\\d]+)", 2);
    private static final Pattern NUMBER = Pattern.compile("([\\d]+)", 2);
    private static final Pattern TB = Pattern.compile("t((\u00e9|e)ra(-| )?)?(b|byte|ib|ig|o|octet)", 2);
    private static final Pattern GB = Pattern.compile("g(iga(-| )?)?(b|byte|ib|ig|o|octet)", 2);
    private static final Pattern MB = Pattern.compile("m((\u00e9|e)ga(-| )?)?(b|byte|ib|o|octet)", 2);
    private static final Pattern KB = Pattern.compile("k(ilo(-| )?)?(b|byte|ib|o|octet)", 2);

    public static String formatBytes(DecimalFormat c, long fileSize) {
        return SizeFormatter.formatBytes((NumberFormat)c, fileSize);
    }

    public static String formatBytes(NumberFormat c, long fileSize) {
        long abs = Math.abs(fileSize);
        if (abs >= Unit.TB.getBytes1024()) {
            return _AWU.T.literally_tebibyte(c.format((double)fileSize / (double)Unit.TB.getBytes1024()));
        }
        if (abs >= Unit.GB.getBytes1024()) {
            return _AWU.T.literally_gibibyte(c.format((double)fileSize / (double)Unit.GB.getBytes1024()));
        }
        if (abs >= Unit.MB.getBytes1024()) {
            return _AWU.T.literally_mebibyte(c.format((double)fileSize / (double)Unit.MB.getBytes1024()));
        }
        if (abs >= Unit.KB.getBytes1024()) {
            return _AWU.T.literally_kibibyte(c.format((double)fileSize / (double)Unit.KB.getBytes1024()));
        }
        return _AWU.T.literally_byte(fileSize);
    }

    @Deprecated
    public static String formatBytes(long fileSize) {
        return SizeFormatter.formatBytes(NumberFormat.getInstance(), fileSize);
    }

    public static Unit getSmallerUnit(Unit unit) {
        return Unit.values()[Math.min(Unit.values().length - 1, unit.ordinal() + 1)];
    }

    public static Unit getBiggerUnit(Unit unit) {
        return Unit.values()[Math.max(0, unit.ordinal() - 1)];
    }

    public static Unit getBestUnit(long fileSize) {
        long abs = Math.abs(fileSize);
        if (abs >= Unit.TB.getBytes1024()) {
            return Unit.TB;
        }
        if (abs >= Unit.GB.getBytes1024()) {
            return Unit.GB;
        }
        if (abs >= Unit.MB.getBytes1024()) {
            return Unit.MB;
        }
        if (abs >= Unit.KB.getBytes1024()) {
            return Unit.KB;
        }
        return Unit.B;
    }

    @Deprecated
    public static long getSize(String string) {
        return SizeFormatter.getSize(string, true, false);
    }

    @Deprecated
    public static long getSize(String string, boolean kibi, boolean allowNegative) {
        return SizeFormatter.getSize(null, string, kibi, allowNegative);
    }

    public static long getSize(NumberFormat format, String string, boolean kibi, boolean allowNegative) {
        String[][] matches;
        boolean negative = allowNegative ? Pattern.compile("\\D*\\-.*").matcher(string).matches() : false;
        if (format instanceof DecimalFormat) {
            DecimalFormatSymbols symbols = ((DecimalFormat)format).getDecimalFormatSymbols();
            string = string.replace(Character.toString(symbols.getGroupingSeparator()), "");
            string = string.replace(Character.toString(symbols.getDecimalSeparator()), ".");
        }
        if ((matches = new Regex(string, DOUBLE).getMatches()) == null || matches.length == 0) {
            matches = new Regex(string, NUMBER).getMatches();
        }
        if (matches != null && matches.length >= 1) {
            long unitLong;
            long l = unitLong = kibi ? SizeFormatter.getBestUnit(string).getBytes1024() : SizeFormatter.getBestUnit(string).getBytes1000();
            if (matches[0].length == 2 && Long.parseLong(matches[0][1]) > 0L) {
                double ret = Double.parseDouble(matches[0][0] + "." + matches[0][1]) * (double)unitLong;
                return negative ? -Math.round(ret) : Math.round(ret);
            }
            long ret = Long.parseLong(matches[0][0]) * unitLong;
            return negative ? -ret : ret;
        }
        return -1L;
    }

    private static Unit getBestUnit(String unitText) {
        if (new Regex(unitText, TB).patternFind()) {
            return Unit.TB;
        }
        if (new Regex(unitText, GB).patternFind()) {
            return Unit.GB;
        }
        if (new Regex(unitText, MB).patternFind()) {
            return Unit.MB;
        }
        if (new Regex(unitText, KB).patternFind()) {
            return Unit.KB;
        }
        return Unit.B;
    }

    @Deprecated
    public static long getSize(String string, boolean kibi) {
        return SizeFormatter.getSize(string, kibi, false);
    }

    public static enum Unit {
        TB(0x10000000000L, 1000000000000L),
        GB(0x40000000L, 1000000000L),
        MB(0x100000L, 1000000L),
        KB(1024L, 1000L),
        B(1L, 1L);

        private final long bytes;
        private final long kibytes;

        public final long getBytes1024() {
            return this.kibytes;
        }

        private Unit(long kibytes, long bytes) {
            this.bytes = bytes;
            this.kibytes = kibytes;
        }

        public final long getBytes1000() {
            return this.bytes;
        }
    }
}

