/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.appwork.utils.images.AbstractIconPipe;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.ModificationType;

public class BorderedIcon
extends AbstractIconPipe {
    private static final Set<ModificationType> MODIFICATIONS = Collections.unmodifiableSet(new HashSet<ModificationType>(Arrays.asList(ModificationType.OVERLAY, ModificationType.SIZE)));
    private int borderWidth;
    private Color borderColor;

    public BorderedIcon(Icon delegate, Color color, int borderWidth) {
        super(delegate);
        this.borderWidth = borderWidth;
        this.borderColor = color;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, List<Icon> parents) {
        Graphics2D g2d = (Graphics2D)g.create();
        AffineTransform originalTransform = g2d.getTransform();
        double scaleX = originalTransform.getScaleX();
        double scaleY = originalTransform.getScaleY();
        int scaledBorderVertical = IconIO.clipScale(this.borderWidth, scaleX);
        int scaledBorderHorizontal = IconIO.clipScale(this.borderWidth, scaleY);
        int scaledWidthIconDelegate = IconIO.clipScale(this.delegate.getIconWidth(), scaleX);
        int scaledheightIconDelegate = IconIO.clipScale(this.delegate.getIconHeight(), scaleY);
        if (this.borderColor != null) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setColor(this.borderColor);
            g2d.scale(1.0 / scaleX, 1.0 / scaleY);
            int xDev = IconIO.clipScale(x, scaleX);
            int yDev = IconIO.clipScale(y, scaleY);
            int widthDev = scaledWidthIconDelegate + scaledBorderVertical + scaledBorderHorizontal;
            int heightDev = scaledheightIconDelegate + scaledBorderVertical + scaledBorderHorizontal;
            g2d.setColor(this.borderColor);
            for (int i = 0; i < scaledBorderVertical; ++i) {
                g2d.drawRect(xDev + i, yDev + i, widthDev - 1 - 2 * i, heightDev - 1 - 2 * i);
            }
            g2d.setTransform(originalTransform);
        }
        g2d.setColor(Color.green);
        g2d.dispose();
        this.paintDelegate(c, g, x + this.borderWidth, y + this.borderWidth, parents);
    }

    @Override
    public int getIconWidth() {
        return super.getIconWidth() + this.borderWidth * 2;
    }

    @Override
    public int getIconHeight() {
        return super.getIconHeight() + this.borderWidth * 2;
    }

    @Override
    public Set<ModificationType> getModifications() {
        return MODIFICATIONS;
    }
}

