/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.image.BufferedImage;

public class ImageCropper {
    public BufferedImage cropTransparentBorder(BufferedImage img) {
        int left = this.findLeftBoundary(img);
        int right = this.findRightBoundary(img);
        int top = this.findTopBoundary(img);
        int bottom = this.findBottomBoundary(img);
        if (left < 0 || right < 0 || top < 0 || bottom < 0) {
            return img;
        }
        int newWidth = right - left + 1;
        int newHeight = bottom - top + 1;
        return img.getSubimage(left, top, newWidth, newHeight);
    }

    private int findLeftBoundary(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int midY = height / 2;
        int candidate = -1;
        for (int x = 0; x < width; ++x) {
            if (this.isTransparent(img.getRGB(x, midY))) continue;
            candidate = x;
            break;
        }
        if (candidate == -1) {
            return -1;
        }
        if (candidate > 0) {
            boolean colBeforeTransparent = true;
            for (int y = 0; y < height; ++y) {
                if (this.isTransparent(img.getRGB(candidate - 1, y))) continue;
                colBeforeTransparent = false;
                break;
            }
            if (colBeforeTransparent) {
                return candidate;
            }
            for (int x = 0; x < candidate; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (this.isTransparent(img.getRGB(x, y))) continue;
                    return x;
                }
            }
        }
        return candidate;
    }

    private int findRightBoundary(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int midY = height / 2;
        int candidate = -1;
        for (int x = width - 1; x >= 0; --x) {
            if (this.isTransparent(img.getRGB(x, midY))) continue;
            candidate = x;
            break;
        }
        if (candidate == -1) {
            return -1;
        }
        if (candidate < width - 1) {
            boolean colAfterTransparent = true;
            for (int y = 0; y < height; ++y) {
                if (this.isTransparent(img.getRGB(candidate + 1, y))) continue;
                colAfterTransparent = false;
                break;
            }
            if (colAfterTransparent) {
                return candidate;
            }
            for (int x = width - 1; x > candidate; --x) {
                for (int y = 0; y < height; ++y) {
                    if (this.isTransparent(img.getRGB(x, y))) continue;
                    return x;
                }
            }
        }
        return candidate;
    }

    private int findTopBoundary(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int midX = width / 2;
        int candidate = -1;
        for (int y = 0; y < height; ++y) {
            if (this.isTransparent(img.getRGB(midX, y))) continue;
            candidate = y;
            break;
        }
        if (candidate == -1) {
            return -1;
        }
        if (candidate > 0) {
            boolean rowBeforeTransparent = true;
            for (int x = 0; x < width; ++x) {
                if (this.isTransparent(img.getRGB(x, candidate - 1))) continue;
                rowBeforeTransparent = false;
                break;
            }
            if (rowBeforeTransparent) {
                return candidate;
            }
            for (int y = 0; y < candidate; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (this.isTransparent(img.getRGB(x, y))) continue;
                    return y;
                }
            }
        }
        return candidate;
    }

    private int findBottomBoundary(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int midX = width / 2;
        int candidate = -1;
        for (int y = height - 1; y >= 0; --y) {
            if (this.isTransparent(img.getRGB(midX, y))) continue;
            candidate = y;
            break;
        }
        if (candidate == -1) {
            return -1;
        }
        if (candidate < height - 1) {
            boolean rowAfterTransparent = true;
            for (int x = 0; x < width; ++x) {
                if (this.isTransparent(img.getRGB(x, candidate + 1))) continue;
                rowAfterTransparent = false;
                break;
            }
            if (rowAfterTransparent) {
                return candidate;
            }
            for (int y = height - 1; y > candidate; --y) {
                for (int x = 0; x < width; ++x) {
                    if (this.isTransparent(img.getRGB(x, y))) continue;
                    return y;
                }
            }
        }
        return candidate;
    }

    private boolean isTransparent(int argb) {
        return (argb >> 24 & 0xFF) == 0;
    }
}

