/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class J7FileList {
    public static List<File> findFiles(Pattern pattern, File directory, boolean filesOnly) throws IOException {
        return J7FileList.findFiles(pattern, directory, filesOnly, true);
    }

    public static List<File> findFiles(Pattern pattern, File directory, boolean filesOnly, boolean patternOnFileNameOnly) throws IOException {
        ArrayList<File> ret = new ArrayList<File>();
        if (directory != null && directory.exists()) {
            DirectoryStream<Path> stream = null;
            try {
                Path directoryPath = directory.toPath();
                FileSystem fs = directoryPath.getFileSystem();
                if (pattern != null) {
                    final PathMatcher matcher = fs.getPathMatcher("regex:" + pattern.pattern());
                    DirectoryStream.Filter<Path> filter = patternOnFileNameOnly ? new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path entry) {
                            return matcher.matches(entry.getFileName());
                        }
                    } : new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path entry) {
                            return matcher.matches(entry.toAbsolutePath());
                        }
                    };
                    stream = fs.provider().newDirectoryStream(directoryPath, (DirectoryStream.Filter<? super Path>)filter);
                } else {
                    DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path entry) {
                            return true;
                        }
                    };
                    stream = fs.provider().newDirectoryStream(directoryPath, (DirectoryStream.Filter<? super Path>)filter);
                }
                for (Path path : stream) {
                    BasicFileAttributes pathAttr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    if (filesOnly && !pathAttr.isRegularFile()) continue;
                    ret.add(path.toFile());
                }
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable directoryPath) {}
                }
            }
        }
        return ret;
    }
}

