/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.appwork.utils.logging2.LogSinkFileHandler;
import org.appwork.utils.logging2.LogSource;

public class LogSink
extends Logger {
    protected List<WeakReference<LogSource>> logSources = new ArrayList<WeakReference<LogSource>>();
    protected LogSinkFileHandler fileHandler = null;
    protected ConsoleHandler consoleHandler = null;
    protected Logger parent = null;

    protected LogSink(String name) {
        this(name, null);
        this.setLevel(Level.ALL);
    }

    protected LogSink(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        if (handler == null) {
            return;
        }
        super.addHandler(handler);
        if (this.fileHandler == null && handler instanceof LogSinkFileHandler) {
            this.fileHandler = (LogSinkFileHandler)handler;
        } else if (this.consoleHandler == null && handler instanceof ConsoleHandler) {
            this.consoleHandler = (ConsoleHandler)handler;
            List<LogSource> sources = this.getLogSources();
            for (LogSource source : sources) {
                source.removeHandler(this.consoleHandler);
                source.addHandler(this.consoleHandler);
            }
        }
    }

    public LogSinkFileHandler getFileHandler() {
        return this.fileHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLogSource(LogSource source) {
        if (source == null) {
            return;
        }
        List<WeakReference<LogSource>> list = this.logSources;
        synchronized (list) {
            this.logSources.add(new WeakReference<LogSource>(source));
            source.setParent(this);
            if (this.consoleHandler != null) {
                source.removeHandler(this.consoleHandler);
                source.addHandler(this.consoleHandler);
            }
        }
    }

    protected synchronized void close() {
        try {
            this.flush(FLUSH.CLOSE);
        }
        finally {
            this.closeAndRemoveFileHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void closeAndRemoveFileHandler() {
        LogSinkFileHandler fileHandler;
        block11: {
            fileHandler = this.fileHandler;
            try {
                if (fileHandler == null) break block11;
                super.removeHandler(fileHandler);
            }
            catch (Throwable throwable) {
                try {
                    if (fileHandler == null) throw throwable;
                    fileHandler.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throw throwable;
                }
                finally {
                    this.fileHandler = null;
                }
            }
        }
        try {
            if (fileHandler == null) return;
            fileHandler.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        finally {
            this.fileHandler = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.flush(FLUSH.FINALIZE);
            }
            finally {
                this.closeAndRemoveFileHandler();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void flush(FLUSH flush) {
        try {
            for (LogSource source : this.getLogSources()) {
                switch (flush) {
                    case FORCE: {
                        source.flush();
                        break;
                    }
                    case TIMEOUT: {
                        if (!source.isAllowTimeoutFlush()) break;
                        source.flush();
                        break;
                    }
                    case CLOSE: {
                        if (!source.isFlushOnClose() && !source.isFlushOnFinalize()) break;
                        source.flush();
                        break;
                    }
                    case FINALIZE: {
                        if (!source.isFlushOnFinalize()) break;
                        source.flush();
                    }
                }
            }
        }
        finally {
            LogSinkFileHandler fileHandler = this.fileHandler;
            if (fileHandler != null) {
                fileHandler.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LogSource> getLogSources() {
        ArrayList<LogSource> sources = new ArrayList<LogSource>();
        List<WeakReference<LogSource>> list = this.logSources;
        synchronized (list) {
            Iterator<WeakReference<LogSource>> it = this.logSources.iterator();
            while (it.hasNext()) {
                WeakReference<LogSource> next = it.next();
                LogSource item = (LogSource)next.get();
                if (item == null || item.isClosed()) {
                    it.remove();
                    continue;
                }
                sources.add(item);
            }
        }
        return sources;
    }

    @Override
    public Logger getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasLogSources() {
        List<WeakReference<LogSource>> list = this.logSources;
        synchronized (list) {
            if (this.logSources.size() > 0) {
                for (WeakReference<LogSource> next : this.logSources) {
                    LogSource item = (LogSource)next.get();
                    if (item == null || item.isClosed()) continue;
                    return true;
                }
                this.logSources.clear();
            }
        }
        return false;
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        if (handler == null) {
            return;
        }
        super.removeHandler(handler);
        if (this.fileHandler != null && this.fileHandler == handler) {
            this.close();
        } else if (this.consoleHandler != null && handler == this.consoleHandler) {
            List<LogSource> sources = this.getLogSources();
            for (LogSource source : sources) {
                source.removeHandler(this.consoleHandler);
            }
            this.consoleHandler = null;
        }
    }

    @Override
    public void setParent(Logger parent) {
        this.parent = parent;
    }

    public static enum FLUSH {
        FINALIZE,
        CLOSE,
        FORCE,
        TIMEOUT;

    }
}

