/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2.extmanager;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;

public class ExtLogManager
extends LogManager {
    public static String[] WHITELIST = new String[]{"de.btobastian", "org.fourthline", "org.mongo", "com.mongo", "javax.mail", "com.sun.xml.internal.messaging.saaj"};
    public static String[] BLACKLIST = new String[]{"org.mongodb.driver", "org.bson.ObjectId", "org.mongodb.diagnostics", "com.mongodb.diagnostics", "com.mongodb.driver", "org.fourthline", "org.fourthline.cling.registry.Registry", "org.fourthline.cling.model.message.header", "org.fourthline.cling.model.message.UpnpHeaders", "org.fourthline.cling.transport"};
    private LoggerFactory loggerFactory = null;

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(LoggerFactory LoggerFactory2) {
        this.loggerFactory = LoggerFactory2;
    }

    public ExtLogManager() throws ClassNotFoundException {
        String classLoaderID = this.getClass().getClassLoader().toString();
        String boundClassloader = System.getProperty("extlogmanager.avoidsystemclassloader.hack", classLoaderID);
        if (!classLoaderID.equals(boundClassloader)) {
            throw new ClassNotFoundException("bound classloader:" + boundClassloader + "|current classloader:" + classLoaderID);
        }
    }

    @Override
    public boolean addLogger(final Logger logger) {
        if (logger != null) {
            String name = logger.getName();
            if ("sun.util.logging.resources.logging".equals(logger.getResourceBundleName()) && this.loggerFactory != null) {
                for (String w : WHITELIST) {
                    if (!name.startsWith(w)) continue;
                    System.out.println("Redirect Logger (WL): " + name);
                    return false;
                }
            }
            if (!(logger instanceof LogSource)) {
                logger.setLevel(Level.INFO);
                logger.addHandler(new Handler(){
                    private LogSource del;
                    {
                        this.setLevel(Level.INFO);
                    }

                    @Override
                    public void publish(LogRecord record) {
                        this.ensureLogger(logger);
                        if (this.del != null) {
                            this.del.log(record);
                        } else {
                            System.out.println(record.getMessage());
                        }
                    }

                    protected void ensureLogger(Logger logger2) {
                        if (this.del == null && ExtLogManager.this.loggerFactory != null) {
                            String name = logger2.getName();
                            if (name == null || name.trim().length() == 0) {
                                name = logger2.toString();
                            }
                            this.del = ExtLogManager.this.loggerFactory.getLogger(name);
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                });
            }
        }
        boolean ret = super.addLogger(logger);
        return ret;
    }

    @Override
    public synchronized Logger getLogger(String name) {
        if (this.loggerFactory != null) {
            for (String b : BLACKLIST) {
                if (!name.startsWith(b)) continue;
                LoggerFactory.getDefaultLogger().finer("Ignored (BL): " + name);
                Logger ret = super.getLogger(name);
                if (ret != null) {
                    ret.setLevel(Level.OFF);
                }
                return ret;
            }
            for (String w : WHITELIST) {
                if (!name.startsWith(w)) continue;
                LoggerFactory.getDefaultLogger().finer("Redirect Logger (WL): " + name);
                return this.loggerFactory.getLogger(name);
            }
        }
        LoggerFactory.getDefaultLogger().finer("Ignored: " + name);
        Logger ret = super.getLogger(name);
        if (ret != null) {
            ret.setLevel(Level.OFF);
        }
        return ret;
    }
}

