/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.websocket;

import org.appwork.utils.formatter.HexFormatter;

public class WebSocketFrameHeader {
    private final boolean fin;
    private final OP_CODE opCode;
    private final long payloadLength;
    private final byte[] mask;

    public boolean isFin() {
        return this.fin;
    }

    public OP_CODE getOpcode() {
        return this.opCode;
    }

    public boolean hasPayLoad() {
        return this.getPayloadLength() > 0L;
    }

    public long getPayloadLength() {
        return this.payloadLength;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public byte[] getBytes() {
        int length = 1;
        length = this.payloadLength <= 125L ? ++length : (this.payloadLength > 125L && this.payloadLength <= 65535L ? (length += 3) : (length += 9));
        if (this.mask != null) {
            length += 4;
        }
        int writeIndex = 0;
        byte[] ret = new byte[length];
        ret[writeIndex++] = (byte)((this.isFin() ? 128 : 0) + (this.getOpcode().getOpCode() & 0xFF));
        if (this.payloadLength <= 125L) {
            ret[writeIndex++] = (byte)((long)(this.mask != null ? 128 : 0) + (Math.max(0L, this.payloadLength) & 0xFFL));
        } else if (this.payloadLength > 125L && this.payloadLength <= 65535L) {
            ret[writeIndex++] = (byte)((this.mask != null ? 128 : 0) + 126);
            ret[writeIndex++] = (byte)(this.payloadLength >>> 8 & 0xFFL);
            ret[writeIndex++] = (byte)(this.payloadLength >>> 0 & 0xFFL);
        } else {
            ret[writeIndex++] = (byte)((this.mask != null ? 128 : 0) + 127);
            for (int shift = 56; shift >= 0; shift -= 8) {
                ret[writeIndex++] = (byte)(this.payloadLength >>> shift & 0xFFL);
            }
        }
        if (this.mask != null) {
            ret[writeIndex++] = this.mask[0];
            ret[writeIndex++] = this.mask[1];
            ret[writeIndex++] = this.mask[2];
            ret[writeIndex++] = this.mask[3];
        }
        return ret;
    }

    public WebSocketFrameHeader(boolean fin, OP_CODE opCode, long payloadLength, byte[] mask) {
        this.fin = fin;
        this.opCode = opCode;
        this.payloadLength = payloadLength;
        this.mask = mask;
        if (mask != null && mask.length != 4) {
            throw new IllegalArgumentException("mask length must be 4 bytes!");
        }
    }

    public WebSocketFrameHeader(boolean fin, OP_CODE opCode, long payloadLength) {
        this(fin, opCode, payloadLength, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fin:").append(this.isFin());
        sb.append("|OpCode:").append((Object)this.getOpcode());
        if (this.getMask() != null) {
            sb.append("|Mask:").append(HexFormatter.byteArrayToHex(this.getMask()));
        }
        sb.append("|PayLoadLength:" + this.getPayloadLength());
        return sb.toString();
    }

    public static enum OP_CODE {
        CONTINUATION(0),
        UTF8_TEXT(1),
        BINARY(2),
        CLOSE(8),
        PING(9),
        PONG(10);

        private final int opCode;

        final int getOpCode() {
            return this.opCode;
        }

        private OP_CODE(int opCode) {
            this.opCode = opCode;
        }

        static OP_CODE get(int opCode) {
            for (OP_CODE value : OP_CODE.values()) {
                if (value.getOpCode() != opCode) continue;
                return value;
            }
            return null;
        }
    }
}

