/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.os.DesktopSupportJavaDesktop;
import org.appwork.utils.processes.ProcessBuilderFactory;

public class DesktopSupportMac
extends DesktopSupportJavaDesktop {
    @Override
    public boolean isBrowseURLSupported() {
        return true;
    }

    @Override
    public void browseURL(URL url) throws IOException, URISyntaxException {
        try {
            super.browseURL(url);
        }
        catch (Throwable e) {
            try {
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url.toExternalForm());
            }
            catch (Throwable ignore) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean reboot(boolean force, int waitms) throws InterruptedException {
        if (force) {
            try {
                ProcessBuilderFactory.runCommand("sudo", "reboot");
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            return true;
        }
        try {
            ProcessBuilderFactory.runCommand("/usr/bin/osascript", "-e", "tell application \"System Events\" restart");
            return true;
        }
        catch (Exception e) {
            LogV3.log(e);
            return false;
        }
    }

    @Override
    public boolean shutdown(boolean force) {
        if (force) {
            try {
                ProcessBuilderFactory.runCommand("sudo", "shutdown", "-p", "now");
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            try {
                ProcessBuilderFactory.runCommand("sudo", "shutdown", "-h", "now");
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            return true;
        }
        try {
            ProcessBuilderFactory.runCommand("/usr/bin/osascript", "-e", "tell application \"Finder\" to shut down");
            return true;
        }
        catch (Exception e) {
            LogV3.log(e);
            return false;
        }
    }

    @Override
    public int getPrefixLength(String pathname) {
        if (pathname.length() == 0) {
            return 0;
        }
        return pathname.charAt(0) == '/' ? 1 : 0;
    }

    @Override
    public boolean standby() {
        try {
            ProcessBuilderFactory.runCommand("/usr/bin/osascript", "-e", "tell application \"Finder\" to sleep");
            return true;
        }
        catch (Exception e) {
            LogV3.log(e);
            LogV3.info("no standby support, use shutdown");
            return false;
        }
    }

    @Override
    public boolean hibernate() {
        LogV3.info("no hibernate support, use shutdown");
        return false;
    }
}

