/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Regex;

public class HTMLParser {
    public static List<String> findUrls(String source) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (String link : new Regex(source, "\\(?\\b(ftp://|https?://)[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]").getColumn(-1)) {
                try {
                    if (link != null) {
                        link = link.trim();
                    }
                    new URL(link);
                    if (ret.contains(link)) continue;
                    ret.add(link);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            LogV3.log(e);
        }
        return HTMLParser.removeDuplicates(ret);
    }

    public static List<String> removeDuplicates(List<String> links) {
        ArrayList<String> tmplinks = new ArrayList<String>();
        if (links == null || links.size() == 0) {
            return tmplinks;
        }
        for (String link : links) {
            if (link.contains("...")) {
                String check = link.substring(0, link.indexOf("..."));
                String found = link;
                for (String link2 : links) {
                    if (!link2.startsWith(check) || link2.contains("...")) continue;
                    found = link2;
                    break;
                }
                if (tmplinks.contains(found)) continue;
                tmplinks.add(found);
                continue;
            }
            tmplinks.add(link);
        }
        return tmplinks;
    }
}

