/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import javax.swing.SpinnerNumberModel;

public class SpinnerFilesizeModel
extends SpinnerNumberModel {
    private static final long serialVersionUID = 8892296746389046229L;

    public SpinnerFilesizeModel(int value, int minimum, int maximum) {
        super(value, minimum, maximum, 1);
    }

    @Override
    public Object getNextValue() {
        try {
            int step = this.getStep();
            Integer ret = ((Number)super.getNextValue()).intValue() / step;
            return ret * step;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getStep() {
        int step;
        Number value = (Number)this.getValue();
        if (value.intValue() < 10000) {
            step = 1000;
        } else {
            int base = (int)Math.pow(1000.0, (int)(Math.log(value.intValue()) / Math.log(1000.0)));
            step = value.intValue() / base;
            step = (int)(Math.log(step) / Math.log(10.0));
            step = (int)Math.pow(10.0, step) / 10;
            step = Math.max(step * base, base / 10);
        }
        this.setStepSize(step);
        return step;
    }

    @Override
    public Object getPreviousValue() {
        try {
            int step = this.getStep();
            Integer ret = ((Number)super.getPreviousValue()).intValue() / step;
            return ret * step;
        }
        catch (Exception e) {
            return null;
        }
    }
}

