/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import com.btr.proxy.search.ProxySearch;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.storage.config.JsonConfig;
import org.appwork.updatesys.client.defaultimpl.http.SortedHashSet;
import org.appwork.updatesys.client.http.ProxySelectorException;
import org.appwork.updatesys.client.http.ProxySelectorInterface;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ProxyDialog;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.locale.T;
import org.jdownloader.updatev2.FilterList;
import org.jdownloader.updatev2.InternetConnectionSettings;
import org.jdownloader.updatev2.ProxyData;
import org.jdownloader.updatev2.UpdateSettings;

public class ProxySelector
implements ProxySelectorInterface {
    private static final ProxySelector INSTANCE = new ProxySelector();
    private UpdateSettings config;
    private HTTPProxy workingProxy;
    private List<HTTPProxy> systemProxies;
    private java.net.ProxySelector myProxySelector;
    private InternetConnectionSettings inetSettings;
    private final AtomicLong lastSuccessfulConnection = new AtomicLong(-1L);
    private UpdateManager updateManager;
    private HTTPProxy latestUserProxy;
    private boolean useProxyVole = true;
    private static Object PROXYVOLE_LOCK = new Object();
    private Map<Thread, Boolean> askAuthDialogPermissionMap = new ConcurrentHashMap<Thread, Boolean>();
    private Map<Thread, Boolean> askNoConnectionDialogPermissionMap = new ConcurrentHashMap<Thread, Boolean>();

    public static ProxySelector getInstance() {
        return INSTANCE;
    }

    private ProxySelector() {
        try {
            this.systemProxies = HTTPProxy.getFromSystemProperties();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.config = JsonConfig.create(UpdateSettings.class);
        this.inetSettings = JsonConfig.create("cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
    }

    @Override
    public boolean onSuccess(Object context, URL url, HTTPProxy proxy) {
        this.updateLastSuccessfulConnectionTimeout();
        this.workingProxy = proxy;
        return true;
    }

    private synchronized long getLastSuccessfulConnection() {
        long last = this.lastSuccessfulConnection.get();
        if (last <= 0L) {
            last = this.config.getLastSuccessfulConnection();
            if (last <= 0L) {
                last = System.currentTimeMillis();
                this.config.setLastSuccessfulConnection(last);
            }
            this.lastSuccessfulConnection.set(last);
        }
        return last;
    }

    private synchronized void updateLastSuccessfulConnectionTimeout() {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = this.lastSuccessfulConnection.getAndSet(now)) > 43200000L) {
            this.config.setLastSuccessfulConnection(now);
        }
    }

    protected String _getTranslationProxyDialogAuthRequired(URL url) {
        return T.T.TranslationProxyDialogAuthRequired(url.getHost());
    }

    protected String _getTranslationProxyDialogNoConnection(URL url) {
        return T.T.TranslationProxyDialogNoConnection(url.getHost());
    }

    protected String _getTranslationProxyDialogTitleAuthRequired(URL ur) {
        return _AWU.T.proxydialog_title();
    }

    protected String _getTranslationProxyDialogTitleNoConnection(URL ur) {
        return _AWU.T.proxydialog_title();
    }

    @Override
    public HTTPProxy onNoConnection(Object context, List<HTTPProxy> proxyList, URL url) throws ProxySelectorException {
        for (HTTPProxy p : proxyList) {
            if (this.latestUserProxy == null || !this.latestUserProxy.equals(p)) continue;
            this.latestUserProxy = null;
        }
        long sincelastSuccess = System.currentTimeMillis() - this.getLastSuccessfulConnection();
        boolean guiVisible = false;
        try {
            UpdateManager lUpdateManager = this.getUpdateManager();
            guiVisible = lUpdateManager != null && lUpdateManager.isGuiVisible();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!guiVisible && sincelastSuccess <= 259200000L || !this.config.isProxyDialogOnNoConnectionEnabled()) {
            return null;
        }
        if (!this.isDialogAskNoConnectionAllowedForCurrentThread(context)) {
            return null;
        }
        ProxyDialog pd = null;
        pd = new ProxyDialog(proxyList.size() == 0 ? null : proxyList.get(0), this._getTranslationProxyDialogNoConnection(url));
        pd.setTitle(this._getTranslationProxyDialogTitleNoConnection(url));
        try {
            return this.dialog(pd);
        }
        catch (DialogClosedException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        catch (DialogCanceledException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPProxy dialog(ProxyDialog pd) throws DialogClosedException, DialogCanceledException {
        if (this.latestUserProxy != null) {
            return this.latestUserProxy;
        }
        ProxySelector proxySelector = this;
        synchronized (proxySelector) {
            if (this.latestUserProxy != null) {
                return this.latestUserProxy;
            }
            Dialog.getInstance().showDialog(pd);
            HTTPProxy newProxy = pd.getProxy();
            if (newProxy != null) {
                this.latestUserProxy = newProxy;
            }
            return newProxy;
        }
    }

    @Override
    public List<HTTPProxy> getProxies(Object context, URL url) {
        HTTPProxy knownWorkingProxy = this.workingProxy;
        try {
            UpdateManager lUpdateManager = this.getUpdateManager();
            if (lUpdateManager != null && lUpdateManager.hasJDHandler()) {
                List<HTTPProxy> ret = lUpdateManager.selectProxy(url);
                if (ret != null && knownWorkingProxy != null) {
                    ret.remove(knownWorkingProxy);
                    ret.add(0, knownWorkingProxy);
                }
                return ret;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        SortedHashSet<HTTPProxy> lst = new SortedHashSet<HTTPProxy>();
        if (knownWorkingProxy != null) {
            lst.add(knownWorkingProxy);
            return lst;
        }
        InternetConnectionSettings config = JsonConfig.create("cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class);
        ArrayList<ProxyData> customProxyList = config.getCustomProxyList();
        if (lst != null && customProxyList != null) {
            for (final ProxyData pd : customProxyList) {
                FilterList filter;
                if (!pd.isEnabled() || (filter = pd.getFilter()) != null && !filter.validate(url.getHost(), null)) continue;
                if (pd.isPac()) {
                    try {
                        List<Proxy> proxies;
                        PacProxySelector selector;
                        PacScriptSource pacSource;
                        if (StringUtils.equalsIgnoreCase(pd.getProxy().getAddress(), "pac://")) {
                            pacSource = new PacScriptSource(){

                                @Override
                                public String getScriptContent() throws IOException {
                                    return JsonConfig.create("cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class).getLocalPacScript();
                                }

                                @Override
                                public boolean isScriptValid() {
                                    try {
                                        String script = this.getScriptContent();
                                        if (script == null || script.trim().length() == 0) {
                                            System.out.println("PAC script is empty. Skipping script!");
                                            return false;
                                        }
                                        if (script.indexOf("FindProxyForURL") == -1) {
                                            System.out.println("PAC script entry point FindProxyForURL not found. Skipping script!");
                                            return false;
                                        }
                                        return true;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        return false;
                                    }
                                }
                            };
                            selector = new PacProxySelector(pacSource);
                            proxies = selector.select(url.toURI());
                            this.collect(lst, pd, proxies);
                            continue;
                        }
                        if (pd.getProxy().getAddress().toLowerCase(Locale.ENGLISH).startsWith("pac://")) {
                            pacSource = new PacScriptSource(){

                                @Override
                                public String getScriptContent() throws IOException {
                                    return URLDecoder.decode(pd.getProxy().getAddress().substring(6), "UTF-8");
                                }

                                @Override
                                public boolean isScriptValid() {
                                    try {
                                        String script = this.getScriptContent();
                                        if (script == null || script.trim().length() == 0) {
                                            System.out.println("PAC script is empty. Skipping script!");
                                            return false;
                                        }
                                        if (script.indexOf("FindProxyForURL") == -1) {
                                            System.out.println("PAC script entry point FindProxyForURL not found. Skipping script!");
                                            return false;
                                        }
                                        return true;
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        return false;
                                    }
                                }
                            };
                            selector = new PacProxySelector(pacSource);
                            proxies = selector.select(url.toURI());
                            this.collect(lst, pd, proxies);
                            continue;
                        }
                        PacProxySelector selector2 = new PacProxySelector(new UrlPacScriptSource(pd.getProxy().getAddress()));
                        List<Proxy> proxies2 = selector2.select(url.toURI());
                        this.collect(lst, pd, proxies2);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                HTTPProxy proxyTemplate = HTTPProxy.getHTTPProxy(pd.getProxy());
                if (proxyTemplate == null) continue;
                lst.add(proxyTemplate);
            }
        }
        try {
            if (this.useProxyVole && this.getMyProxySelector() != null) {
                List<Proxy> proxy = this.getMyProxySelector().select(url.toURI());
                this.collect(lst, null, proxy);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.systemProxies != null) {
            for (HTTPProxy p : this.systemProxies) {
                lst.add(p);
            }
        }
        lst.add(HTTPProxy.NONE);
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.net.ProxySelector getMyProxySelector() {
        long t;
        if (!this.useProxyVole) {
            return null;
        }
        if (this.myProxySelector != null) {
            return this.myProxySelector;
        }
        Object object = PROXYVOLE_LOCK;
        synchronized (object) {
            t = System.currentTimeMillis();
            if (this.inetSettings.isProxyVoleAutodetectionEnabled()) {
                File crashTest = Application.getTempResource("proxyVoleRunningUpdater");
                if (crashTest.exists()) {
                    System.err.println("Detected ProxyVole Crash!");
                } else {
                    try {
                        crashTest.createNewFile();
                        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
                        this.myProxySelector = proxySearch.getProxySelector();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    finally {
                        crashTest.delete();
                    }
                }
            }
        }
        if (this.myProxySelector == null) {
            this.useProxyVole = false;
        }
        System.out.println("UpdateClient Proxy Vole " + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        return this.myProxySelector;
    }

    protected HTTPProxy updateNTLMProxyAuth(HTTPProxy usedProxy, List<String> proxyAuths) {
        if (proxyAuths != null) {
            for (String authMethod : proxyAuths) {
                if (!"NTLM".equalsIgnoreCase(authMethod)) continue;
                if (usedProxy.isPreferNativeImplementation()) break;
                usedProxy.setPreferNativeImplementation(true);
                return usedProxy;
            }
        }
        return null;
    }

    @Override
    public HTTPProxy updateProxyAuth(Object context, int retries, HTTPProxy usedProxy, List<String> proxyAuths, URL url) throws ProxySelectorException {
        HTTPProxy ret;
        if (this.latestUserProxy != null && this.latestUserProxy.equals(usedProxy)) {
            this.latestUserProxy = null;
        }
        if ((ret = this.updateNTLMProxyAuth(usedProxy, proxyAuths)) != null) {
            return ret;
        }
        if (proxyAuths != null && proxyAuths.size() > 0) {
            try {
                UpdateManager lUpdateManager = this.getUpdateManager();
                if (lUpdateManager != null && lUpdateManager.hasJDHandler() && (ret = lUpdateManager.updateProxyAuth(retries, usedProxy, proxyAuths, url)) != null && ret.equals(usedProxy)) {
                    ret = null;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (ret == null) {
                if (!this.isDialogAskAuthRequiredAllowedForCurrentThread(context)) {
                    return null;
                }
                try {
                    ProxyDialog pd = null;
                    pd = new ProxyDialog(usedProxy, this._getTranslationProxyDialogAuthRequired(url));
                    pd.setTitle(this._getTranslationProxyDialogTitleAuthRequired(url));
                    pd.setAuthRequired(true);
                    ret = this.dialog(pd);
                }
                catch (DialogClosedException e) {
                    LoggerFactory.getDefaultLogger().log(e);
                }
                catch (DialogCanceledException e) {
                    LoggerFactory.getDefaultLogger().log(e);
                }
            }
            return ret;
        }
        return this.onNoConnection(context, this.getProxies(context, url), url);
    }

    public void collect(List<HTTPProxy> lst, ProxyData pd, List<Proxy> proxies) {
        if (proxies != null) {
            for (Proxy p : proxies) {
                HTTPProxy proxyTemplate = null;
                switch (p.type()) {
                    case DIRECT: {
                        if (p.address() == null) {
                            proxyTemplate = new HTTPProxy(HTTPProxy.TYPE.NONE);
                            break;
                        }
                        proxyTemplate = new HTTPProxy(((InetSocketAddress)p.address()).getAddress());
                        break;
                    }
                    case HTTP: {
                        proxyTemplate = new HTTPProxy(HTTPProxy.TYPE.HTTP, ((InetSocketAddress)p.address()).getHostName(), ((InetSocketAddress)p.address()).getPort());
                        break;
                    }
                    case SOCKS: {
                        proxyTemplate = new HTTPProxy(HTTPProxy.TYPE.SOCKS5, ((InetSocketAddress)p.address()).getHostName(), ((InetSocketAddress)p.address()).getPort());
                    }
                }
                if (pd != null) {
                    proxyTemplate.setUser(pd.getProxy().getUsername());
                    proxyTemplate.setPass(pd.getProxy().getPassword());
                    proxyTemplate.setConnectMethodPrefered(pd.getProxy().isConnectMethodPrefered());
                    proxyTemplate.setPreferNativeImplementation(pd.getProxy().isPreferNativeImplementation());
                }
                if (pd != null && !pd.isEnabled()) continue;
                lst.add(proxyTemplate);
            }
        }
    }

    public void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    @Override
    public boolean setDialogAskAuthRequiredAllowedForCurrentThread(boolean b) {
        return this.setDialogAskAuthRequiredAllowedForCurrentThread(Thread.currentThread(), b);
    }

    private boolean setDialogAskAuthRequiredAllowedForCurrentThread(Thread t, boolean b) {
        return Boolean.TRUE.equals(this.askAuthDialogPermissionMap.put(t, b));
    }

    @Override
    public boolean setDialogAskNoConnectionAllowedForCurrentThread(boolean b) {
        return this.setDialogAskNoConnectionAllowedForCurrentThread(Thread.currentThread(), b);
    }

    private boolean setDialogAskNoConnectionAllowedForCurrentThread(Thread t, boolean b) {
        return Boolean.TRUE.equals(this.askNoConnectionDialogPermissionMap.put(t, b));
    }

    @Override
    public boolean isDialogAskAuthRequiredAllowedForCurrentThread(Object context) {
        return this.isDialogAskAuthRequiredAllowedForCurrentThread(context, Thread.currentThread());
    }

    private boolean isDialogAskAuthRequiredAllowedForCurrentThread(Object context, Thread t) {
        Boolean b = this.askAuthDialogPermissionMap.get(t);
        return !Boolean.FALSE.equals(b);
    }

    @Override
    public boolean isDialogAskNoConnectionAllowedForCurrentThread(Object context) {
        return this.isDialogAskNoConnectionAllowedForCurrentThread(context, Thread.currentThread());
    }

    private boolean isDialogAskNoConnectionAllowedForCurrentThread(Object context, Thread t) {
        Boolean b = this.askNoConnectionDialogPermissionMap.get(t);
        return !Boolean.FALSE.equals(b);
    }
}

