/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.lastchance;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.updatesys.client.UrlModifier;
import org.appwork.updatesys.client.defaultimpl.http.HttpClientImpl;
import org.appwork.updatesys.client.defaultimpl.http.NoConnectionException;
import org.appwork.updatesys.client.defaultimpl.http.ProxySelectorImpl;
import org.appwork.updatesys.client.http.HttpClientInterface;
import org.appwork.updatesys.client.http.ProxySelectorException;
import org.appwork.updatesys.client.http.ProxySelectorInterface;
import org.appwork.updatesys.client.lastchance.LastChanceFailedException;
import org.appwork.updatesys.client.lastchance.LastChanceUtils;
import org.appwork.updatesys.transport.UpdateServerOfflineException;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.BasicHTTP.InvalidResponseCode;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.update.JDUpdateClient;
import org.jdownloader.update.ProxySelector;
import org.jdownloader.update.SelfUpdateClient;
import org.jdownloader.update.lastchance.Base64;
import org.jdownloader.update.lastchance.FailedException;
import org.jdownloader.update.lastchance.LastChanceConfig;
import org.jdownloader.update.lastchance.NoLastChanceException;
import org.jdownloader.update.locale.T;

public class LastChanceManager {
    private static final LastChanceManager INSTANCE = new LastChanceManager();
    private boolean started = false;
    private boolean finished = false;
    private volatile boolean selfTest;
    private volatile JDUpdateClient client;
    private volatile SelfUpdateClient selfClient;
    private LogInterface logger;
    private Throwable exception;
    private volatile ProxySelector proxies = null;
    private volatile boolean selfTestLastChanceFlag = false;
    private volatile boolean downloadOK;
    private final LastChanceConfig config;
    private final CopyOnWriteArrayList<UrlModifier> modifier = new CopyOnWriteArrayList();

    public static LastChanceManager getInstance() {
        return INSTANCE;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean isSelfTestLastChanceFlag() {
        return this.selfTestLastChanceFlag;
    }

    public void addModifier(UrlModifier urlModifier) {
        this.modifier.add(urlModifier);
    }

    private LastChanceManager() {
        this.config = JsonConfig.create(LastChanceConfig.class);
        System.setProperty("classloader_00000001", "org.jdownloader.update.launcher.CL2");
    }

    public synchronized void run() {
        if (this.started) {
            return;
        }
        this.started = true;
        boolean selfTest = this.isSelfTest();
        try {
            try {
                this.initProxyList();
            }
            catch (Throwable e) {
                this.log(e);
            }
            try {
                this.internalRun(selfTest);
            }
            catch (Throwable e) {
                this.log(e);
                this.exception = e;
            }
            if (this.exception != null) {
                if (selfTest) {
                    return;
                }
                if (this.exception instanceof NoConnectionException) {
                    int value = this.config.getNoConnectionCounter() + 1;
                    this.config.setNoConnectionCounter(value);
                    if (value >= 3) {
                        Dialog.getInstance().showExceptionDialog(T.T.error_last_chance_connection_title(), T.T.error_last_chance_connection_message(), this.exception);
                    }
                } else if (!(this.exception instanceof UpdateServerOfflineException) && !(this.exception instanceof ClassNotFoundException)) {
                    Dialog.getInstance().showExceptionDialog(T.T.error_last_chance_title(), T.T.error_last_chance_message(), this.exception);
                }
            } else {
                this.config.setNoConnectionCounter(0);
            }
            this.config._getStorageHandler().write();
        }
        finally {
            this.finished = true;
        }
    }

    private void initProxyList() {
        this.proxies = ProxySelector.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRun(boolean selfTest) throws IOException, FailedException, NoLastChanceException, LastChanceFailedException, NoConnectionException, UpdateServerOfflineException, ClassNotFoundException {
        File srcFile = null;
        File dstFile = null;
        try {
            srcFile = Application.getTempFile("lastChanceSrc", "lch");
            dstFile = Application.getTempFile("lastChanceDst", ".jar");
            String url = this.createLastChanceUrl(selfTest);
            try {
                new URL(url);
            }
            catch (Throwable e) {
                throw new IOException("Invalid lastChanceURL:" + url, e);
            }
            try {
                this.download(selfTest, srcFile, dstFile, url);
            }
            catch (FailedException e) {
                if (!this.downloadOK) {
                    if (Exceptions.containsInstanceOf(e, UpdateServerOfflineException.class)) {
                        throw new UpdateServerOfflineException(e);
                    }
                    throw new NoConnectionException(e);
                }
                throw e;
            }
            catch (NoLastChanceException e) {
                if (selfTest) {
                    throw e;
                }
                if (srcFile != null) {
                    srcFile.delete();
                }
                if (selfTest && dstFile != null) {
                    dstFile.delete();
                }
                return;
            }
            srcFile.delete();
            try {
                LastChanceUtils.runLastChanceInterface(dstFile, this);
            }
            catch (LastChanceFailedException e) {
                LoggerFactory.getDefaultLogger().log(e);
                if (selfTest) {
                    throw e;
                }
                LastChanceUtils.runExternal(dstFile);
            }
        }
        finally {
            if (srcFile != null) {
                srcFile.delete();
            }
            if (selfTest && dstFile != null) {
                dstFile.delete();
            }
        }
    }

    protected void download(boolean isSelfTest, File srcFile, File dstFile, String url) throws NoLastChanceException, FailedException {
        try {
            this.httpFirstTry(srcFile, dstFile, url);
            return;
        }
        catch (FailedException e) {
            if (isSelfTest) {
                throw e;
            }
            this.log(e);
            try {
                this.httpSecondTry(srcFile, dstFile, url);
                return;
            }
            catch (FailedException e1) {
                this.log(e1);
                try {
                    this.httpThirdTry(srcFile, dstFile, url, null);
                    return;
                }
                catch (FailedException e2) {
                    this.log(e2);
                    try {
                        for (HTTPProxy proxy : this.proxies.getProxies(this, new URL(url))) {
                            try {
                                this.httpThirdTry(srcFile, dstFile, url, proxy);
                                return;
                            }
                            catch (FailedException e3) {
                                this.log(e3);
                            }
                        }
                    }
                    catch (Throwable e3) {
                        LoggerFactory.getDefaultLogger().log(e3);
                    }
                    throw e;
                }
            }
        }
    }

    private void httpThirdTry(File srcFile, File dstFile, String url, HTTPProxy proxy) throws FailedException, NoLastChanceException {
        srcFile.delete();
        srcFile.getParentFile().mkdirs();
        int connectTimeout = 30000;
        int readTimeout = 60000;
        try {
            if (!LastChanceUtils.lastChanceBasicDownload(url, srcFile, 30000, 60000, proxy)) {
                throw new NoLastChanceException();
            }
            this.downloadOK = true;
            LastChanceUtils.decryptLastChanceJar(srcFile, dstFile, KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decode(this.getPublicKey()))));
        }
        catch (NoLastChanceException e) {
            throw e;
        }
        catch (Throwable e) {
            this.check404(srcFile);
            throw new FailedException(e);
        }
    }

    public void httpSecondTry(File srcFile, File dstFile, String url) throws FailedException, NoLastChanceException {
        try {
            srcFile.delete();
            srcFile.getParentFile().mkdirs();
            LogInterface logger = this.getLogger();
            HttpClientImpl httpClient = new HttpClientImpl(logger);
            final ProxySelectorImpl defaultProxySelector = new ProxySelectorImpl(logger);
            httpClient.setProxySelector(new ProxySelectorInterface(){

                @Override
                public HTTPProxy updateProxyAuth(Object context, int retries, HTTPProxy usedProxy, List<String> proxyAuths, URL url) throws ProxySelectorException {
                    try {
                        return LastChanceManager.this.proxies.updateProxyAuth(context, retries, usedProxy, proxyAuths, url);
                    }
                    catch (Throwable e) {
                        LastChanceManager.this.log(e);
                        try {
                            return defaultProxySelector.updateProxyAuth(context, retries, usedProxy, proxyAuths, url);
                        }
                        catch (Throwable e2) {
                            LastChanceManager.this.log(e2);
                            return null;
                        }
                    }
                }

                @Override
                public boolean onSuccess(Object context, URL url, HTTPProxy proxy) {
                    try {
                        return LastChanceManager.this.proxies.onSuccess(context, url, proxy);
                    }
                    catch (Throwable e) {
                        LastChanceManager.this.log(e);
                        try {
                            return defaultProxySelector.onSuccess(context, url, proxy);
                        }
                        catch (Throwable e2) {
                            LastChanceManager.this.log(e2);
                            return false;
                        }
                    }
                }

                @Override
                public HTTPProxy onNoConnection(Object context, List<HTTPProxy> proxyList, URL url) throws ProxySelectorException {
                    try {
                        return LastChanceManager.this.proxies.onNoConnection(context, proxyList, url);
                    }
                    catch (Throwable e) {
                        LastChanceManager.this.log(e);
                        try {
                            return defaultProxySelector.onNoConnection(context, proxyList, url);
                        }
                        catch (Throwable e2) {
                            LastChanceManager.this.log(e2);
                            return null;
                        }
                    }
                }

                @Override
                public List<HTTPProxy> getProxies(Object context, URL url) {
                    try {
                        return LastChanceManager.this.proxies.getProxies(context, url);
                    }
                    catch (Throwable e) {
                        LastChanceManager.this.log(e);
                        try {
                            return defaultProxySelector.getProxies(context, url);
                        }
                        catch (Throwable e2) {
                            LastChanceManager.this.log(e2);
                            ArrayList<HTTPProxy> lst = new ArrayList<HTTPProxy>();
                            lst.add(HTTPProxy.NONE);
                            return lst;
                        }
                    }
                }

                @Override
                public boolean setDialogAskAuthRequiredAllowedForCurrentThread(boolean b) {
                    return false;
                }

                @Override
                public boolean setDialogAskNoConnectionAllowedForCurrentThread(boolean b) {
                    return false;
                }

                @Override
                public boolean isDialogAskAuthRequiredAllowedForCurrentThread(Object context) {
                    return true;
                }

                @Override
                public boolean isDialogAskNoConnectionAllowedForCurrentThread(Object context) {
                    return true;
                }
            });
            httpClient.download(this, new URL(url), srcFile, null, null);
            if (!srcFile.exists() || srcFile.length() < 10L) {
                throw new WTFException();
            }
            this.downloadOK = true;
            LastChanceUtils.decryptLastChanceJar(srcFile, dstFile, KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decode(this.getPublicKey()))));
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (true) {
                try {
                    if (cause instanceof InvalidResponseCode && ((InvalidResponseCode)cause).getConnection().getResponseCode() == 404) {
                        throw new NoLastChanceException();
                    }
                }
                catch (NoLastChanceException e1) {
                    throw e1;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (cause.getCause() == null || cause.getCause() == cause) break;
                cause = cause.getCause();
            }
            this.check404(srcFile);
            throw new FailedException(e);
        }
    }

    public void httpFirstTry(File srcFile, File dstFile, String url) throws FailedException, NoLastChanceException {
        try {
            srcFile.delete();
            srcFile.getParentFile().mkdirs();
            if (this.getClient() == null) {
                throw new Exception("No Client set yet");
            }
            HttpClientInterface httpClient = this.client.getBuilder().createHTTPClient(this.client);
            httpClient.download(this, new URL(url), srcFile, null, null);
            if (!srcFile.exists() || srcFile.length() < 10L) {
                throw new WTFException();
            }
            this.downloadOK = true;
            LastChanceUtils.decryptLastChanceJar(srcFile, dstFile, KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decode(this.getPublicKey()))));
        }
        catch (Throwable e) {
            InvalidResponseCode irc = Exceptions.getInstanceof(e, InvalidResponseCode.class);
            try {
                if (irc != null && irc.getConnection().getResponseCode() == 404) {
                    throw new NoLastChanceException();
                }
            }
            catch (NoLastChanceException e1) {
                throw e1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.check404(srcFile);
            throw new FailedException(e);
        }
    }

    private void check404(File srcFile) throws NoLastChanceException {
        if (srcFile.exists() && srcFile.length() < 512000L) {
            try {
                String str = IO.readFileToString(srcFile).toLowerCase(Locale.ENGLISH);
                if (str.contains("<title>404</title>")) {
                    throw new NoLastChanceException();
                }
                if (str.contains("not found")) {
                    throw new NoLastChanceException();
                }
            }
            catch (Exception e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
    }

    private void log(Throwable e) {
        try {
            LogInterface lLogger = this.getLogger();
            if (lLogger != null) {
                lLogger.log(e);
            } else {
                e.printStackTrace();
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
    }

    private String getPublicKey() {
        JDUpdateClient lClient = this.getClient();
        String ret = null;
        if (lClient != null) {
            ret = lClient.getSetup().getPublicSignatureKey();
        }
        if (ret == null) {
            ret = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxKoqP5C4dw4Q+Tck6k+ib3Mi3GbkTKOc1mU+LhuBItSpMrc1HfCamEuL2KHl/S7vuh7Q2zi+xZWAkg/Nm2IK650/PMeDYMrsfwIJJNVtJbDUwr65W5Fu/Smn9CvOoo3+UYd+UVRdfjv81BRlPEudWjZUkJAwZV72hOcpAhmj1Y26RVuUk513EfFTTAXEbePwIPvUuzdSIFq2jH87ZDCVNebYUXOqHdNZVGlX93ipnXlYxs6Nlp84N7RtXIbtohGD/1FvCRy0vK+zXrNtOkHrVfBWCy/d9bnWSOGJ5qgFKp9yxRGQWz1fnr5uOjBhc07IpCGUfmW545GIFV/PJ1E37wIDAQAB";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileHash(File arg, String type) {
        if (arg == null) return null;
        if (!arg.exists()) return null;
        if (arg.isDirectory()) {
            return null;
        }
        FileInputStream fis = null;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(type);
            byte[] b2332 = new byte[Short.MAX_VALUE];
            fis = new FileInputStream(arg);
            int n = 0;
            while ((n = fis.read(b2332)) >= 0) {
                if (n <= 0) continue;
                md.update(b2332, 0, n);
            }
        }
        catch (Throwable e) {
            try {
                e.printStackTrace();
                String string = null;
                return string;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            fis.close();
        }
        catch (Throwable b2332) {}
        byte[] digest = md.digest();
        return LastChanceManager.byteArrayToHex(digest);
    }

    public static String byteArrayToHex(byte[] digest) {
        StringBuilder ret = new StringBuilder();
        for (byte d : digest) {
            String tmp = Integer.toHexString(d & 0xFF);
            if (tmp.length() < 2) {
                ret.append('0');
            }
            ret.append(tmp);
        }
        return ret.toString();
    }

    protected String createLastChanceUrl(boolean isSelfTest) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getAPIUrl());
        sb.append("lastchance");
        sb.append("?");
        sb.append("app=");
        sb.append(this.getAppID());
        this.addPKH(sb);
        this.addJDownloaderJarMd5(sb);
        this.addRevisions(sb);
        if (isSelfTest) {
            sb.append("&rt=ST");
            sb.append("&st=1");
        }
        String str = sb.toString();
        for (UrlModifier m : this.modifier) {
            try {
                String newStr = m.run(str);
                new URL(newStr);
                str = newStr;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    private void addRevisions(StringBuilder sb) {
        SelfUpdateClient lSelfClient;
        JDUpdateClient lClient = this.getClient();
        if (lClient != null) {
            sb.append("&rev=").append(lClient.readRevision().getId());
            sb.append("&srev=").append(lClient.readSuperRevision().getId());
        }
        if ((lSelfClient = this.getSelfClient()) != null) {
            sb.append("&urev=").append(lSelfClient.readRevision().getId());
            sb.append("&surev=").append(lSelfClient.superReadRevision().getId());
        }
    }

    private void addJDownloaderJarMd5(StringBuilder sb) {
        try {
            File file = Application.getResource("JDownloader.jar");
            if (!file.exists()) {
                file = Application.getJarFile(LastChanceManager.class);
            }
            String hash = LastChanceManager.getFileHash(file, "MD5");
            sb.append("&jh=");
            sb.append(hash);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addPKH(StringBuilder sb) {
        String publicKey;
        if (this.getClient() != null && (publicKey = this.getPublicKey()) != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("md5");
                byte[] digest = md.digest(publicKey.getBytes("UTF-8"));
                StringBuilder ret = new StringBuilder();
                ret.append("&");
                ret.append("pkh=");
                for (byte d : digest) {
                    String tmp = Integer.toHexString(d & 0xFF);
                    if (tmp.length() < 2) {
                        ret.append('0');
                    }
                    ret.append(tmp);
                }
                sb.append(ret.toString());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private String getAppID() {
        JDUpdateClient lClient = this.getClient();
        if (lClient == null) {
            return "JD";
        }
        return lClient.getSetup().getApplicationIdentifier();
    }

    private String getAPIUrl() {
        String fallBackUpdServer = "http://update.appwork.org/jcgi/";
        JDUpdateClient lClient = this.getClient();
        if (lClient == null) {
            return "http://update.appwork.org/jcgi/";
        }
        String updServer = lClient.getUpdateServer();
        if (StringUtils.isEmpty(updServer) || !updServer.startsWith("http")) {
            return "http://update.appwork.org/jcgi/";
        }
        if (!updServer.endsWith("/")) {
            updServer = updServer + "/";
        }
        return updServer;
    }

    public void setSelfTest(boolean selfTest) {
        this.selfTest = selfTest;
    }

    public boolean isSelfTest() {
        return this.selfTest;
    }

    public void setClients(JDUpdateClient client, SelfUpdateClient selfUpdateClient) {
        this.client = client;
        this.selfClient = selfUpdateClient;
    }

    public JDUpdateClient getClient() {
        return this.client;
    }

    public SelfUpdateClient getSelfClient() {
        return this.selfClient;
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public void setSelfTestLastChanceFlag(boolean b) {
        this.selfTestLastChanceFlag = b;
    }
}

