/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.Storable;
import org.appwork.utils.StringUtils;

public class FilterList
implements Storable {
    private Type type = Type.BLACKLIST;
    private volatile Pattern[][] patterns = new Pattern[2][0];
    private int size = 0;
    private volatile String[] entries;

    public FilterList() {
    }

    public FilterList(Type selectedItem, String[] lines) {
        this.type = selectedItem;
        this.size = 0;
        this.setEntries(lines);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type == null ? Type.BLACKLIST : type;
    }

    public String[] getEntries() {
        return this.entries;
    }

    public void setEntries(String[] entries) {
        this.size = 0;
        if (entries == null) {
            this.entries = new String[0];
            this.patterns = new Pattern[2][0];
        } else {
            this.entries = entries;
            Pattern[][] lPatterns = new Pattern[2][entries.length];
            Pattern[] accountPatterns = lPatterns[0];
            Pattern[] domainPatterns = lPatterns[1];
            for (int i = 0; i < entries.length; ++i) {
                String entry;
                String string = entry = entries[i] == null ? "" : entries[i].trim();
                if (entry.length() == 0 || entry.startsWith("//") || entry.startsWith("#")) {
                    domainPatterns[i] = null;
                    accountPatterns[i] = null;
                    continue;
                }
                ++this.size;
                int index = entry.lastIndexOf("@");
                if (index >= 0 && index + 1 < entry.length()) {
                    String username = entry.substring(0, index);
                    String host = entry.substring(index + 1);
                    try {
                        accountPatterns[i] = Pattern.compile(username, 2);
                    }
                    catch (Throwable e) {
                        LogV3.log(e);
                        accountPatterns[i] = Pattern.compile(".*" + Pattern.quote(username) + ".*", 2);
                    }
                    try {
                        try {
                            domainPatterns[i] = Pattern.compile(host, 2);
                        }
                        catch (PatternSyntaxException e) {
                            if (!StringUtils.containsIgnoreCase(e.getMessage(), "Dangling meta character '*'")) continue;
                            domainPatterns[i] = Pattern.compile(host.replace("*", ".*"), 2);
                        }
                    }
                    catch (Throwable e) {
                        LogV3.log(e);
                        domainPatterns[i] = Pattern.compile(".*" + Pattern.quote(host) + ".*", 2);
                    }
                    continue;
                }
                accountPatterns[i] = null;
                try {
                    try {
                        domainPatterns[i] = Pattern.compile(entry, 2);
                    }
                    catch (PatternSyntaxException e) {
                        if (!StringUtils.containsIgnoreCase(e.getMessage(), "Dangling meta character '*'")) continue;
                        domainPatterns[i] = Pattern.compile(entry.replace("*", ".*"), 2);
                    }
                    continue;
                }
                catch (Throwable e) {
                    LogV3.log(e);
                    domainPatterns[i] = Pattern.compile(".*" + Pattern.quote(entry) + ".*", 2);
                }
            }
            this.patterns = lPatterns;
        }
    }

    public boolean validate(String host, String user) {
        if (host == null) {
            host = "";
        }
        if (user == null) {
            user = "";
        }
        Pattern[][] lPatterns = this.patterns;
        int size = this.size;
        Pattern[] accountPatterns = lPatterns[0];
        Pattern[] domainPatterns = lPatterns[1];
        switch (this.type) {
            case BLACKLIST: {
                for (int i = 0; i < domainPatterns.length; ++i) {
                    Pattern domainPattern = domainPatterns[i];
                    if (domainPattern == null) continue;
                    Pattern accountPattern = accountPatterns[i];
                    if (!domainPattern.matcher(host).find() || accountPattern != null && !accountPattern.matcher(user).find()) continue;
                    return false;
                }
                return true;
            }
            case WHITELIST: {
                for (int i = 0; i < domainPatterns.length; ++i) {
                    Pattern domainPattern = domainPatterns[i];
                    if (domainPattern == null) continue;
                    Pattern accountPattern = accountPatterns[i];
                    if (!domainPattern.matcher(host).find() || accountPattern != null && !accountPattern.matcher(user).find()) continue;
                    return true;
                }
                return size == 0;
            }
        }
        throw new WTFException("Unknown Type: " + (Object)((Object)this.type));
    }

    public int size() {
        return this.size;
    }

    public static enum Type {
        WHITELIST,
        BLACKLIST;

    }
}

