/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.debug.Debug;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.freedesktop.DBus;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.CallbackHandler;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.EfficientMap;
import org.freedesktop.dbus.EfficientQueue;
import org.freedesktop.dbus.Error;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MethodCall;
import org.freedesktop.dbus.MethodReturn;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.ObjectTree;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.FatalDBusException;
import org.freedesktop.dbus.exceptions.FatalException;
import org.freedesktop.dbus.exceptions.NotConnected;

public abstract class AbstractConnection {
    protected static final int TIMEOUT = 100000;
    private static final int PENDING_MAP_INITIAL_SIZE = 10;
    static final String BUSNAME_REGEX = "^[-_a-zA-Z][-_a-zA-Z0-9]*(\\.[-_a-zA-Z][-_a-zA-Z0-9]*)*$";
    static final String CONNID_REGEX = "^:[0-9]*\\.[0-9]*$";
    static final String OBJECT_REGEX = "^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$";
    static final byte THREADCOUNT = 4;
    static final int MAX_ARRAY_LENGTH = 0x4000000;
    static final int MAX_NAME_LENGTH = 255;
    protected Map<String, ExportedObject> exportedObjects = new HashMap<String, ExportedObject>();
    private ObjectTree objectTree;
    private _globalhandler _globalhandlerreference;
    protected Map<DBusInterface, RemoteObject> importedObjects = new HashMap<DBusInterface, RemoteObject>();
    protected Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> handledSignals;
    protected EfficientMap pendingCalls;
    protected Map<MethodCall, CallbackHandler<? extends Object>> pendingCallbacks;
    protected Map<MethodCall, DBusAsyncReply<? extends Object>> pendingCallbackReplys;
    protected LinkedList<Runnable> runnables;
    protected LinkedList<_workerthread> workers;
    protected FallbackContainer fallbackcontainer;
    protected boolean _run;
    EfficientQueue outgoing;
    LinkedList<Error> pendingErrors;
    private static final Map<Thread, DBusCallInfo> infomap = new HashMap<Thread, DBusCallInfo>();
    protected _thread thread;
    protected _sender sender;
    protected Transport transport;
    protected String addr;
    protected boolean weakreferences = false;
    static final Pattern dollar_pattern = Pattern.compile("[$]");
    public static final boolean EXCEPTION_DEBUG;
    static final boolean FLOAT_SUPPORT;
    protected boolean connected = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractConnection(String string) throws DBusException {
        this._globalhandlerreference = new _globalhandler();
        Object object = this.exportedObjects;
        synchronized (object) {
            this.exportedObjects.put(null, new ExportedObject(this._globalhandlerreference, this.weakreferences));
        }
        this.handledSignals = new HashMap<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>>();
        this.pendingCalls = new EfficientMap(10);
        this.outgoing = new EfficientQueue(10);
        this.pendingCallbacks = new HashMap<MethodCall, CallbackHandler<? extends Object>>();
        this.pendingCallbackReplys = new HashMap<MethodCall, DBusAsyncReply<? extends Object>>();
        this.pendingErrors = new LinkedList();
        this.runnables = new LinkedList();
        this.workers = new LinkedList();
        this.objectTree = new ObjectTree();
        this.fallbackcontainer = new FallbackContainer();
        object = this.workers;
        synchronized (object) {
            for (int i = 0; i < 4; ++i) {
                _workerthread _workerthread2 = new _workerthread();
                _workerthread2.start();
                this.workers.add(_workerthread2);
            }
        }
        this._run = true;
        this.addr = string;
    }

    protected void listen() {
        this.thread = new _thread();
        this.thread.start();
        this.sender = new _sender();
        this.sender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeThreadCount(byte by) {
        LinkedList<_workerthread> linkedList = this.workers;
        synchronized (linkedList) {
            if (this.workers.size() > by) {
                int n = this.workers.size() - by;
                for (int i = 0; i < n; ++i) {
                    _workerthread _workerthread2 = this.workers.removeFirst();
                    _workerthread2.halt();
                }
            } else if (this.workers.size() < by) {
                int n = by - this.workers.size();
                for (int i = 0; i < n; ++i) {
                    _workerthread _workerthread3 = new _workerthread();
                    _workerthread3.start();
                    this.workers.add(_workerthread3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunnable(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.add(runnable);
            this.runnables.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getExportedObject(DBusInterface dBusInterface) throws DBusException {
        Object object = this.exportedObjects;
        synchronized (object) {
            for (String string : this.exportedObjects.keySet()) {
                if (!dBusInterface.equals(this.exportedObjects.get((Object)string).object.get())) continue;
                return string;
            }
        }
        object = this.importedObjects.get((Object)dBusInterface).objectpath;
        if (null != object) {
            return object;
        }
        throw new DBusException("Not an object exported or imported by this connection");
    }

    abstract DBusInterface getExportedObject(String var1, String var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBusCallInfo getCallInfo() {
        DBusCallInfo dBusCallInfo;
        Map<Thread, DBusCallInfo> map = infomap;
        synchronized (map) {
            dBusCallInfo = infomap.get(Thread.currentThread());
        }
        return dBusCallInfo;
    }

    public void setWeakReferences(boolean bl) {
        this.weakreferences = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(String string, DBusInterface dBusInterface) throws DBusException {
        if (null == string || "".equals(string)) {
            throw new DBusException(Gettext._("Must Specify an Object Path"));
        }
        if (!string.matches(OBJECT_REGEX) || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string);
        }
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            if (null != this.exportedObjects.get(string)) {
                throw new DBusException(Gettext._("Object already exported"));
            }
            ExportedObject exportedObject = new ExportedObject(dBusInterface, this.weakreferences);
            this.exportedObjects.put(string, exportedObject);
            this.objectTree.add(string, exportedObject, exportedObject.introspectiondata);
        }
    }

    public void addFallback(String string, DBusInterface dBusInterface) throws DBusException {
        if (null == string || "".equals(string)) {
            throw new DBusException(Gettext._("Must Specify an Object Path"));
        }
        if (!string.matches(OBJECT_REGEX) || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string);
        }
        ExportedObject exportedObject = new ExportedObject(dBusInterface, this.weakreferences);
        this.fallbackcontainer.add(string, exportedObject);
    }

    public void removeFallback(String string) {
        this.fallbackcontainer.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unExportObject(String string) {
        Map<String, ExportedObject> map = this.exportedObjects;
        synchronized (map) {
            this.exportedObjects.remove(string);
            this.objectTree.remove(string);
        }
    }

    public void sendSignal(DBusSignal dBusSignal) {
        this.queueOutgoing(dBusSignal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueOutgoing(Message message) {
        EfficientQueue efficientQueue = this.outgoing;
        synchronized (efficientQueue) {
            if (null == this.outgoing) {
                return;
            }
            this.outgoing.add(message);
            this.outgoing.notifyAll();
        }
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> clazz, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        this.removeSigHandler(new DBusMatchRule(clazz), dBusSigHandler);
    }

    public <T extends DBusSignal> void removeSigHandler(Class<T> clazz, DBusInterface dBusInterface, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        String string = this.importedObjects.get((Object)dBusInterface).objectpath;
        if (!string.matches(OBJECT_REGEX) || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string);
        }
        this.removeSigHandler(new DBusMatchRule(clazz, null, string), dBusSigHandler);
    }

    protected abstract <T extends DBusSignal> void removeSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    public <T extends DBusSignal> void addSigHandler(Class<T> clazz, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        this.addSigHandler(new DBusMatchRule(clazz), dBusSigHandler);
    }

    public <T extends DBusSignal> void addSigHandler(Class<T> clazz, DBusInterface dBusInterface, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        if (!DBusSignal.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Signal"));
        }
        String string = this.importedObjects.get((Object)dBusInterface).objectpath;
        if (!string.matches(OBJECT_REGEX) || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string);
        }
        this.addSigHandler(new DBusMatchRule(clazz, null, string), dBusSigHandler);
    }

    protected abstract <T extends DBusSignal> void addSigHandler(DBusMatchRule var1, DBusSigHandler<T> var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends DBusSignal> void addSigHandlerWithoutMatch(Class<? extends DBusSignal> clazz, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        DBusMatchRule dBusMatchRule = new DBusMatchRule(clazz);
        SignalTuple signalTuple = new SignalTuple(dBusMatchRule.getInterface(), dBusMatchRule.getMember(), dBusMatchRule.getObject(), dBusMatchRule.getSource());
        Map<SignalTuple, Vector<DBusSigHandler<? extends DBusSignal>>> map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<DBusSignal>> vector = this.handledSignals.get(signalTuple);
            if (null == vector) {
                vector = new Vector();
                vector.add(dBusSigHandler);
                this.handledSignals.put(signalTuple, vector);
            } else {
                vector.add(dBusSigHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        LinkedList<Runnable> linkedList;
        this.connected = false;
        try {
            this.handleMessage(new DBus.Local.Disconnected("/"));
        }
        catch (Exception exception) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
        }
        while (this.runnables.size() > 0) {
            linkedList = this.runnables;
            synchronized (linkedList) {
                this.runnables.notifyAll();
            }
        }
        this._run = false;
        linkedList = this.outgoing;
        synchronized (linkedList) {
            this.outgoing.notifyAll();
        }
        try {
            if (null != this.transport) {
                this.transport.disconnect();
                this.transport = null;
            }
        }
        catch (IOException iOException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
        }
        linkedList = this.workers;
        synchronized (linkedList) {
            for (_workerthread _workerthread2 : this.workers) {
                _workerthread2.halt();
            }
        }
        linkedList = this.runnables;
        synchronized (linkedList) {
            this.runnables.notifyAll();
        }
    }

    public void finalize() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBusExecutionException getError() {
        LinkedList<Error> linkedList = this.pendingErrors;
        synchronized (linkedList) {
            if (this.pendingErrors.size() == 0) {
                return null;
            }
            return this.pendingErrors.removeFirst().getException();
        }
    }

    public <A> void callWithCallback(DBusInterface dBusInterface, String string, CallbackHandler<A> callbackHandler, Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        RemoteObject remoteObject = this.importedObjects.get(dBusInterface);
        try {
            Method method = null == remoteObject.iface ? dBusInterface.getClass().getMethod(string, classArray) : remoteObject.iface.getMethod(string, classArray);
            RemoteInvocationHandler.executeRemoteMethod(remoteObject, method, this, 2, callbackHandler, objectArray);
        }
        catch (DBusExecutionException dBusExecutionException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw dBusExecutionException;
        }
        catch (Exception exception) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(exception.getMessage());
        }
    }

    public DBusAsyncReply callMethodAsync(DBusInterface dBusInterface, String string, Object ... objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        RemoteObject remoteObject = this.importedObjects.get(dBusInterface);
        try {
            Method method = null == remoteObject.iface ? dBusInterface.getClass().getMethod(string, classArray) : remoteObject.iface.getMethod(string, classArray);
            return (DBusAsyncReply)RemoteInvocationHandler.executeRemoteMethod(remoteObject, method, this, 1, null, objectArray);
        }
        catch (DBusExecutionException dBusExecutionException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw dBusExecutionException;
        }
        catch (Exception exception) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusExecutionException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(MethodCall methodCall) throws DBusException {
        Map<String, ExportedObject> map;
        ExportedObject exportedObject = null;
        Method method = null;
        DBusInterface dBusInterface = null;
        if (null == methodCall.getInterface() || methodCall.getInterface().equals("org.freedesktop.DBus.Peer") || methodCall.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            map = this.exportedObjects;
            synchronized (map) {
                exportedObject = this.exportedObjects.get(null);
            }
            if (null != exportedObject && null == exportedObject.object.get()) {
                this.unExportObject(null);
                exportedObject = null;
            }
            if (null != exportedObject) {
                method = exportedObject.methods.get(new MethodTuple(methodCall.getName(), methodCall.getSig()));
            }
            if (null != method) {
                dBusInterface = new _globalhandler(methodCall.getPath());
            } else {
                exportedObject = null;
            }
        }
        if (null == dBusInterface) {
            map = this.exportedObjects;
            synchronized (map) {
                exportedObject = this.exportedObjects.get(methodCall.getPath());
            }
            if (null != exportedObject && null == exportedObject.object.get()) {
                this.unExportObject(methodCall.getPath());
                exportedObject = null;
            }
            if (null == exportedObject) {
                exportedObject = this.fallbackcontainer.get(methodCall.getPath());
            }
            if (null == exportedObject) {
                try {
                    this.queueOutgoing(new Error(methodCall, new DBus.Error.UnknownObject(methodCall.getPath() + Gettext._(" is not an object provided by this process."))));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
                return;
            }
            method = exportedObject.methods.get(new MethodTuple(methodCall.getName(), methodCall.getSig()));
            if (null == method) {
                try {
                    this.queueOutgoing(new Error(methodCall, new DBus.Error.UnknownMethod(MessageFormat.format(Gettext._("The method `{0}.{1}' does not exist on this object."), methodCall.getInterface(), methodCall.getName()))));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
                return;
            }
            dBusInterface = exportedObject.object.get();
        }
        map = method;
        _globalhandler _globalhandler2 = dBusInterface;
        boolean bl = 1 == (methodCall.getFlags() & 1);
        DBusCallInfo dBusCallInfo = new DBusCallInfo(methodCall);
        AbstractConnection abstractConnection = this;
        this.addRunnable(new Runnable((Method)((Object)map), methodCall, abstractConnection, dBusCallInfo, _globalhandler2, bl){
            private boolean run = false;
            final /* synthetic */ Method val$me;
            final /* synthetic */ MethodCall val$m;
            final /* synthetic */ AbstractConnection val$conn;
            final /* synthetic */ DBusCallInfo val$info;
            final /* synthetic */ Object val$ob;
            final /* synthetic */ boolean val$noreply;
            {
                this.val$me = method;
                this.val$m = methodCall;
                this.val$conn = abstractConnection2;
                this.val$info = dBusCallInfo;
                this.val$ob = object;
                this.val$noreply = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                Object object;
                if (this.run) {
                    return;
                }
                this.run = true;
                try {
                    object = this.val$me.getGenericParameterTypes();
                    this.val$m.setArgs(Marshalling.deSerializeParameters(this.val$m.getParameters(), object, this.val$conn));
                }
                catch (Exception exception) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    try {
                        this.val$conn.queueOutgoing(new Error(this.val$m, new DBus.Error.UnknownMethod(Gettext._("Failure in de-serializing message: ") + exception)));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    object = infomap;
                    synchronized (object) {
                        infomap.put(Thread.currentThread(), this.val$info);
                    }
                    try {
                        object = this.val$me.invoke(this.val$ob, this.val$m.getParameters());
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        throw invocationTargetException.getCause();
                    }
                    Object object2 = infomap;
                    synchronized (object2) {
                        infomap.remove(Thread.currentThread());
                    }
                    if (!this.val$noreply) {
                        if (Void.TYPE.equals(this.val$me.getReturnType())) {
                            object2 = new MethodReturn(this.val$m, null, new Object[0]);
                        } else {
                            StringBuffer stringBuffer = new StringBuffer();
                            for (String string : Marshalling.getDBusType(this.val$me.getGenericReturnType())) {
                                stringBuffer.append(string);
                            }
                            Object[] objectArray = Marshalling.convertParameters(new Object[]{object}, new Type[]{this.val$me.getGenericReturnType()}, this.val$conn);
                            object2 = new MethodReturn(this.val$m, stringBuffer.toString(), objectArray);
                        }
                        this.val$conn.queueOutgoing((Message)object2);
                    }
                }
                catch (DBusExecutionException dBusExecutionException) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    try {
                        this.val$conn.queueOutgoing(new Error(this.val$m, dBusExecutionException));
                    }
                    catch (DBusException dBusException) {}
                }
                catch (Throwable throwable) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                    try {
                        this.val$conn.queueOutgoing(new Error(this.val$m, new DBusExecutionException(MessageFormat.format(Gettext._("Error Executing Method {0}.{1}: {2}"), this.val$m.getInterface(), this.val$m.getName(), throwable.getMessage()))));
                    }
                    catch (DBusException dBusException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final DBusSignal dBusSignal) {
        Vector<DBusSigHandler<? extends DBusSignal>> vector = new Vector<DBusSigHandler<? extends DBusSignal>>();
        Object object = this.handledSignals;
        synchronized (object) {
            Object object2 = this.handledSignals.get(new SignalTuple(dBusSignal.getInterface(), dBusSignal.getName(), null, null));
            if (null != object2) {
                vector.addAll((Collection<DBusSigHandler<? extends DBusSignal>>)object2);
            }
            if (null != (object2 = this.handledSignals.get(new SignalTuple(dBusSignal.getInterface(), dBusSignal.getName(), dBusSignal.getPath(), null)))) {
                vector.addAll((Collection<DBusSigHandler<? extends DBusSignal>>)object2);
            }
            if (null != (object2 = this.handledSignals.get(new SignalTuple(dBusSignal.getInterface(), dBusSignal.getName(), null, dBusSignal.getSource())))) {
                vector.addAll((Collection<DBusSigHandler<? extends DBusSignal>>)object2);
            }
            if (null != (object2 = this.handledSignals.get(new SignalTuple(dBusSignal.getInterface(), dBusSignal.getName(), dBusSignal.getPath(), dBusSignal.getSource())))) {
                vector.addAll((Collection<DBusSigHandler<? extends DBusSignal>>)object2);
            }
        }
        if (0 == vector.size()) {
            return;
        }
        object = this;
        for (DBusSigHandler dBusSigHandler : vector) {
            this.addRunnable(new Runnable((AbstractConnection)object, dBusSigHandler){
                private boolean run = false;
                final /* synthetic */ AbstractConnection val$conn;
                final /* synthetic */ DBusSigHandler val$h;
                {
                    this.val$conn = abstractConnection2;
                    this.val$h = dBusSigHandler;
                }

                @Override
                public synchronized void run() {
                    if (this.run) {
                        return;
                    }
                    this.run = true;
                    try {
                        DBusSignal dBusSignal2 = dBusSignal instanceof DBusSignal.internalsig || dBusSignal.getClass().equals(DBusSignal.class) ? dBusSignal.createReal(this.val$conn) : dBusSignal;
                        this.val$h.handle(dBusSignal2);
                    }
                    catch (DBusException dBusException) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        try {
                            this.val$conn.queueOutgoing(new Error(dBusSignal, new DBusExecutionException("Error handling signal " + dBusSignal.getInterface() + "." + dBusSignal.getName() + ": " + dBusException.getMessage())));
                        }
                        catch (DBusException dBusException2) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final Error error) {
        MethodCall methodCall = null;
        if (null == this.pendingCalls) {
            return;
        }
        CallbackHandler<? extends Object> callbackHandler = this.pendingCalls;
        synchronized (callbackHandler) {
            if (this.pendingCalls.contains(error.getReplySerial())) {
                methodCall = this.pendingCalls.remove(error.getReplySerial());
            }
        }
        if (null != methodCall) {
            methodCall.setReply(error);
            callbackHandler = null;
            DBusAsyncReply<? extends Object> dBusAsyncReply = null;
            Object object = this.pendingCallbacks;
            synchronized (object) {
                callbackHandler = this.pendingCallbacks.remove(methodCall);
                dBusAsyncReply = this.pendingCallbackReplys.remove(methodCall);
            }
            if (null != callbackHandler) {
                object = callbackHandler;
                this.addRunnable(new Runnable((CallbackHandler)object){
                    private boolean run = false;
                    final /* synthetic */ CallbackHandler val$fcbh;
                    {
                        this.val$fcbh = callbackHandler;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        if (this.run) {
                            return;
                        }
                        this.run = true;
                        try {
                            DBusCallInfo dBusCallInfo = new DBusCallInfo(error);
                            Map map = infomap;
                            synchronized (map) {
                                infomap.put(Thread.currentThread(), dBusCallInfo);
                            }
                            this.val$fcbh.handleError(error.getException());
                            map = infomap;
                            synchronized (map) {
                                infomap.remove(Thread.currentThread());
                            }
                        }
                        catch (Exception exception) {
                            if (EXCEPTION_DEBUG) {
                                // empty if block
                            }
                        }
                    }
                });
            }
        } else {
            callbackHandler = this.pendingErrors;
            synchronized (callbackHandler) {
                this.pendingErrors.addLast(error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(final MethodReturn methodReturn) {
        MethodCall methodCall = null;
        if (null == this.pendingCalls) {
            return;
        }
        Object object = this.pendingCalls;
        synchronized (object) {
            if (this.pendingCalls.contains(methodReturn.getReplySerial())) {
                methodCall = this.pendingCalls.remove(methodReturn.getReplySerial());
            }
        }
        if (null != methodCall) {
            methodCall.setReply(methodReturn);
            methodReturn.setCall(methodCall);
            object = null;
            DBusAsyncReply<? extends Object> dBusAsyncReply = null;
            Object object2 = this.pendingCallbacks;
            synchronized (object2) {
                object = this.pendingCallbacks.remove(methodCall);
                dBusAsyncReply = this.pendingCallbackReplys.remove(methodCall);
            }
            if (null != object) {
                object2 = object;
                DBusAsyncReply<? extends Object> dBusAsyncReply2 = dBusAsyncReply;
                this.addRunnable(new Runnable((CallbackHandler)object2, dBusAsyncReply2){
                    private boolean run = false;
                    final /* synthetic */ CallbackHandler val$fcbh;
                    final /* synthetic */ DBusAsyncReply val$fasr;
                    {
                        this.val$fcbh = callbackHandler;
                        this.val$fasr = dBusAsyncReply;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public synchronized void run() {
                        if (this.run) {
                            return;
                        }
                        this.run = true;
                        try {
                            DBusCallInfo dBusCallInfo = new DBusCallInfo(methodReturn);
                            Map map = infomap;
                            synchronized (map) {
                                infomap.put(Thread.currentThread(), dBusCallInfo);
                            }
                            this.val$fcbh.handle(RemoteInvocationHandler.convertRV(methodReturn.getSig(), methodReturn.getParameters(), this.val$fasr.getMethod(), this.val$fasr.getConnection()));
                            map = infomap;
                            synchronized (map) {
                                infomap.remove(Thread.currentThread());
                            }
                        }
                        catch (Exception exception) {
                            if (EXCEPTION_DEBUG) {
                                // empty if block
                            }
                        }
                    }
                });
            }
        } else {
            try {
                this.queueOutgoing(new Error(methodReturn, new DBusExecutionException(Gettext._("Spurious reply. No message with the given serial id was awaiting a reply."))));
            }
            catch (DBusException dBusException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sendMessage(Message message) {
        try {
            if (!this.connected) {
                throw new NotConnected(Gettext._("Disconnected"));
            }
            if (message instanceof DBusSignal) {
                ((DBusSignal)message).appendbody(this);
            }
            if (message instanceof MethodCall && 0 == (message.getFlags() & 1)) {
                if (null == this.pendingCalls) {
                    ((MethodCall)message).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext._("Disconnected")));
                } else {
                    EfficientMap efficientMap = this.pendingCalls;
                    synchronized (efficientMap) {
                        this.pendingCalls.put(message.getSerial(), (MethodCall)message);
                    }
                }
            }
            this.transport.mout.writeMessage(message);
            return;
        }
        catch (Exception exception) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            if (message instanceof MethodCall && exception instanceof NotConnected) {
                try {
                    ((MethodCall)message).setReply(new Error("org.freedesktop.DBus.Local", "org.freedesktop.DBus.Local.Disconnected", 0L, "s", Gettext._("Disconnected")));
                }
                catch (DBusException dBusException) {
                    // empty catch block
                }
            }
            if (message instanceof MethodCall && exception instanceof DBusExecutionException) {
                try {
                    ((MethodCall)message).setReply(new Error(message, exception));
                }
                catch (DBusException dBusException) {}
            } else if (message instanceof MethodCall) {
                try {
                    ((MethodCall)message).setReply(new Error(message, new DBusExecutionException(Gettext._("Message Failed to Send: ") + exception.getMessage())));
                }
                catch (DBusException dBusException) {}
            } else if (message instanceof MethodReturn) {
                try {
                    this.transport.mout.writeMessage(new Error(message, exception));
                }
                catch (IOException iOException) {
                    if (!EXCEPTION_DEBUG) {
                        // empty if block
                    }
                }
                catch (DBusException dBusException) {
                    if (EXCEPTION_DEBUG) {
                        // empty if block
                    }
                }
            }
            if (!(exception instanceof IOException)) return;
            this.disconnect();
        }
    }

    private Message readIncoming() throws DBusException {
        if (!this.connected) {
            throw new NotConnected(Gettext._("No transport present"));
        }
        Message message = null;
        try {
            message = this.transport.min.readMessage();
        }
        catch (IOException iOException) {
            throw new FatalDBusException(iOException.getMessage());
        }
        return message;
    }

    public BusAddress getAddress() throws ParseException {
        return new BusAddress(this.addr);
    }

    static {
        FLOAT_SUPPORT = null != System.getenv("DBUS_JAVA_FLOATS");
        boolean bl = EXCEPTION_DEBUG = null != System.getenv("DBUS_JAVA_EXCEPTION_DEBUG");
        if (EXCEPTION_DEBUG) {
            Debug.print((Object)"Debugging of internal exceptions enabled");
            Debug.setThrowableTraces((boolean)true);
        }
    }

    private class _sender
    extends Thread {
        public _sender() {
            this.setName("Sender");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EfficientQueue efficientQueue;
            Message message = null;
            while (AbstractConnection.this._run) {
                if (null != AbstractConnection.this.outgoing) {
                    efficientQueue = AbstractConnection.this.outgoing;
                    synchronized (efficientQueue) {
                        while (AbstractConnection.this.outgoing.size() == 0 && AbstractConnection.this._run) {
                            try {
                                AbstractConnection.this.outgoing.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (AbstractConnection.this.outgoing.size() > 0) {
                            message = AbstractConnection.this.outgoing.remove();
                        }
                    }
                }
                if (null != message) {
                    AbstractConnection.this.sendMessage(message);
                }
                message = null;
            }
            if (null != AbstractConnection.this.outgoing) {
                do {
                    EfficientQueue efficientQueue2 = efficientQueue = AbstractConnection.this.outgoing;
                    synchronized (efficientQueue2) {
                        AbstractConnection.this.outgoing = null;
                    }
                    message = !efficientQueue.isEmpty() ? efficientQueue.remove() : null;
                    AbstractConnection.this.sendMessage(message);
                } while (null != message);
            }
        }
    }

    protected class _workerthread
    extends Thread {
        private boolean _run = true;

        protected _workerthread() {
        }

        public void halt() {
            this._run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this._run) {
                Runnable runnable = null;
                LinkedList<Runnable> linkedList = AbstractConnection.this.runnables;
                synchronized (linkedList) {
                    while (AbstractConnection.this.runnables.size() == 0 && this._run) {
                        try {
                            AbstractConnection.this.runnables.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (AbstractConnection.this.runnables.size() > 0) {
                        runnable = AbstractConnection.this.runnables.removeFirst();
                    }
                }
                if (null == runnable) continue;
                runnable.run();
            }
        }
    }

    private class _globalhandler
    implements DBus.Peer,
    DBus.Introspectable {
        private String objectpath;

        public _globalhandler() {
            this.objectpath = null;
        }

        public _globalhandler(String string) {
            this.objectpath = string;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public void Ping() {
        }

        @Override
        public String Introspect() {
            ExportedObject exportedObject;
            String string = AbstractConnection.this.objectTree.Introspect(this.objectpath);
            if (null == string && null != (exportedObject = AbstractConnection.this.fallbackcontainer.get(this.objectpath))) {
                string = exportedObject.introspectiondata;
            }
            if (null == string) {
                throw new DBus.Error.UnknownObject("Introspecting on non-existant object");
            }
            return "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n" + string;
        }
    }

    protected class _thread
    extends Thread {
        public _thread() {
            this.setName("DBusConnection");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                _thread _thread2;
                Message message = null;
                while (AbstractConnection.this._run) {
                    message = null;
                    try {
                        message = AbstractConnection.this.readIncoming();
                        if (message == null) continue;
                        _thread2 = this;
                        synchronized (_thread2) {
                            this.notifyAll();
                        }
                        if (message instanceof DBusSignal) {
                            AbstractConnection.this.handleMessage((DBusSignal)message);
                        } else if (message instanceof MethodCall) {
                            AbstractConnection.this.handleMessage((MethodCall)message);
                        } else if (message instanceof MethodReturn) {
                            AbstractConnection.this.handleMessage((MethodReturn)message);
                        } else if (message instanceof Error) {
                            AbstractConnection.this.handleMessage((Error)message);
                        }
                        message = null;
                    }
                    catch (Exception exception) {
                        if (EXCEPTION_DEBUG) {
                            // empty if block
                        }
                        if (!(exception instanceof FatalException)) continue;
                        AbstractConnection.this.disconnect();
                    }
                }
                _thread2 = this;
                synchronized (_thread2) {
                    this.notifyAll();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class FallbackContainer {
        private Map<String[], ExportedObject> fallbacks = new HashMap<String[], ExportedObject>();

        protected FallbackContainer() {
        }

        public synchronized void add(String string, ExportedObject exportedObject) {
            this.fallbacks.put(string.split("/"), exportedObject);
        }

        public synchronized void remove(String string) {
            this.fallbacks.remove(string.split("/"));
        }

        public synchronized ExportedObject get(String string) {
            int n = 0;
            int n2 = 0;
            ExportedObject exportedObject = null;
            String[] stringArray = string.split("/");
            for (String[] stringArray2 : this.fallbacks.keySet()) {
                for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length && stringArray[n2].equals(stringArray2[n2]); ++n2) {
                }
                if (n2 <= 0 || n2 != stringArray2.length || n2 <= n) continue;
                exportedObject = this.fallbacks.get(stringArray2);
            }
            return exportedObject;
        }
    }
}

