/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.awt.Color;

public class ColorSpaceConverter {
    public double[] D50 = new double[]{96.4212, 100.0, 82.5188};
    public double[] D55 = new double[]{95.6797, 100.0, 92.1481};
    public double[] D65 = new double[]{95.0429, 100.0, 108.89};
    public double[] D75 = new double[]{94.9722, 100.0, 122.6394};
    public double[] whitePoint = this.D65;
    public static final double cos16 = -0.9576594803233847;
    public static final double sin16 = -0.2879033166650653;
    public static final double d160 = 0.13793103448275862;
    public static final double d3 = 0.3333333333333333;
    public static final double d24 = 0.4166666666666667;
    public double[] chromaD50 = new double[]{0.3457, 0.3585, 100.0};
    public double[] chromaD55 = new double[]{0.3324, 0.3474, 100.0};
    public double[] chromaD65 = new double[]{0.3127, 0.329, 100.0};
    public double[] chromaD75 = new double[]{0.299, 0.3149, 100.0};
    public double[] chromaWhitePoint = this.chromaD65;
    public double[][] M = new double[][]{{0.4124, 0.3576, 0.1805}, {0.2126, 0.7152, 0.0722}, {0.0193, 0.1192, 0.9505}};
    public double[][] Mi = new double[][]{{3.2406, -1.5372, -0.4986}, {-0.9689, 1.8758, 0.0415}, {0.0557, -0.204, 1.057}};

    public ColorSpaceConverter() {
        this.whitePoint = this.D65;
        this.chromaWhitePoint = this.chromaD65;
    }

    public ColorSpaceConverter(String white) {
        this.whitePoint = this.D65;
        this.chromaWhitePoint = this.chromaD65;
        if (white.equalsIgnoreCase("d50")) {
            this.whitePoint = this.D50;
            this.chromaWhitePoint = this.chromaD50;
        } else if (white.equalsIgnoreCase("d55")) {
            this.whitePoint = this.D55;
            this.chromaWhitePoint = this.chromaD55;
        } else if (white.equalsIgnoreCase("d65")) {
            this.whitePoint = this.D65;
            this.chromaWhitePoint = this.chromaD65;
        } else if (white.equalsIgnoreCase("d75")) {
            this.whitePoint = this.D75;
            this.chromaWhitePoint = this.chromaD75;
        }
    }

    public int[] HSBtoRGB(double H, double S, double B) {
        int[] result = new int[3];
        int rgb = Color.HSBtoRGB((float)H, (float)S, (float)B);
        result[0] = rgb >> 16 & 0xFF;
        result[1] = rgb >> 8 & 0xFF;
        result[2] = rgb >> 0 & 0xFF;
        return result;
    }

    public int[] HSBtoRGB(double[] HSB) {
        return this.HSBtoRGB(HSB[0], HSB[1], HSB[2]);
    }

    public int[] LABtoRGB(double L, double a, double b) {
        return this.XYZtoRGB(this.LABtoXYZ(L, a, b));
    }

    public int[] LABtoRGB(double[] Lab) {
        return this.XYZtoRGB(this.LABtoXYZ(Lab));
    }

    public double[] LABtoXYZ(double L, double a, double b) {
        double[] result = new double[3];
        double y = (L + 16.0) / 116.0;
        double y3 = y * y * y;
        double x = a / 500.0 + y;
        double x3 = x * x * x;
        double z = y - b / 200.0;
        double z3 = z * z * z;
        y = y3 > 0.008856 ? y3 : (y - 0.13793103448275862) / 7.787;
        x = x3 > 0.008856 ? x3 : (x - 0.13793103448275862) / 7.787;
        z = z3 > 0.008856 ? z3 : (z - 0.13793103448275862) / 7.787;
        result[0] = x * this.whitePoint[0];
        result[1] = y * this.whitePoint[1];
        result[2] = z * this.whitePoint[2];
        return result;
    }

    public double[] LABtoXYZ(double[] Lab) {
        return this.LABtoXYZ(Lab[0], Lab[1], Lab[2]);
    }

    public double[] RGBtoHSB(int R, int G, int B) {
        double[] result = new double[3];
        float[] hsb = new float[3];
        Color.RGBtoHSB(R, G, B, hsb);
        result[0] = hsb[0];
        result[1] = hsb[1];
        result[2] = hsb[2];
        return result;
    }

    public double[] RGBtoHSB(int[] RGB) {
        return this.RGBtoHSB(RGB[0], RGB[1], RGB[2]);
    }

    public double[] RGBtoLAB(int R, int G, int B) {
        return this.XYZtoLAB(this.RGBtoXYZ(R, G, B));
    }

    public double[] RGBtoLAB(int[] RGB) {
        return this.XYZtoLAB(this.RGBtoXYZ(RGB));
    }

    public double[] RGBtoXYZ(int R, int G, int B) {
        double[] result = new double[3];
        double r = (double)R / 255.0;
        double g = (double)G / 255.0;
        double b = (double)B / 255.0;
        r = r <= 0.04045 ? (r /= 12.92) : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.04045 ? (g /= 12.92) : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.04045 ? (b /= 12.92) : Math.pow((b + 0.055) / 1.055, 2.4);
        result[0] = (r *= 100.0) * this.M[0][0] + (g *= 100.0) * this.M[0][1] + (b *= 100.0) * this.M[0][2];
        result[1] = r * this.M[1][0] + g * this.M[1][1] + b * this.M[1][2];
        result[2] = r * this.M[2][0] + g * this.M[2][1] + b * this.M[2][2];
        return result;
    }

    public double[] RGBtoXYZ(int[] RGB) {
        return this.RGBtoXYZ(RGB[0], RGB[1], RGB[2]);
    }

    public double[] xyYtoXYZ(double x, double y, double Y) {
        double[] result = new double[3];
        if (y == 0.0) {
            result[0] = 0.0;
            result[1] = 0.0;
            result[2] = 0.0;
        } else {
            result[0] = x * Y / y;
            result[1] = Y;
            result[2] = (1.0 - x - y) * Y / y;
        }
        return result;
    }

    public double[] xyYtoXYZ(double[] xyY) {
        return this.xyYtoXYZ(xyY[0], xyY[1], xyY[2]);
    }

    public double[] XYZtoLAB(double X, double Y, double Z) {
        double x = X / this.whitePoint[0];
        double y = Y / this.whitePoint[1];
        double z = Z / this.whitePoint[2];
        x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787 * z + 0.13793103448275862;
        double[] result = new double[]{116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z)};
        return result;
    }

    public double[] XYZtoLAB(double[] XYZ) {
        return this.XYZtoLAB(XYZ[0], XYZ[1], XYZ[2]);
    }

    public int[] XYZtoRGB(double X, double Y, double Z) {
        int[] result = new int[3];
        double x = X / 100.0;
        double y = Y / 100.0;
        double z = Z / 100.0;
        double r = x * this.Mi[0][0] + y * this.Mi[0][1] + z * this.Mi[0][2];
        double g = x * this.Mi[1][0] + y * this.Mi[1][1] + z * this.Mi[1][2];
        double b = x * this.Mi[2][0] + y * this.Mi[2][1] + z * this.Mi[2][2];
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : (r *= 12.92);
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666666666667) - 0.055 : (g *= 12.92);
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666666666667) - 0.055 : (b *= 12.92);
        r = r < 0.0 ? 0.0 : r;
        g = g < 0.0 ? 0.0 : g;
        b = b < 0.0 ? 0.0 : b;
        result[0] = (int)Math.round(r * 255.0);
        result[1] = (int)Math.round(g * 255.0);
        result[2] = (int)Math.round(b * 255.0);
        return result;
    }

    public int[] XYZtoRGB(double[] XYZ) {
        return this.XYZtoRGB(XYZ[0], XYZ[1], XYZ[2]);
    }

    public double[] XYZtoxyY(double X, double Y, double Z) {
        double[] result = new double[3];
        if (X + Y + Z == 0.0) {
            result[0] = this.chromaWhitePoint[0];
            result[1] = this.chromaWhitePoint[1];
            result[2] = this.chromaWhitePoint[2];
        } else {
            result[0] = X / (X + Y + Z);
            result[1] = Y / (X + Y + Z);
            result[2] = Y;
        }
        return result;
    }

    public double[] XYZtoxyY(double[] XYZ) {
        return this.XYZtoxyY(XYZ[0], XYZ[1], XYZ[2]);
    }

    public double[] LABtoDIN99(double[] LAB) {
        double[] LABDIN99 = new double[3];
        LABDIN99[0] = 105.51 * Math.log(1.0 + 0.0158 * LAB[0]);
        if (LAB[1] == 0.0 && LAB[2] == 0.0) {
            LABDIN99[1] = 0.0;
            LABDIN99[2] = 0.0;
            return LABDIN99;
        }
        double e = LAB[1] * -0.9576594803233847 + LAB[2] * -0.2879033166650653;
        double f = 0.7 * (LAB[2] * -0.9576594803233847 - LAB[1] * -0.2879033166650653);
        double g = 0.045 * Math.sqrt(e * e + f * f);
        double k = Math.log(1.0 + g) / g;
        LABDIN99[1] = k * e;
        LABDIN99[2] = k * f;
        return LABDIN99;
    }

    public double[] RGBtoDIN99(int[] RGB) {
        return this.LABtoDIN99(this.RGBtoLAB(RGB));
    }
}

