/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.WeakHashMap;
import jd.plugins.Plugin;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.JavaSSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.jdownloader.auth.AuthenticationController;
import org.jdownloader.auth.AuthenticationInfo;
import org.jdownloader.auth.Login;
import org.jdownloader.logging.LogController;
import org.jdownloader.net.BCSSLSocketStreamFactory;

public abstract class SimpleFTP {
    private boolean binarymode = false;
    private SocketStreamInterface socket = null;
    private String dir = "/";
    private String host;
    private final LogInterface logger;
    private String latestResponseLine = null;
    private String user = null;
    private final byte[] CRLF = "\r\n".getBytes();
    private String pass = null;
    private final HTTPProxy proxy;
    private int port = -1;
    public static String FTP_ANONYMOUS_LOGIN = "anonymous";
    private TLS_MODE tlsMode = TLS_MODE.NONE;
    protected static final WeakHashMap<FTP_SERVER, Object> FTP_SERVER = new WeakHashMap();
    private static SSLSocketStreamFactory defaultSSLSocketStreamFactory = null;
    protected boolean sslTrustALL = true;
    private boolean isUTF8Enabled = false;
    protected TLS_MODE preferedTLSMode = TLS_MODE.EXPLICIT_OPTIONAL_CC_DC;

    public static String BestEncodingGuessingURLDecode(String urlCoded) throws IOException {
        List ret = Plugin.decodeURIComponentFindBestEncoding((String)urlCoded, (String[])new String[0]);
        if (ret != null && ret.size() > 0) {
            return ((String[])ret.get(0))[1];
        }
        return urlCoded;
    }

    public String getUser() {
        return this.user;
    }

    public int getReadTimeout(STATE state) {
        switch (state) {
            case CLOSING: {
                return 10000;
            }
        }
        return 30000;
    }

    public String getPass() {
        return this.pass;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public int getPort() {
        return this.port;
    }

    public HTTPProxy getProxy() {
        return this.proxy;
    }

    protected abstract Socket createSocket();

    public SimpleFTP(HTTPProxy proxy, LogInterface logger) {
        this.proxy = proxy;
        this.logger = logger != null ? logger : LoggerFactory.getDefaultLogger();
    }

    public boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        try {
            this.readLines(new int[]{200}, "could not enter ascii mode");
            if (this.binarymode) {
                this.binarymode = false;
            }
            return true;
        }
        catch (IOException e) {
            LogController.CL().log((Throwable)e);
            if (e.getMessage().contains("ascii")) {
                return false;
            }
            throw e;
        }
    }

    public boolean bin() throws IOException {
        this.sendLine("TYPE I");
        try {
            this.readLines(new int[]{200}, "could not enter binary mode");
            if (!this.binarymode) {
                this.binarymode = true;
            }
            return true;
        }
        catch (IOException e) {
            LogController.CL().log((Throwable)e);
            if (e.getMessage().contains("binary")) {
                return false;
            }
            throw e;
        }
    }

    public boolean isBinary() {
        return this.binarymode;
    }

    public void connect(String host) throws IOException {
        this.connect(host, 21);
    }

    public void connect(String host, int port) throws IOException {
        this.connect(host, port, FTP_ANONYMOUS_LOGIN, FTP_ANONYMOUS_LOGIN);
    }

    private String[] getLines(String lines) {
        String[] ret = Regex.getLines((String)lines);
        if (ret.length == 0) {
            return new String[]{lines.trim()};
        }
        return ret;
    }

    public SocketStreamInterface createSocket(InetSocketAddress address) throws IOException {
        final Socket socket = this.createSocket();
        try {
            socket.connect(address, this.getConnectTimeout());
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
        SocketStreamInterface ret = new SocketStreamInterface(){

            public Socket getSocket() {
                return socket;
            }

            public OutputStream getOutputStream() throws IOException {
                return socket.getOutputStream();
            }

            public InputStream getInputStream() throws IOException {
                return socket.getInputStream();
            }

            public void close() throws IOException {
                socket.close();
            }
        };
        switch (this.getTLSMode()) {
            case EXPLICIT_OPTIONAL_CC_DC: 
            case EXPLICIT_REQUIRED_CC_DC: {
                try {
                    return this.getSSLSocketStreamFactory().create(ret, address.getAddress().getHostAddress(), address.getPort(), true, null);
                }
                catch (IOException e) {
                    socket.close();
                    throw e;
                }
            }
        }
        return ret;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    protected void setTLSMode(TLS_MODE mode) {
        this.tlsMode = mode;
    }

    public TLS_MODE getTLSMode() {
        return this.tlsMode;
    }

    public void connect(String host, int port, String user, String pass) throws IOException {
        TLS_MODE tlsMode = this.getPreferedTLSMode();
        try {
            this.connect(host, port, user, pass, tlsMode);
        }
        catch (IOException e) {
            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"plaintext") && (TLS_MODE.EXPLICIT_OPTIONAL_CC.equals((Object)tlsMode) || TLS_MODE.EXPLICIT_OPTIONAL_CC_DC.equals((Object)tlsMode))) {
                this.logger.log((Throwable)e);
                try {
                    this.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setPreferedTLSMode(TLS_MODE.NONE);
                this.connect(host, port, user, pass, TLS_MODE.NONE);
            }
            throw e;
        }
    }

    public boolean isWrongLoginException(IOException e) {
        return StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"530 Login or Password incorrect") || StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"530 Login authentication failed");
    }

    public boolean isAnonymousOnlyLoginException(IOException e) {
        return StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"530 This FTP server is anonymous only");
    }

    public Integer getConnectionLimitByException(IOException e) {
        String msg = e.getMessage();
        if (StringUtils.containsIgnoreCase((String)msg, (String)"530 No more connection allowed")) {
            return -1;
        }
        if (StringUtils.containsIgnoreCase((String)msg, (String)"530 Stop connecting")) {
            String maxConnections = new Regex(e.getMessage(), "You have\\s*(\\d+)\\s*connections now currently opened").getMatch(0);
            if (maxConnections != null) {
                return Math.max(1, Integer.parseInt(maxConnections) - 1);
            }
            return -1;
        }
        if (StringUtils.containsIgnoreCase((String)msg, (String)"Sorry, the maximum number of clients") || StringUtils.startsWithCaseInsensitive((String)msg, (String)"421")) {
            String maxConnections = new Regex(e.getMessage(), "Sorry, the maximum number of clients \\((\\d+)\\)").getMatch(0);
            if (maxConnections != null) {
                return Math.max(1, Integer.parseInt(maxConnections) - 1);
            }
            return -1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FTP_SERVER getCurrentServerConnections() throws IOException {
        WeakHashMap<FTP_SERVER, Object> weakHashMap = FTP_SERVER;
        synchronized (weakHashMap) {
            for (FTP_SERVER entry : FTP_SERVER.keySet()) {
                if (entry.port != this.port || !StringUtils.equals((String)entry.host, (String)this.host)) continue;
                return entry;
            }
            FTP_SERVER ret = new FTP_SERVER(this.host, this.port);
            FTP_SERVER.put(ret, new Object());
            return ret;
        }
    }

    protected void connect(String host, int port, String user, String pass, TLS_MODE mode) throws IOException {
        if (this.getControlSocket() != null) {
            throw new IOException("SimpleFTP is already connected. Disconnect first.");
        }
        this.setTLSMode(TLS_MODE.NONE);
        this.isUTF8Enabled = false;
        this.user = user;
        this.pass = pass;
        this.socket = this.createSocket(new InetSocketAddress(host, port));
        this.host = host;
        this.port = port;
        this.socket.getSocket().setSoTimeout(this.getReadTimeout(STATE.CONNECTING));
        String response = this.readLines(new int[]{220}, "SimpleFTP received an unknown response when connecting to the FTP server: ");
        this.socket.getSocket().setSoTimeout(this.getReadTimeout(STATE.CONNECTED));
        switch (mode) {
            case EXPLICIT_REQUIRED_CC: 
            case EXPLICIT_OPTIONAL_CC: {
                boolean ccTLS;
                try {
                    ccTLS = this.AUTH_TLS_CC();
                }
                catch (IOException e) {
                    if (TLS_MODE.EXPLICIT_REQUIRED_CC.equals((Object)mode)) {
                        throw e;
                    }
                    this.getLogger().log((Throwable)e);
                    this.disconnect(false);
                    this.connect(host, port, user, pass, TLS_MODE.NONE);
                    return;
                }
                if (ccTLS) {
                    this.setTLSMode(mode);
                    break;
                }
                if (!TLS_MODE.EXPLICIT_REQUIRED_CC.equals((Object)mode)) break;
                throw new IOException("TLS_MODE:" + (Object)((Object)mode) + " failed!");
            }
            case EXPLICIT_OPTIONAL_CC_DC: 
            case EXPLICIT_REQUIRED_CC_DC: {
                boolean ccTLS;
                try {
                    ccTLS = this.AUTH_TLS_CC();
                }
                catch (IOException e) {
                    if (TLS_MODE.EXPLICIT_REQUIRED_CC_DC.equals((Object)mode)) {
                        throw e;
                    }
                    this.getLogger().log((Throwable)e);
                    this.disconnect(false);
                    this.connect(host, port, user, pass, TLS_MODE.NONE);
                    return;
                }
                if (ccTLS && this.AUTH_TLS_DC()) {
                    this.setTLSMode(mode);
                    break;
                }
                if (TLS_MODE.EXPLICIT_REQUIRED_CC_DC.equals((Object)mode)) {
                    throw new IOException("TLS_MODE:" + (Object)((Object)mode) + " failed!");
                }
                if (ccTLS) {
                    this.setTLSMode(TLS_MODE.EXPLICIT_OPTIONAL_CC);
                    break;
                }
                this.setTLSMode(TLS_MODE.NONE);
                break;
            }
            default: {
                this.setTLSMode(TLS_MODE.NONE);
            }
        }
        this.sendLine("USER " + user);
        response = this.readLines(new int[]{230, 331}, "SimpleFTP received an unknown response after sending the user: ");
        String[] lines = this.getLines(response);
        if (lines[lines.length - 1].startsWith("331")) {
            this.sendLine("PASS " + pass);
            response = this.readLines(new int[]{230}, "SimpleFTP was unable to log in with the supplied password: ");
        }
        this.sendLine("PWD");
        while ((response = this.readLine()).startsWith("230") || response.charAt(0) >= '9' || response.charAt(0) <= '0') {
        }
        if (!response.startsWith("257 ")) {
            throw new IOException("PWD COmmand not understood " + response);
        }
        this.dir = new Regex(response, "\"(.*)\"").getMatch(0);
        if (TLS_MODE.NONE.equals((Object)this.getTLSMode())) {
            switch (mode) {
                case EXPLICIT_OPTIONAL_CC: {
                    if (!this.AUTH_TLS_CC()) break;
                    this.setTLSMode(TLS_MODE.EXPLICIT_OPTIONAL_CC);
                    break;
                }
                case EXPLICIT_OPTIONAL_CC_DC: {
                    boolean ccTLS = this.AUTH_TLS_CC();
                    if (ccTLS && this.AUTH_TLS_DC()) {
                        this.setTLSMode(TLS_MODE.EXPLICIT_OPTIONAL_CC_DC);
                        break;
                    }
                    if (!ccTLS) break;
                    this.setTLSMode(TLS_MODE.EXPLICIT_OPTIONAL_CC);
                    break;
                }
            }
        }
    }

    private ENCODING getPathEncoding() {
        if (this.isUTF8Enabled) {
            return ENCODING.UTF8;
        }
        return ENCODING.ASCII7BIT;
    }

    public boolean cwd(String dir) throws IOException {
        if ((dir = dir.replaceAll("[\\\\|//]+?", "/")).equals(this.dir)) {
            return true;
        }
        ENCODING encoding = ENCODING.ASCII7BIT;
        this.sendLine(encoding, "CWD " + dir);
        try {
            this.readLines(encoding, new int[]{250}, "SimpleFTP was unable to change directory");
            if (!dir.endsWith("/") && !dir.endsWith("\\")) {
                dir = dir + "/";
            }
            this.dir = dir.startsWith("/") ? dir : this.dir + dir;
            return true;
        }
        catch (IOException e) {
            LogController.CL().log((Throwable)e);
            if (e.getMessage().contains("was unable to change")) {
                return false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean sendQuit) throws IOException {
        SocketStreamInterface lsocket = this.getControlSocket();
        try {
            this.socket = null;
            if (lsocket != null && sendQuit) {
                this.sendLine(ENCODING.ASCII7BIT, lsocket, "QUIT");
            }
        }
        finally {
            try {
                if (lsocket != null) {
                    lsocket.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void disconnect() throws IOException {
        this.disconnect(true);
    }

    public String pwd() throws IOException {
        int firstQuote;
        int secondQuote;
        this.sendLine("PWD");
        String dir = null;
        String response = this.readLines(new int[]{257}, null);
        if (response.startsWith("257 ") && (secondQuote = response.indexOf(34, (firstQuote = response.indexOf(34)) + 1)) > 0) {
            dir = response.substring(firstQuote + 1, secondQuote);
        }
        return dir;
    }

    public String readLine(ENCODING encoding) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int length = this.readLine(this.getControlSocket().getInputStream(), bos);
        if (length == -1) {
            throw new EOFException();
        }
        if (length == 0) {
            return null;
        }
        String line = encoding.fromBytes(bos.toByteArray());
        this.logger.info(this.host + " < " + line);
        return line;
    }

    public String readLine() throws IOException {
        return this.readLine(ENCODING.ASCII7BIT);
    }

    protected int readLine(InputStream is, OutputStream buffer) throws IOException {
        int c = 0;
        int length = 0;
        boolean CR = false;
        boolean doubleCR = false;
        while (true) {
            if ((c = is.read()) == -1) {
                if (length > 0) {
                    return length;
                }
                return -1;
            }
            if (c == 13) {
                if (CR) {
                    if (doubleCR) {
                        throw new IOException("CRCR!?");
                    }
                    doubleCR = true;
                    continue;
                }
                CR = true;
                continue;
            }
            if (c == 10) {
                if (CR) {
                    if (!doubleCR) break;
                    break;
                }
                throw new IOException("LF!?");
            }
            if (CR) {
                throw new IOException("CRXX!?");
            }
            buffer.write(c);
            ++length;
        }
        return length;
    }

    public boolean wasLatestOperationNotPermitted() {
        String latest = this.getLastestResponseLine();
        if (latest != null) {
            return StringUtils.containsIgnoreCase((String)latest, (String)"No permission") || StringUtils.containsIgnoreCase((String)latest, (String)"operation not permitted") || StringUtils.containsIgnoreCase((String)latest, (String)"Access is denied");
        }
        return false;
    }

    public String getLastestResponseLine() {
        return this.latestResponseLine;
    }

    public List<FEATURE> listFeatures() throws IOException {
        this.sendLine("FEAT");
        ArrayList<FEATURE> ret = new ArrayList<FEATURE>();
        String response = this.readLines(new int[]{211, 500, 502}, "FEAT FAILED");
        if (StringUtils.startsWithCaseInsensitive((String)response, (String)"211")) {
            String[] featureLines;
            for (String featureLine : featureLines = response.split("\r\n")) {
                String[] featureParams = new Regex(featureLine, "^ (\\w+)\\s+(.+);$").getRow(0);
                ArrayList<String> features = new ArrayList<String>();
                if (featureParams != null) {
                    String[] params;
                    for (String param : params = featureParams[1].split(";")) {
                        features.add(" " + featureParams[0] + " " + param);
                    }
                } else {
                    features.add(featureLine);
                }
                for (String feature : features) {
                    FEATURE knownFeature = FEATURE.get(feature);
                    if (knownFeature == null || ret.contains((Object)knownFeature)) continue;
                    ret.add(knownFeature);
                }
            }
        }
        return ret;
    }

    public static void setDefaultSSLSocketStreamFactory(SSLSocketStreamFactory defaultSSLSocketStreamFactory) {
        SimpleFTP.defaultSSLSocketStreamFactory = defaultSSLSocketStreamFactory;
    }

    public static SSLSocketStreamFactory getDefaultSSLSocketStreamFactory() {
        SSLSocketStreamFactory ret = defaultSSLSocketStreamFactory;
        if (ret != null) {
            return ret;
        }
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            return new BCSSLSocketStreamFactory();
        }
        return new JavaSSLSocketStreamFactory();
    }

    public void setSSLTrustALL(boolean trustALL) {
        this.sslTrustALL = trustALL;
    }

    public boolean isSSLTrustALL() {
        return this.sslTrustALL;
    }

    protected SSLSocketStreamFactory getSSLSocketStreamFactory() {
        return SimpleFTP.getDefaultSSLSocketStreamFactory();
    }

    protected boolean AUTH_TLS_CC() throws IOException {
        this.sendLine("AUTH TLS");
        String response = this.readLines(new int[]{RESPONSE_CODE.OK_234.code(), RESPONSE_CODE.FAILED_500.code(), RESPONSE_CODE.FAILED_502.code(), RESPONSE_CODE.FAILED_504.code(), RESPONSE_CODE.FAILED_530.code(), RESPONSE_CODE.FAILED_534.code()}, "AUTH_TLS FAILED");
        if (StringUtils.startsWithCaseInsensitive((String)response, (String)"234")) {
            this.socket = this.getSSLSocketStreamFactory().create(this.getControlSocket(), "", this.getPort(), true, null);
            return true;
        }
        return false;
    }

    protected boolean AUTH_TLS_DC() throws IOException {
        return this.PBSZ(0) && this.PROT(true);
    }

    protected boolean PBSZ(int size) throws IOException {
        this.sendLine("PBSZ " + size);
        String response = this.readLines(new int[]{200, 500, 502}, "PBSZ " + size + " failed");
        return StringUtils.startsWithCaseInsensitive((String)response, (String)"200");
    }

    protected boolean PROT(boolean privateFlag) throws IOException {
        this.sendLine(privateFlag ? "PROT P" : "PROT C");
        String response = this.readLines(new int[]{200, 500, 502}, privateFlag ? "PROT P" : "PROT C");
        return StringUtils.startsWithCaseInsensitive((String)response, (String)"200");
    }

    public boolean sendClientID(String id) throws IOException {
        this.sendLine("CLNT " + id);
        String response = this.readLines(new int[]{200, 500, 502}, "CNLT failed");
        return StringUtils.startsWithCaseInsensitive((String)response, (String)"200");
    }

    public boolean isUTF8() {
        return this.isUTF8Enabled;
    }

    public boolean setUTF8(boolean on) throws IOException {
        if (on) {
            this.sendLine("OPTS UTF8 ON");
        } else {
            this.sendLine("OPTS UTF8 OFF");
        }
        String response = this.readLines(new int[]{200, 500, 501, 502}, "UTF8 not supported");
        boolean ret = StringUtils.startsWithCaseInsensitive((String)response, (String)"200");
        this.isUTF8Enabled = ret && on;
        return ret;
    }

    public String readLines(int[] expectcodes, String errormsg) throws IOException {
        return this.readLines(ENCODING.ASCII7BIT, expectcodes, errormsg);
    }

    public String readLines(ENCODING encoding, int[] expectcodes, String errormsg) throws IOException {
        StringBuilder sb = new StringBuilder();
        String response = null;
        boolean multilineResponse = false;
        boolean error = true;
        int endCodeMultiLine = 0;
        block0: do {
            this.latestResponseLine = response = this.readLine(encoding);
            if (response == null) {
                if (sb.length() == 0) {
                    throw new EOFException("no response received, EOF?");
                }
                return sb.toString();
            }
            sb.append(response + "\r\n");
            error = true;
            for (int expectcode : expectcodes) {
                if (response.startsWith("" + expectcode + "-")) {
                    endCodeMultiLine = expectcode;
                    error = false;
                    multilineResponse = true;
                    continue block0;
                }
                if (multilineResponse && response.startsWith("" + endCodeMultiLine + " ")) {
                    return sb.toString();
                }
                if (!multilineResponse && response.startsWith("" + expectcode + " ")) {
                    return sb.toString();
                }
                if (!response.startsWith("" + expectcode)) continue;
                error = false;
                continue block0;
            }
        } while (!error || multilineResponse);
        if (!errormsg.endsWith(" ")) {
            sb.insert(0, ' ');
        }
        throw new IOException((errormsg != null ? errormsg : "revieved unexpected responsecode ") + sb.toString());
    }

    public long getSize(String filePath) throws IOException {
        this.sendLine(this.getPathEncoding(), "SIZE " + filePath);
        String size = null;
        try {
            size = this.readLines(new int[]{200, 213}, "SIZE failed");
        }
        catch (IOException e) {
            if (e.getMessage().contains("SIZE") || e.getMessage().contains("550")) {
                this.logger.log((Throwable)e);
                return -1L;
            }
            throw e;
        }
        String[] split = size.split(" ");
        return Long.parseLong(split[1].trim());
    }

    public long getModTime(String filePath) throws IOException {
        this.sendLine(this.getPathEncoding(), "MDTM " + filePath);
        String modTime = null;
        try {
            modTime = this.readLines(new int[]{213}, "MDTM failed");
        }
        catch (IOException e) {
            if (e.getMessage().contains("MDTM") || e.getMessage().contains("550")) {
                this.logger.log((Throwable)e);
                return -1L;
            }
            throw e;
        }
        String[] split = modTime.split(" ");
        TimeZone GMT = TimeZone.getTimeZone("GMT");
        for (String format : new String[]{"yyyyMMddHHmmss.SSS", "yyyyMMddHHmmss"}) {
            try {
                if (format.contains(".") != split[1].contains(".")) continue;
                SimpleDateFormat df = new SimpleDateFormat(format);
                df.setTimeZone(GMT);
                long ret = df.parse(split[1]).getTime();
                return ret;
            }
            catch (Exception e) {
                this.getLogger().log((Throwable)e);
            }
        }
        return -1L;
    }

    public void sendLine(ENCODING encoding, String line) throws IOException {
        this.sendLine(encoding, this.getControlSocket(), line);
    }

    public void sendLine(String line) throws IOException {
        this.sendLine(ENCODING.ASCII7BIT, this.getControlSocket(), line);
    }

    private void sendLine(ENCODING encoding, SocketStreamInterface socket, String line) throws IOException {
        if (socket != null) {
            try {
                this.logger.info(this.host + " > " + line);
                OutputStream os = socket.getOutputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write(encoding.toBytes(line));
                bos.write(this.CRLF);
                bos.writeTo(os);
                os.flush();
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
                if (socket != null) {
                    this.disconnect();
                }
                throw e;
            }
        }
    }

    public void cancelTransfer() {
        try {
            this.sendLine("ABOR");
            this.readLine();
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
        }
    }

    public InetSocketAddress pasv() throws IOException {
        this.sendLine("PASV");
        String response = this.readLines(new int[]{227}, "SimpleFTP could not request passive mode:");
        String ip = null;
        int port = -1;
        int opening = response.indexOf(40);
        int closing = response.indexOf(41, opening + 1);
        if (closing > 0) {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try {
                ip = tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken();
                port = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
                return new InetSocketAddress(ip, port);
            }
            catch (Exception e) {
                throw new IOException("SimpleFTP received bad data link information: " + response, e);
            }
        }
        throw new IOException("SimpleFTP received bad data link information: " + response);
    }

    public String getDir() {
        return this.dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String filename, File file, boolean restart) throws IOException {
        long resumePosition = 0L;
        if (!this.binarymode) {
            this.logger.info("Warning: Download in ASCII mode may fail!");
        }
        InetSocketAddress pasv = this.pasv();
        if (restart && (resumePosition = file.length()) > 0L) {
            this.sendLine("REST " + resumePosition);
            this.readLines(new int[]{350}, "Resume not supported");
        }
        InputStream input = null;
        RandomAccessFile fos = null;
        SocketStreamInterface dataSocket = null;
        try {
            long resumeAmount = resumePosition;
            dataSocket = this.createSocket(pasv);
            dataSocket.getSocket().setSoTimeout(this.getReadTimeout(STATE.DOWNLOADING));
            this.sendLine("RETR " + filename);
            input = dataSocket.getInputStream();
            fos = new RandomAccessFile(file, "rw");
            if (resumePosition > 0L) {
                fos.seek(resumePosition);
            }
            String response = this.readLines(new int[]{150, 125}, null);
            byte[] buffer = new byte[Short.MAX_VALUE];
            int bytesRead = 0;
            long counter = resumePosition;
            while ((bytesRead = input.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    this.getControlSocket().getSocket().setSoTimeout(this.getReadTimeout(STATE.CLOSING));
                    this.shutDownSocket(dataSocket);
                    input.close();
                    try {
                        response = this.readLine();
                    }
                    catch (SocketTimeoutException e) {
                        this.logger.log((Throwable)e);
                        response = "SocketTimeout because of buggy Server";
                    }
                    this.shutDownSocket(dataSocket);
                    input.close();
                    throw new InterruptedIOException();
                }
                counter += (long)bytesRead;
                if (bytesRead <= 0) continue;
                fos.write(buffer, 0, bytesRead);
            }
            this.getControlSocket().getSocket().setSoTimeout(this.getReadTimeout(STATE.CLOSING));
            this.shutDownSocket(dataSocket);
            input.close();
            try {
                response = this.readLine();
            }
            catch (SocketTimeoutException e) {
                this.logger.log((Throwable)e);
                response = "SocketTimeout because of buggy Server";
            }
            if (!response.startsWith("226")) {
                throw new IOException("Download failed: " + response);
            }
        }
        catch (SocketTimeoutException e) {
            this.logger.log((Throwable)e);
            this.sendLine("ABOR");
            this.readLine();
            this.download(filename, file);
            return;
        }
        catch (ConnectException e) {
            this.logger.log((Throwable)e);
            this.sendLine("ABOR");
            this.readLine();
            this.download(filename, file);
            return;
        }
        catch (SocketException e) {
            this.logger.log((Throwable)e);
            this.sendLine("ABOR");
            this.readLine();
            this.download(filename, file);
            return;
        }
        finally {
            try {
                input.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            this.shutDownSocket(dataSocket);
        }
    }

    public SocketStreamInterface getControlSocket() {
        return this.socket;
    }

    public void download(String filename, File file) throws IOException {
        this.download(filename, file, false);
    }

    protected String getURL(String path) {
        String auth = !StringUtils.equals((String)FTP_ANONYMOUS_LOGIN, (String)this.getUser()) || !StringUtils.equals((String)FTP_ANONYMOUS_LOGIN, (String)this.getUser()) ? this.getUser() + ":" + this.getPass() + "@" : "";
        if (StringUtils.isEmpty((String)path)) {
            return "ftp://" + auth + this.host + ":" + this.port;
        }
        if (path.startsWith("/")) {
            return "ftp://" + auth + this.host + ":" + this.port + path;
        }
        return "ftp://" + auth + this.host + ":" + this.port + "/" + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDownSocket(SocketStreamInterface dataSocket) {
        if (dataSocket != null) {
            try {
                Socket socket = dataSocket.getSocket();
                try {
                    socket.shutdownOutput();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    socket.shutdownInput();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                try {
                    dataSocket.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public SimpleFTPListEntry[] listEntries() throws IOException {
        return this.listEntries_LIST();
    }

    protected SimpleFTPListEntry[] listEntries_LIST() throws IOException {
        String[][] entries = this.LIST();
        if (entries != null) {
            String cwd = this.getDir().replaceAll(" ", "%20");
            ArrayList<SimpleFTPListEntry> ret = new ArrayList<SimpleFTPListEntry>();
            for (String[] entry : entries) {
                long size;
                boolean isFile;
                if (entry.length == 4) {
                    isFile = !"<DIR>".equalsIgnoreCase(entry[2]);
                    String name = entry[3];
                    long size2 = isFile ? Long.parseLong(entry[2]) : -1L;
                    ret.add(new SimpleFTPListEntry(isFile, name.replaceAll(" ", "%20"), cwd, size2));
                    continue;
                }
                if (entry.length != 7) continue;
                isFile = entry[0].startsWith("-");
                boolean isFolder = entry[0].startsWith("d");
                String name = entry[6];
                boolean isLinkFlag = name.contains(" -> ") ? true : entry[0].startsWith("l");
                boolean isFileFlag = isFile || !isFolder;
                long l = size = isFile ? Long.parseLong(entry[4]) : -1L;
                if (isLinkFlag) {
                    String[] link = new Regex(name, "^(.*?)\\s*->\\s*(.+)$").getRow(0);
                    ret.add(new SimpleFTPListEntry(link[0].replaceAll(" ", "%20"), link[1].replaceAll(" ", "%20"), cwd));
                    continue;
                }
                if (isFileFlag) {
                    ret.add(new SimpleFTPListEntry(true, name.replaceAll(" ", "%20"), cwd, size));
                    continue;
                }
                ret.add(new SimpleFTPListEntry(false, name.replaceAll(" ", "%20"), cwd, size));
            }
            return ret.toArray(new SimpleFTPListEntry[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[][] LIST() throws IOException {
        FTP_SERVER server = this.getCurrentServerConnections();
        SocketStreamInterface dataSocket = null;
        StringBuilder sb = new StringBuilder();
        FTP_SERVER fTP_SERVER = server;
        synchronized (fTP_SERVER) {
            InetSocketAddress pasv = this.pasv();
            this.sendLine("LIST");
            try {
                dataSocket = this.createSocket(pasv);
                this.readLines(new int[]{125, 150}, null);
                ENCODING encoding = this.getPathEncoding();
                sb.append(encoding.fromBytes(IO.readStream((int)-1, (InputStream)dataSocket.getInputStream(), (ByteArrayOutputStream)new ByteArrayOutputStream(), (boolean)false)));
            }
            catch (IOException e) {
                if (!e.getMessage().contains("550")) throw e;
                this.logger.log((Throwable)e);
                String[][] stringArray = null;
                return stringArray;
            }
            finally {
                this.shutDownSocket(dataSocket);
            }
        }
        this.readLines(new int[]{226}, null);
        String listResponse = sb.toString();
        String[][] matches = new Regex(listResponse, "([dbclps\\-]{1}[rwxsStT-]+)\\s+(\\d+)\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\s+(\\S+\\s+\\S+\\s+\\S+)\\s+(.*?)[$\r\n]+").getMatches();
        if (matches == null) return new Regex(listResponse, "(\\S+)\\s+(\\S+)\\s+(<DIR>|\\d+)\\s+(.*?)[$\r\n]+").getMatches();
        if (matches.length != 0) return matches;
        return new Regex(listResponse, "(\\S+)\\s+(\\S+)\\s+(<DIR>|\\d+)\\s+(.*?)[$\r\n]+").getMatches();
    }

    protected SimpleFTPListEntry getFileInfo_LIST(String path) throws IOException {
        String name = path.substring(path.lastIndexOf("/") + 1);
        String workingDir = path.substring(0, path.lastIndexOf("/"));
        if (!this.cwd(workingDir)) {
            return null;
        }
        ENCODING encoding = this.getPathEncoding();
        byte[] nameBytes = encoding.toBytes(name);
        for (SimpleFTPListEntry entry : this.listEntries_LIST()) {
            if (!Arrays.equals(encoding.toBytes(entry.getName()), nameBytes)) continue;
            return entry;
        }
        return null;
    }

    public SimpleFTPListEntry getFileInfo(String path) throws IOException {
        return this.getFileInfo_LIST(path);
    }

    protected void setPreferedTLSMode(TLS_MODE mode) {
        this.preferedTLSMode = mode == null ? TLS_MODE.NONE : mode;
    }

    public TLS_MODE getPreferedTLSMode() {
        return this.preferedTLSMode;
    }

    protected List<Login> getLogins(URL url) {
        ArrayList<Login> logins = new ArrayList<Login>();
        Login noPassword = null;
        if (url.getUserInfo() != null) {
            String password;
            String username;
            boolean hasPassword;
            String[] auth = url.getUserInfo().split(":");
            boolean hasUsername = auth.length > 0 && StringUtils.isNotEmpty((String)auth[0]);
            boolean bl = hasPassword = auth.length == 2 && StringUtils.isNotEmpty((String)auth[1]);
            String string = hasUsername ? auth[0] : (username = this.isAnonymousLoginSupported(url) ? FTP_ANONYMOUS_LOGIN : null);
            String string2 = hasPassword ? auth[1] : (password = this.isAnonymousLoginSupported(url) ? FTP_ANONYMOUS_LOGIN : null);
            if (username != null && password != null) {
                Login login = new Login(AuthenticationInfo.Type.FTP, url.getHost(), null, username, password, true);
                if (hasPassword) {
                    logins.add(login);
                } else {
                    noPassword = login;
                }
            }
        }
        logins.addAll(AuthenticationController.getInstance().getSortedLoginsList(url, null));
        if (noPassword != null) {
            for (Login login : logins) {
                if (!StringUtils.equals((String)login.getUsername(), (String)noPassword.getUsername())) continue;
                logins.add(noPassword);
                noPassword = null;
                break;
            }
            if (noPassword != null) {
                logins.add(0, noPassword);
            }
        }
        if (this.isAnonymousLoginSupported(url)) {
            logins.add(new Login(AuthenticationInfo.Type.FTP, url.getHost(), null, FTP_ANONYMOUS_LOGIN, FTP_ANONYMOUS_LOGIN, false));
        }
        return logins;
    }

    protected boolean isAnonymousLoginSupported(URL url) {
        return true;
    }

    public Login connect(URL url) throws IOException {
        String host = url.getHost();
        int port = url.getPort();
        if (port <= 0) {
            port = url.getDefaultPort();
        }
        ArrayList<Login> logins = new ArrayList<Login>(this.getLogins(url));
        boolean anonymousOnly = false;
        while (logins.size() > 0) {
            Login login = (Login)logins.remove(0);
            try {
                this.connect(host, port, login.getUsername(), login.getPassword());
                login.validate();
                return login;
            }
            catch (IOException e) {
                this.disconnect();
                if (logins.size() > 0 && this.isWrongLoginException(e)) {
                    this.logger.log((Throwable)e);
                    continue;
                }
                if (this.isAnonymousOnlyLoginException(e) && !anonymousOnly) {
                    anonymousOnly = true;
                    logins.clear();
                    logins.add(new Login(AuthenticationInfo.Type.FTP, url.getHost(), null, FTP_ANONYMOUS_LOGIN, FTP_ANONYMOUS_LOGIN, false));
                    this.logger.log((Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        throw new WTFException();
    }

    public static byte[] toRawBytes(String nameString) throws IOException {
        return ENCODING.ASCII7BIT.toBytes(nameString);
    }

    public class SimpleFTPListEntry {
        private final String name;
        private final String dest;
        private final long size;
        private final TYPE type;
        private final String cwd;

        public final boolean isFile() {
            return TYPE.FILE.equals((Object)this.getType());
        }

        public final boolean isDir() {
            return TYPE.DIR.equals((Object)this.getType());
        }

        public final boolean isLink() {
            return TYPE.LINK.equals((Object)this.getType());
        }

        private final TYPE getType() {
            return this.type;
        }

        public final String getName() {
            return this.name;
        }

        public final String getDest() {
            if (this.isLink()) {
                return this.getCwd() + this.dest;
            }
            return null;
        }

        public final long getSize() {
            switch (this.getType()) {
                case FILE: {
                    return this.size;
                }
                case DIR: {
                    return 0L;
                }
            }
            return -1L;
        }

        private SimpleFTPListEntry(boolean isFile, String name, String cwd, long size) {
            this.type = isFile ? TYPE.FILE : TYPE.DIR;
            this.name = name;
            this.size = size;
            this.cwd = cwd;
            this.dest = null;
        }

        private SimpleFTPListEntry(String name, String dest, String cwd) {
            this.type = TYPE.LINK;
            this.name = name;
            this.dest = dest;
            this.size = -1L;
            this.cwd = cwd;
        }

        public final URL getURL() throws IOException {
            return URLHelper.fixPathTraversal((URL)new URL(SimpleFTP.this.getURL(this.getFullPath())));
        }

        public final String getCwd() {
            return this.cwd;
        }

        public final String getFullPath() {
            String ret = this.getCwd();
            if (!ret.endsWith("/")) {
                ret = ret + "/";
            }
            ret = ret + this.getName();
            if (this.isDir() && !ret.endsWith("/")) {
                ret = ret + "/";
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.getType()) {
                case FILE: {
                    sb.append("File:");
                    break;
                }
                case DIR: {
                    sb.append("Dir:");
                    break;
                }
                case LINK: {
                    sb.append("Link:");
                }
            }
            sb.append(this.getFullPath());
            if (this.isLink()) {
                sb.append(" -> ");
                sb.append(this.getDest());
            }
            if (this.isFile()) {
                sb.append("|Size:").append(this.getSize());
            }
            try {
                sb.append("|URL:" + this.getURL().toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return sb.toString();
        }
    }

    public static enum RESPONSE_CODE {
        OK_234,
        OK_334,
        FAILED_421,
        FAILED_431,
        FAILED_501,
        FAILED_500,
        FAILED_502,
        FAILED_504,
        FAILED_530,
        FAILED_534;


        public int code() {
            return Integer.parseInt(this.name().substring(this.name().indexOf("_") + 1));
        }
    }

    protected static class FTP_SERVER {
        protected final String host;
        protected final int port;

        protected FTP_SERVER(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    public static enum TLS_MODE {
        NONE,
        EXPLICIT_OPTIONAL_CC,
        EXPLICIT_OPTIONAL_CC_DC,
        EXPLICIT_REQUIRED_CC,
        EXPLICIT_REQUIRED_CC_DC;

    }

    public static enum STATE {
        CONNECTING,
        CONNECTED,
        DOWNLOADING,
        CLOSING;

    }

    public static enum FEATURE {
        PASV,
        SIZE,
        CLNT,
        PBSZ,
        PROT,
        MDTM,
        MLST,
        MLSD,
        PROT_C("PROT C"),
        PROT_P("PROT P"),
        AUTH_TLS("AUTH TLS"),
        UTF8;

        private final String cmd;

        private FEATURE() {
            this(null);
        }

        private FEATURE(String cmd) {
            this.cmd = cmd;
        }

        public String getID() {
            if (this.cmd == null) {
                return this.name();
            }
            return this.cmd;
        }

        public static FEATURE get(String input) {
            if (input != null && input.startsWith(" ")) {
                for (FEATURE feature : FEATURE.values()) {
                    if (!input.equalsIgnoreCase(" " + feature.getID())) continue;
                    return feature;
                }
            }
            return null;
        }
    }

    public static enum ENCODING {
        ASCII7BIT{

            @Override
            public String fromBytes(byte[] bytes) throws IOException {
                StringBuilder sb = new StringBuilder();
                for (int index = 0; index < bytes.length; ++index) {
                    int c = bytes[index] & 0xFF;
                    if (c <= 127) {
                        sb.append((char)c);
                        continue;
                    }
                    String hexEncoded = Integer.toString(c, 16);
                    if (hexEncoded.length() == 1) {
                        sb.append("%0");
                    } else {
                        sb.append("%");
                    }
                    sb.append(hexEncoded);
                }
                return sb.toString();
            }

            private final boolean isValidHex(char c) {
                return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
            }

            @Override
            public byte[] toBytes(String string) throws IOException {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                for (int index = 0; index < string.length(); ++index) {
                    char c = string.charAt(index);
                    if (c == '%' && string.length() >= index + 2 && this.isValidHex(string.charAt(index + 1)) && this.isValidHex(string.charAt(index + 2))) {
                        int hexDecoded = Integer.parseInt(string.substring(index + 1, index + 3), 16);
                        bos.write(hexDecoded);
                        index += 2;
                        continue;
                    }
                    bos.write(c);
                }
                return bos.toByteArray();
            }
        }
        ,
        UTF8{

            @Override
            public String fromBytes(byte[] bytes) throws IOException {
                return URLEncoder.encode(new String(bytes, "UTF-8"), "UTF-8");
            }

            @Override
            public byte[] toBytes(String string) throws IOException {
                return URLDecoder.decode(string, "UTF-8").getBytes("UTF-8");
            }
        };


        public abstract String fromBytes(byte[] var1) throws IOException;

        public abstract byte[] toBytes(String var1) throws IOException;
    }

    private static enum TYPE {
        FILE,
        DIR,
        LINK;

    }
}

